package com.ejianc.business.quality.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 体系文件-标准库、制度库-状态(启用、废止(修订)、废止)
 */
@Getter
@AllArgsConstructor
public enum SystemDocumentsStatusEnum {
    /**
     * 新增
     */
    ENABLE("NEW", "新增",0),
    /**
     * 修订
     */
    RECENSION("RECENSION", "修订",3),
    /**
     * 历史记录
     */
    HISTORY("HISTORY", "历史记录",1),
    /**
     * 废止
     */
    ABOLITION("ABOLITION", "废止",2),


    /**
     * 制度库——版本
     */
    V1("V1", "V1", 11111),
    V2("V2", "V2", 11111),
    V3("V3", "V3", 11111),
    V4("V4", "V4", 11111),
    V5("V5", "V5", 11111),
    V6("V6", "V6", 11111),
    V7("V7", "V7", 11111),
    V8("V8", "V8", 11111),
    V9("V9", "V9", 11111),
    V10("V10", "V10", 11111),
    ;

    private final String originCode;

    private final String originName;

    private final Integer apiCode;

    public static final SystemDocumentsStatusEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static String getNameByCode(String originCode) {
        for (SystemDocumentsStatusEnum statusEnum : values()) {
            if (statusEnum.getOriginCode().equals(originCode)) {
                return statusEnum.getOriginName();
            }
        }
        return "未知";
    }

    public static String getCodeByApiCode(Integer apiCode) {
        for (SystemDocumentsStatusEnum statusEnum : values()) {
            if (statusEnum.getApiCode().equals(apiCode)) {
                return statusEnum.getOriginCode();
            }
        }
        return "未知";
    }
}
