package com.ejianc.business.quality.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.dao.ReviewPlanDao;
import com.ejianc.business.quality.entity.ReviewPlanEntity;
import com.ejianc.business.quality.model.vo.ReviewPlanVo;
import com.ejianc.business.quality.service.ReviewPlanServer;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 */
@Service
@Slf4j
@RequiredArgsConstructor
public class ReviewPlanServerImpl implements ReviewPlanServer {
    private final ReviewPlanDao dao;
    private final SessionManager sessionManager;

    @Override
    public ReviewPlanVo saveOrUpdate(ReviewPlanVo saveOrUpdateVO) {
        ReviewPlanEntity entity = BeanMapper.map(saveOrUpdateVO, ReviewPlanEntity.class);
        UserContext userContext = sessionManager.getUserContext();

        entity.setOrgId(userContext.getOrgId());
        entity.setOrgName(userContext.getOrgName());
        entity.setParentOrgId(userContext.getDeptId());
        entity.setParentOrgName(userContext.getDeptName());
        if (Objects.isNull(entity.getId())) {
            entity.setCreateUserName(userContext.getUserName());
        } else {
            entity.setUpdateUserName(userContext.getUserName());
            entity.setCreateUserName(dao.getById(entity.getId()).getCreateUserName());
        }
        entity.setUploadProject(userContext.getDeptName());
        entity.setUploadUserName(userContext.getUserName());
        dao.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ReviewPlanVo.class);
    }

    @Override
    public CommonResponse<Object> del(List<ReviewPlanVo> vos) {
        try {
            List<Long> ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
            dao.removeByIds(ids, true);
            return CommonResponse.success("删除成功！");
        } catch (Exception e) {
            return CommonResponse.success("删除失败:" + e.getMessage());
        }
    }

    @Override
    public ReviewPlanVo detail(Long id) {
        ReviewPlanEntity reviewPlanEntity = dao.selectById(id);
        return BeanMapper.map(reviewPlanEntity, ReviewPlanVo.class);
    }

    @Override
    public IPage<ReviewPlanVo> list(QueryParam param) {
        param.getFuzzyFields().addAll(Arrays.asList("fileTopic", "createUserName", "reviewPlanFile", "uploadProject","content"));

        param.getOrderMap().put("createTime", QueryParam.DESC);

        IPage<ReviewPlanEntity> page = dao.queryPage(param, false);
        IPage<ReviewPlanVo> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ReviewPlanVo.class));

        return pageData;
    }

    @Override
    public void excelExport(List<Long> ids, HttpServletResponse response) {
        List<ReviewPlanEntity> list = dao.lambdaQuery().in(BaseEntity::getId, ids).list();
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("reviewPlanExport.xlsx", beans, response);
        } catch (Exception e) {
            throw new BusinessException("管理评审计划导出失败：" + e.getMessage());
        }
    }
}
