/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.enums;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.beust.jcommander.internal.Lists;
import java.util.List;
import java.util.StringJoiner;

public enum ApplicableScopeEnum {
    DEPARTMENT("DEPARTMENT", "\u516c\u53f8\u90e8\u95e8", "0"),
    STRAIGHTPIPES("STRAIGHTPIPES", "\u516c\u53f8\u76f4\u7ba1\u9879\u76ee", "1"),
    AFFILIATIONPROJECT("AFFILIATIONPROJECT", "\u516c\u53f8\u6240\u5c5e\u5355\u4f4d/\u9879\u76ee", "2");

    private final String scopeCode;
    private final String scopeName;
    private final String apiCode;
    public static final ApplicableScopeEnum[] VALUES;

    public static String getNamesByCodes(String scopeCode) {
        JSONArray objects = JSONUtil.parseArray((Object)scopeCode, (boolean)true);
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Object object : objects) {
            for (ApplicableScopeEnum applicableScopeEnum : ApplicableScopeEnum.values()) {
                if (!applicableScopeEnum.getScopeCode().equals(object)) continue;
                stringJoiner.add(applicableScopeEnum.getScopeName());
            }
        }
        return stringJoiner.toString();
    }

    public static String conversionApiData(String syfw) {
        String[] split = syfw.split(",");
        List objects = Lists.newArrayList();
        for (String apiCode : split) {
            String scopeCodeByApiCode = ApplicableScopeEnum.getScopeCodeByApiCode(apiCode);
            objects.add(scopeCodeByApiCode);
        }
        return JSONUtil.toJsonStr((Object)objects);
    }

    public static String getScopeCodeByApiCode(String apiCode) {
        for (ApplicableScopeEnum applicableScopeEnum : ApplicableScopeEnum.values()) {
            if (!applicableScopeEnum.getApiCode().equals(apiCode)) continue;
            return applicableScopeEnum.getScopeCode();
        }
        return "errorCode";
    }

    public String getScopeCode() {
        return this.scopeCode;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public String getApiCode() {
        return this.apiCode;
    }

    private ApplicableScopeEnum(String scopeCode, String scopeName, String apiCode) {
        this.scopeCode = scopeCode;
        this.scopeName = scopeName;
        this.apiCode = apiCode;
    }

    static {
        VALUES = ApplicableScopeEnum.values();
    }
}

