package com.ejianc.business.quality.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReviewRefineAdviceVo;
import com.ejianc.business.quality.service.ReviewRefineAdviceServer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
* @Author: LCL
* @Date: 2024/6/22 上午10:32
* @Description: 管理评审-改进建议
*/
@Controller
@RequestMapping("reviewRefineAdvice")
@RequiredArgsConstructor
public class ReviewRefineAdviceController {
    private final ReviewRefineAdviceServer server;
    /**
     * 新增或编辑
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ReviewRefineAdviceVo> saveOrUpdate(@RequestBody ReviewRefineAdviceVo saveOrUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", server.saveOrUpdate(saveOrUpdateVO));
    }

    /**
     * 删除
     */
    @RequestMapping(value = "del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Object> del(@RequestBody List<ReviewRefineAdviceVo> vos) {
        return server.del(vos);
    }

    /**
     * 详情
     */
    @RequestMapping(value = "detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ReviewRefineAdviceVo> detail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("管理评审改进建议-详情", server.detail(id));
    }

    /**
     * 查询
     */
    @RequestMapping(value = "list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ReviewRefineAdviceVo>> list(@RequestBody QueryParam param) {
        return CommonResponse.success("管理评审改进建议-查询", server.list(param));
    }

    /**
     * 导出
     */
    @RequestMapping(value = "excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> excelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.excelExport(ids, response);
        return CommonResponse.success("管理评审改进建议-导出成功");
    }

}
