package com.ejianc.business.quality.model.vo;

import com.ejianc.business.quality.enums.SystemDocumentsOriginEnum;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotEmpty;
import java.sql.Date;
import java.util.List;

 /**
 * @Author: LCL
 * @Date: 2024/5/17 上午9:54
 * @Description:
  * @Description: 体系文件-标准库编辑入参
 */
@EqualsAndHashCode(callSuper = true)
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class SysDocStandardEditVo extends BaseVO {
    /**
     * 分类(本部、分子公司、项目)
     *
     * @see com.ejianc.business.quality.enums.QualityTypeEnum
     */
    @NotEmpty(message = "分类不能为空")
    private String type;

    /**
     * 来源(OA、ZTPC)
     *
     * @see SystemDocumentsOriginEnum
     */
    @Builder.Default
    private String origin = SystemDocumentsOriginEnum.ZTPC.getOriginCode();

    /**
     * 文件编号
     */
    private String wjbh;

    /**
     * 文件名称
     */
    private String wjmc;

    /**
     * 文件内容 url地址
     */
    private String wjnr;

    /**
     * 适用项目类别(核电、火电、送变电、风电、光伏、市政、房建、通用)
     *
     * @see com.ejianc.business.quality.enums.ApplicableProjectCategoriesEnum
     */
    private List<String> syxmlb;

    /**
     * 适用范围(公司部门、公司直管项目、公司所属单位/项目)
     *
     * @see com.ejianc.business.quality.enums.ApplicableScopeEnum
     */
    private List<String> syfw;

    /**
     * 状态(启用、废止(修订)、废止)
     *
     * @see com.ejianc.business.quality.enums.SystemDocumentsStatusEnum
     */
    private String zt;

    /**
     * 备注
     */
    private String bz;

    /**
     * 发布日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date fbrq;

    /**
     * 实施日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date ssrq;

    /**
     * 归属管理体系
     *
     * @see com.ejianc.business.quality.enums.ManagementSystemEnum
     */
    @NotEmpty(message = "归属管理体系不能为空")
    private List<String> gltx;

    /**
     * 编码
     */
    private String bm;

     /**
      * 编制单位
      */
     private BaseInfoVo bzdw;

     /**
      * 编制部门
      */
     private BaseInfoVo bzbm;

     /**
      * 复审时间
      */
     @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
     private Date fssj;

     /**
      * 替代信息
      */
     private String tdxx;

     /**
      * 归口单位
      */
     private String gkdw;

     /**
      * 版本
      */
     private String bb;

     /**
      * 起草人
      */
     private BaseInfoVo qcr;

     /**
      * 引用标准
      */
     private String yybz;

    /**
     * 编制人账号
     */
    @NotEmpty(message = "编制人不能为空")
    private String preparedUserCode;

     /**
      * 所属项目部Id
      */
     private Long orgId;

     /**
      * 所属项目部名称
      */
     private String orgName;
}
