/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.additional.query.impl.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.additional.update.impl.LambdaUpdateChainWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.quality.dao.InternalAuditsDao;
import com.ejianc.business.quality.dao.MonitoringReportDao;
import com.ejianc.business.quality.dao.NonConformityDao;
import com.ejianc.business.quality.entity.InternalAuditsEntity;
import com.ejianc.business.quality.entity.MonitoringReportEntity;
import com.ejianc.business.quality.entity.NonConformityEntity;
import com.ejianc.business.quality.enums.ManagementSystemEnum;
import com.ejianc.business.quality.enums.MonitoringReportTypeEnum;
import com.ejianc.business.quality.enums.NonConformityTypeEnum;
import com.ejianc.business.quality.enums.QualityTypeEnum;
import com.ejianc.business.quality.model.po.InternalAuditsExcelPo;
import com.ejianc.business.quality.model.po.NonConformityNcrExcelPo;
import com.ejianc.business.quality.model.po.NonConformityObserveExcelPo;
import com.ejianc.business.quality.model.vo.InternalAuditsAddVo;
import com.ejianc.business.quality.model.vo.InternalAuditsEditVo;
import com.ejianc.business.quality.model.vo.NonConformityAddVo;
import com.ejianc.business.quality.model.vo.NonConformityEditVo;
import com.ejianc.business.quality.service.InternalAuditsServer;
import com.ejianc.business.quality.util.DetailIndexExcelReader;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service
public class InternalAuditsServerImpl
implements InternalAuditsServer {
    private static final Logger log = LoggerFactory.getLogger(InternalAuditsServerImpl.class);
    private final InternalAuditsDao internalAuditsDao;
    private final NonConformityDao nonConformityDao;
    private final MonitoringReportDao monitoringReportDao;
    private final SessionManager sessionManager;

    @Override
    public InternalAuditsEntity add(InternalAuditsAddVo vo) {
        InternalAuditsEntity internalAuditsEntity = new InternalAuditsEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)internalAuditsEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            internalAuditsEntity.setOrgId(userContext.getOrgId());
            internalAuditsEntity.setOrgName(userContext.getOrgName());
            internalAuditsEntity.setCreateUserName(userContext.getUserName());
            this.internalAuditsDao.save((Object)internalAuditsEntity);
            return internalAuditsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public InternalAuditsEntity edit(InternalAuditsEditVo vo) {
        InternalAuditsEntity internalAuditsEntity = new InternalAuditsEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)internalAuditsEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            internalAuditsEntity.setUpdateUserName(userContext.getUserName());
            internalAuditsEntity.setCreateUserName(((InternalAuditsEntity)((Object)this.internalAuditsDao.getById(vo.getId()))).getCreateUserName());
            this.internalAuditsDao.updateById((Object)internalAuditsEntity);
            return internalAuditsEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<InternalAuditsEntity> list(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("auditReportsName");
        fuzzyFields.add("auditPlanName");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.internalAuditsDao.queryPage(param, false);
    }

    @Override
    public InternalAuditsEntity detail(Long id) {
        return (InternalAuditsEntity)((Object)this.internalAuditsDao.getById(id));
    }

    @Override
    public void del(List<Long> ids) {
        try {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.internalAuditsDao.lambdaUpdate().set(BaseEntity::getDr, (Object)1)).in(BaseEntity::getId, ids)).update();
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public void internalAuditsExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.internalAuditsDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            String type = QualityTypeEnum.getNameByCode(item.getType());
            item.setType(type);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("internalAuditsExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResponse<JSONObject> internalAuditsExcelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<InternalAuditsExcelPo> internalAuditsExcelPoList = new ArrayList<InternalAuditsExcelPo>();
        ArrayList errorList = new ArrayList();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        for (int i = 0; i < result.size(); ++i) {
            InternalAuditsExcelPo internalAuditsExcelPo2 = InternalAuditsServerImpl.getInternalAuditsExcelPo(result, i);
            internalAuditsExcelPoList.add(internalAuditsExcelPo2);
        }
        try {
            List successList = Lists.newArrayList();
            UserContext userContext = this.sessionManager.getUserContext();
            internalAuditsExcelPoList.forEach(internalAuditsExcelPo -> {
                InternalAuditsEntity internalAuditsEntity = new InternalAuditsEntity();
                BeanUtils.copyProperties((Object)internalAuditsExcelPo, (Object)((Object)internalAuditsEntity));
                internalAuditsEntity.setCreateUserName(userContext.getUserName());
                internalAuditsEntity.setUploadTime(new Date(System.currentTimeMillis()));
                internalAuditsEntity.setOrgId(userContext.getOrgId());
                internalAuditsEntity.setOrgName(userContext.getOrgName());
                internalAuditsEntity.setParentOrgId(userContext.getDeptId());
                internalAuditsEntity.setParentOrgName(userContext.getDeptName());
                successList.add(internalAuditsEntity);
            });
            JSONObject json = new JSONObject();
            json.put("successList", (Object)successList);
            json.put("errorList", errorList);
            return CommonResponse.success((Object)json);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5bfc\u5165\u5f02\u5e38");
        }
    }

    @Override
    public void excelImportSave(List<InternalAuditsEntity> importVos) {
        try {
            this.internalAuditsDao.saveBatch(importVos);
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    @Override
    public NonConformityEntity nonConformityAdd(NonConformityAddVo vo) {
        NonConformityEntity nonConformityEntity = new NonConformityEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)nonConformityEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            nonConformityEntity.setOrgId(userContext.getOrgId());
            nonConformityEntity.setOrgName(userContext.getOrgName());
            nonConformityEntity.setCreateUserName(userContext.getUserName());
            this.nonConformityDao.save((Object)nonConformityEntity);
            return nonConformityEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public NonConformityEntity nonConformityEdit(NonConformityEditVo vo) {
        NonConformityEntity nonConformityEntity = new NonConformityEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)nonConformityEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            nonConformityEntity.setUpdateUserName(userContext.getUserName());
            nonConformityEntity.setCreateUserName(((NonConformityEntity)((Object)this.nonConformityDao.getById(vo.getId()))).getCreateUserName());
            this.nonConformityDao.updateById((Object)nonConformityEntity);
            return nonConformityEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<NonConformityEntity> nonConformityList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factsName");
        fuzzyFields.add("gslx");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.nonConformityDao.queryPage(param, false);
    }

    @Override
    public NonConformityEntity nonConformityDetail(Long id) {
        return (NonConformityEntity)((Object)this.nonConformityDao.getById(id));
    }

    @Override
    public void nonConformityDel(List<Long> ids) {
        try {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.nonConformityDao.lambdaUpdate().set(BaseEntity::getDr, (Object)1)).in(BaseEntity::getId, ids)).update();
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838-\u4e0d\u7b26\u5408\u9879\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResponse<JSONObject> nonConformityExcelImport(String excelType, HttpServletRequest request) {
        if (!"observe".equals(excelType) && !"ncr".equals(excelType)) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838-\u4e0d\u7b26\u5408\u9879\u5bfc\u5165\u5931\u8d25\uff0cexcelType\u9519\u8bef");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<NonConformityNcrExcelPo> ncrExcelPoList = new ArrayList<NonConformityNcrExcelPo>();
        ArrayList<NonConformityObserveExcelPo> observeExcelPoList = new ArrayList<NonConformityObserveExcelPo>();
        JSONObject json = new JSONObject();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        List successList = Lists.newArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = userContext.getUserCode();
        Long orgId = userContext.getOrgId();
        String orgName = userContext.getOrgName();
        ArrayList errorList = new ArrayList();
        if ("observe".equals(excelType)) {
            for (int i = 0; i < result.size(); ++i) {
                NonConformityObserveExcelPo nonConformityObserveExcelPo = InternalAuditsServerImpl.getNonConformityObserveExcelPo(result, i);
                observeExcelPoList.add(nonConformityObserveExcelPo);
            }
            try {
                observeExcelPoList.forEach(companyGoalsExcelPo -> {
                    NonConformityEntity nonConformityEntity = new NonConformityEntity();
                    BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)nonConformityEntity));
                    nonConformityEntity.setCreateUserName(userContext.getUserName());
                    nonConformityEntity.setConformityType("\u89c2\u5bdf\u9879");
                    nonConformityEntity.setPreparedUserCode(userCode);
                    nonConformityEntity.setCreateUserName(userContext.getUserName());
                    nonConformityEntity.setOrgId(orgId);
                    nonConformityEntity.setOrgName(orgName);
                    nonConformityEntity.setParentOrgId(userContext.getDeptId());
                    nonConformityEntity.setParentOrgName(userContext.getDeptName());
                    if (NonConformityTypeEnum.CODELIST.contains(nonConformityEntity.getGllx()) && ManagementSystemEnum.CODELIST.contains(nonConformityEntity.getGstx()) && QualityTypeEnum.CODELIST.contains(nonConformityEntity.getType())) {
                        successList.add(nonConformityEntity);
                    } else {
                        errorList.add(nonConformityEntity);
                    }
                });
                json.put("successList", (Object)successList);
                this.nonConformityDao.saveBatch(successList);
                errorList.forEach(e -> {
                    e.setId(RandomUtil.randomLong());
                    e.setType(QualityTypeEnum.getNameByCode(e.getType()));
                    e.setGllx(NonConformityTypeEnum.getNameByCode(e.getGllx()));
                    e.setGstx(ManagementSystemEnum.getNameByCode(e.getGstx()));
                });
                json.put("errorList", errorList);
                return CommonResponse.success((Object)json);
            }
            catch (Exception e2) {
                throw new BusinessException("\u4e0d\u7b26\u5408\u89c2\u5bdf\u9879\u5f02\u5e38");
            }
        }
        for (int i = 0; i < result.size(); ++i) {
            NonConformityNcrExcelPo nonConformityNcrExcelPo = InternalAuditsServerImpl.getNonConformityNcrExcelPo(result, i);
            ncrExcelPoList.add(nonConformityNcrExcelPo);
        }
        try {
            ncrExcelPoList.forEach(companyGoalsExcelPo -> {
                NonConformityEntity nonConformityEntity = new NonConformityEntity();
                BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)nonConformityEntity));
                nonConformityEntity.setCreateUserName(userContext.getUserName());
                nonConformityEntity.setConformityType("NCR");
                nonConformityEntity.setPreparedUserCode(userCode);
                nonConformityEntity.setCreateUserName(userContext.getUserName());
                nonConformityEntity.setOrgId(orgId);
                nonConformityEntity.setOrgName(orgName);
                nonConformityEntity.setParentOrgId(userContext.getDeptId());
                nonConformityEntity.setParentOrgName(userContext.getDeptName());
                if (ManagementSystemEnum.CODELIST.contains(nonConformityEntity.getGstx()) && QualityTypeEnum.CODELIST.contains(nonConformityEntity.getType())) {
                    successList.add(nonConformityEntity);
                } else {
                    errorList.add(nonConformityEntity);
                }
            });
            json.put("successList", (Object)successList);
            this.nonConformityDao.saveBatch(successList);
            errorList.forEach(e -> {
                e.setId(RandomUtil.randomLong());
                e.setType(QualityTypeEnum.getNameByCode(e.getType()));
                e.setGllx(NonConformityTypeEnum.getNameByCode(e.getGllx()));
                e.setGstx(ManagementSystemEnum.getNameByCode(e.getGstx()));
            });
            json.put("errorList", errorList);
            return CommonResponse.success((Object)json);
        }
        catch (Exception e3) {
            throw new BusinessException("\u4e0d\u7b26\u5408NCR\u5bfc\u5165\u5f02\u5e38");
        }
    }

    @Override
    public void nonConformityExcelImportSave(List<NonConformityEntity> importVos) {
        try {
            this.nonConformityDao.saveOrUpdateBatch(importVos);
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0d\u7b26\u5408\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    @Override
    public void nonConformityExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.nonConformityDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            if (StrUtil.isNotEmpty((CharSequence)item.getGllx())) {
                String gllx = NonConformityTypeEnum.getNameByCode(item.getGllx());
                item.setGllx(gllx);
            }
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String gstx = ManagementSystemEnum.getNameByCode(item.getGstx());
            item.setType(type);
            item.setGstx(gstx);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("internalAuditsExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u4e0d\u7b26\u5408\u9879\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResponse<List<Object>> nonConformityGetYear() {
        List list = this.nonConformityDao.lambdaQuery().list();
        List observationsList = list.stream().filter(e -> "\u89c2\u5bdf\u9879".equals(e.getConformityType())).sorted(Comparator.comparing(BaseEntity::getCreateTime)).collect(Collectors.toList());
        String oldObservations = DateUtil.format((java.util.Date)((NonConformityEntity)((Object)observationsList.get(0))).getCreateTime(), (String)"yyyy");
        String newObservations = DateUtil.format((java.util.Date)((NonConformityEntity)((Object)observationsList.get(observationsList.size() - 1))).getCreateTime(), (String)"yyyy");
        List ncrList = list.stream().filter(e -> "NCR".equals(e.getConformityType())).sorted(Comparator.comparing(BaseEntity::getCreateTime)).collect(Collectors.toList());
        String oldNcr = DateUtil.format((java.util.Date)((NonConformityEntity)((Object)ncrList.get(0))).getCreateTime(), (String)"yyyy");
        String newNcr = DateUtil.format((java.util.Date)((NonConformityEntity)((Object)ncrList.get(ncrList.size() - 1))).getCreateTime(), (String)"yyyy");
        List objects = Lists.newArrayList();
        Triple ncr = Triple.of((Object)"NCR", (Object)oldNcr, (Object)newNcr);
        Triple observations = Triple.of((Object)"\u89c2\u5bdf\u9879", (Object)oldObservations, (Object)newObservations);
        objects.add(ncr);
        objects.add(observations);
        return CommonResponse.success((Object)objects);
    }

    @Override
    public CommonResponse<JSONObject> nonConformityStatistics() {
        List list = this.nonConformityDao.list();
        Map<String, Long> gllx = list.stream().filter(e -> e.getGllx() != null).collect(Collectors.groupingBy(NonConformityEntity::getGllx, Collectors.counting()));
        Map<String, Long> gstx = list.stream().filter(e -> e.getGstx() != null).collect(Collectors.groupingBy(NonConformityEntity::getGstx, Collectors.counting()));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("gllx", gllx);
        jsonObject.put("gstx", gstx);
        return CommonResponse.success((Object)jsonObject);
    }

    private static NonConformityNcrExcelPo getNonConformityNcrExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityNcrExcelPo nonConformityNcrExcelPo = new NonConformityNcrExcelPo();
        String type = data.get(0);
        String unitName = data.get(1);
        String year = data.get(2);
        String factsName = data.get(3);
        String bfhbzh = data.get(4);
        String gstx = data.get(5);
        nonConformityNcrExcelPo.setType(QualityTypeEnum.getCodeByName(type));
        nonConformityNcrExcelPo.setUnitName(unitName);
        nonConformityNcrExcelPo.setYear(year);
        nonConformityNcrExcelPo.setFactsName(factsName);
        nonConformityNcrExcelPo.setBfhbzh(bfhbzh);
        nonConformityNcrExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        return nonConformityNcrExcelPo;
    }

    private static NonConformityObserveExcelPo getNonConformityObserveExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityObserveExcelPo nonConformityObserveExcelPo = new NonConformityObserveExcelPo();
        String type = data.get(0);
        String unitName = data.get(1);
        String year = data.get(2);
        String factsName = data.get(3);
        String gllx = data.get(4);
        String gstx = data.get(5);
        nonConformityObserveExcelPo.setType(QualityTypeEnum.getCodeByName(type));
        nonConformityObserveExcelPo.setUnitName(unitName);
        nonConformityObserveExcelPo.setYear(year);
        nonConformityObserveExcelPo.setFactsName(factsName);
        nonConformityObserveExcelPo.setGllx(NonConformityTypeEnum.getCodeByName(gllx));
        nonConformityObserveExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        return nonConformityObserveExcelPo;
    }

    private static InternalAuditsExcelPo getInternalAuditsExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        InternalAuditsExcelPo internalAuditsExcelPo = new InternalAuditsExcelPo();
        String type = data.get(0);
        String auditReportsName = data.get(1);
        String auditPlanName = data.get(2);
        internalAuditsExcelPo.setType(type);
        internalAuditsExcelPo.setAuditReportsName(auditReportsName);
        internalAuditsExcelPo.setAuditPlanName(auditPlanName);
        return internalAuditsExcelPo;
    }

    @Override
    public MonitoringReportEntity monitoringReportAdd(NonConformityAddVo vo) {
        MonitoringReportEntity nonConformityEntity = new MonitoringReportEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)nonConformityEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            nonConformityEntity.setOrgId(userContext.getOrgId());
            nonConformityEntity.setOrgName(userContext.getOrgName());
            nonConformityEntity.setCreateUserName(userContext.getUserName());
            this.monitoringReportDao.save((Object)nonConformityEntity);
            return nonConformityEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u65b0\u589e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public MonitoringReportEntity monitoringReportEdit(NonConformityEditVo vo) {
        MonitoringReportEntity nonConformityEntity = new MonitoringReportEntity();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)nonConformityEntity));
        try {
            UserContext userContext = this.sessionManager.getUserContext();
            nonConformityEntity.setUpdateUserName(userContext.getUserName());
            nonConformityEntity.setCreateUserName(((MonitoringReportEntity)((Object)this.monitoringReportDao.getById(vo.getId()))).getCreateUserName());
            this.monitoringReportDao.updateById((Object)nonConformityEntity);
            return nonConformityEntity;
        }
        catch (Exception e) {
            throw new BusinessException("\u7f16\u8f91\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    @Override
    public IPage<MonitoringReportEntity> monitoringReportList(QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factsName");
        fuzzyFields.add("gslx");
        fuzzyFields.add("orgName");
        LinkedHashMap<String, String> orderMap = new LinkedHashMap<String, String>(param.getOrderMap());
        orderMap.put("createTime", "desc");
        param.setOrderMap(orderMap);
        return this.monitoringReportDao.queryPage(param, false);
    }

    @Override
    public MonitoringReportEntity monitoringReportDetail(Long id) {
        return (MonitoringReportEntity)((Object)this.monitoringReportDao.getById(id));
    }

    @Override
    public void monitoringReportDel(List<Long> ids) {
        try {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.monitoringReportDao.lambdaUpdate().set(BaseEntity::getDr, (Object)1)).in(BaseEntity::getId, ids)).update();
        }
        catch (Exception e) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838-\u76d1\u7763\u76d1\u5bdf\u62a5\u544a\u5220\u9664\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    @Override
    public CommonResponse<JSONObject> monitoringReportExcelImport(String excelType, HttpServletRequest request) {
        if (!"observe".equals(excelType) && !"ncr".equals(excelType)) {
            throw new BusinessException("\u5185\u90e8\u5ba1\u6838-\u76d1\u7763\u76d1\u5bdf\u62a5\u544a\u5bfc\u5165\u5931\u8d25\uff0cexcelType\u9519\u8bef");
        }
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<NonConformityNcrExcelPo> ncrExcelPoList = new ArrayList<NonConformityNcrExcelPo>();
        ArrayList<NonConformityObserveExcelPo> observeExcelPoList = new ArrayList<NonConformityObserveExcelPo>();
        JSONObject json = new JSONObject();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            throw new BusinessException("\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            throw new BusinessException("\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        List successList = Lists.newArrayList();
        UserContext userContext = this.sessionManager.getUserContext();
        String userCode = userContext.getUserCode();
        Long orgId = userContext.getOrgId();
        String orgName = userContext.getOrgName();
        ArrayList errorList = new ArrayList();
        if ("observe".equals(excelType)) {
            for (int i = 0; i < result.size(); ++i) {
                NonConformityObserveExcelPo nonConformityObserveExcelPo = InternalAuditsServerImpl.getMonitoringReportObserveExcelPo(result, i);
                observeExcelPoList.add(nonConformityObserveExcelPo);
            }
            try {
                observeExcelPoList.forEach(companyGoalsExcelPo -> {
                    MonitoringReportEntity nonConformityEntity = new MonitoringReportEntity();
                    BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)nonConformityEntity));
                    nonConformityEntity.setCreateUserName(userContext.getUserName());
                    nonConformityEntity.setConformityType("\u89c2\u5bdf\u9879");
                    nonConformityEntity.setPreparedUserCode(userCode);
                    nonConformityEntity.setCreateUserName(userContext.getUserName());
                    nonConformityEntity.setOrgId(orgId);
                    nonConformityEntity.setOrgName(orgName);
                    nonConformityEntity.setParentOrgId(userContext.getDeptId());
                    nonConformityEntity.setParentOrgName(userContext.getDeptName());
                    if (MonitoringReportTypeEnum.CODELIST.contains(nonConformityEntity.getGllx()) && ManagementSystemEnum.CODELIST.contains(nonConformityEntity.getGstx()) && QualityTypeEnum.CODELIST.contains(nonConformityEntity.getType())) {
                        successList.add(nonConformityEntity);
                    } else {
                        errorList.add(nonConformityEntity);
                    }
                });
                json.put("successList", (Object)successList);
                this.monitoringReportDao.saveBatch(successList);
                errorList.forEach(e -> {
                    e.setId(RandomUtil.randomLong());
                    e.setType(QualityTypeEnum.getNameByCode(e.getType()));
                    e.setGllx(MonitoringReportTypeEnum.getNameByCode(e.getGllx()));
                    e.setGstx(ManagementSystemEnum.getNameByCode(e.getGstx()));
                });
                json.put("errorList", errorList);
                return CommonResponse.success((Object)json);
            }
            catch (Exception e2) {
                throw new BusinessException("\u76d1\u7763\u76d1\u5bdf\u62a5\u544a\u89c2\u5bdf\u9879\u5f02\u5e38");
            }
        }
        for (int i = 0; i < result.size(); ++i) {
            NonConformityNcrExcelPo nonConformityNcrExcelPo = InternalAuditsServerImpl.getNonConformityNcrExcelPo(result, i);
            ncrExcelPoList.add(nonConformityNcrExcelPo);
        }
        try {
            ncrExcelPoList.forEach(companyGoalsExcelPo -> {
                MonitoringReportEntity nonConformityEntity = new MonitoringReportEntity();
                BeanUtils.copyProperties((Object)companyGoalsExcelPo, (Object)((Object)nonConformityEntity));
                nonConformityEntity.setCreateUserName(userContext.getUserName());
                nonConformityEntity.setConformityType("NCR");
                nonConformityEntity.setPreparedUserCode(userCode);
                nonConformityEntity.setCreateUserName(userContext.getUserName());
                nonConformityEntity.setOrgId(orgId);
                nonConformityEntity.setOrgName(orgName);
                nonConformityEntity.setParentOrgId(userContext.getDeptId());
                nonConformityEntity.setParentOrgName(userContext.getDeptName());
                if (ManagementSystemEnum.CODELIST.contains(nonConformityEntity.getGstx()) && QualityTypeEnum.CODELIST.contains(nonConformityEntity.getType())) {
                    successList.add(nonConformityEntity);
                } else {
                    errorList.add(nonConformityEntity);
                }
            });
            json.put("successList", (Object)successList);
            this.monitoringReportDao.saveBatch(successList);
            errorList.forEach(e -> {
                e.setId(RandomUtil.randomLong());
                e.setType(QualityTypeEnum.getNameByCode(e.getType()));
                e.setGllx(MonitoringReportTypeEnum.getNameByCode(e.getGllx()));
                e.setGstx(ManagementSystemEnum.getNameByCode(e.getGstx()));
            });
            json.put("errorList", errorList);
            return CommonResponse.success((Object)json);
        }
        catch (Exception e3) {
            throw new BusinessException("\u76d1\u7763\u76d1\u5bdf\u62a5\u544aNCR\u5bfc\u5165\u5f02\u5e38");
        }
    }

    private static NonConformityObserveExcelPo getMonitoringReportObserveExcelPo(List<List<String>> result, int i) {
        List<String> data = result.get(i);
        NonConformityObserveExcelPo nonConformityObserveExcelPo = new NonConformityObserveExcelPo();
        String type = data.get(0);
        String unitName = data.get(1);
        String year = data.get(2);
        String factsName = data.get(3);
        String gllx = data.get(4);
        String gstx = data.get(5);
        nonConformityObserveExcelPo.setType(QualityTypeEnum.getCodeByName(type));
        nonConformityObserveExcelPo.setUnitName(unitName);
        nonConformityObserveExcelPo.setYear(year);
        nonConformityObserveExcelPo.setFactsName(factsName);
        nonConformityObserveExcelPo.setGllx(MonitoringReportTypeEnum.getCodeByName(gllx));
        nonConformityObserveExcelPo.setGstx(ManagementSystemEnum.getCodeByName(gstx));
        return nonConformityObserveExcelPo;
    }

    @Override
    public void monitoringReportExcelImportSave(List<MonitoringReportEntity> importVos) {
        try {
            this.monitoringReportDao.saveOrUpdateBatch(importVos);
        }
        catch (Exception e) {
            throw new BusinessException("\u76d1\u7763\u76d1\u5bdf\u62a5\u544a\u5bfc\u5165\u4fdd\u5b58\u5f02\u5e38");
        }
    }

    @Override
    public void monitoringReportExcelExport(List<Long> ids, HttpServletResponse response) {
        List list = ((LambdaQueryChainWrapper)this.monitoringReportDao.lambdaQuery().in(BaseEntity::getId, ids)).list();
        list.forEach(item -> {
            if (StrUtil.isNotEmpty((CharSequence)item.getGllx())) {
                String gllx = MonitoringReportTypeEnum.getNameByCode(item.getGllx());
                item.setGllx(gllx);
            }
            String type = QualityTypeEnum.getNameByCode(item.getType());
            String gstx = ManagementSystemEnum.getNameByCode(item.getGstx());
            item.setType(type);
            item.setGstx(gstx);
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        try {
            ExcelExport.getInstance().export("internalAuditsExport.xlsx", beans, response);
        }
        catch (Exception e) {
            throw new BusinessException("\u76d1\u7763\u76d1\u5bdf\u62a5\u544a\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public InternalAuditsServerImpl(InternalAuditsDao internalAuditsDao, NonConformityDao nonConformityDao, MonitoringReportDao monitoringReportDao, SessionManager sessionManager) {
        this.internalAuditsDao = internalAuditsDao;
        this.nonConformityDao = nonConformityDao;
        this.monitoringReportDao = monitoringReportDao;
        this.sessionManager = sessionManager;
    }
}

