package com.ejianc.business.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.entity.MonitoringReportEntity;
import com.ejianc.business.quality.model.vo.NonConformityAddVo;
import com.ejianc.business.quality.model.vo.NonConformityEditVo;
import com.ejianc.business.quality.service.InternalAuditsServer;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.List;

/**
 * @author 朱若尘
 * @since 2025-07-28
 */
@Controller
@RequestMapping("internalAudits")
@RequiredArgsConstructor
public class MonitoringReportController {
    private final InternalAuditsServer server;

    /**
     * 监督监察报告-新增
     *
     * @param vo NonConformityAddVo
     * @return 结果
     */
    @RequestMapping(value = "monitoringReport/add", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonitoringReportEntity> monitoringReportAdd(@RequestBody @Valid NonConformityAddVo vo) {
        return CommonResponse.success("内部审核-监督监察报告-新增成功", server.monitoringReportAdd(vo));
    }

    /**
     * 监督监察报告-编辑
     *
     * @param vo NonConformityAddVo
     * @return 结果
     */
    @RequestMapping(value = "monitoringReport/edit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonitoringReportEntity> monitoringReportEdit(@RequestBody @Valid NonConformityEditVo vo) {
        return CommonResponse.success("内部审核-监督监察报告-编辑成功", server.monitoringReportEdit(vo));
    }

    /**
     * 监督监察报告-查询
     *
     * @param param param
     * @return IPage<InternalAuditsEntity>
     */
    @RequestMapping(value = "monitoringReport/list", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonitoringReportEntity>> monitoringReportList(@RequestBody QueryParam param) {
        return CommonResponse.success("内部审核-监督监察报告-查询", server.monitoringReportList(param));
    }

    /**
     * 监督监察报告-详情
     *
     * @param id id
     * @return InternalAuditsEntity
     */
    @RequestMapping(value = "monitoringReport/detail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonitoringReportEntity> monitoringReportDetail(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("内部审核-监督监察报告-查询", server.monitoringReportDetail(id));
    }

    /**
     * 监督监察报告-删除
     */
    @RequestMapping(value = "monitoringReport/del", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> monitoringReportDel(@RequestBody List<Long> ids) {
        server.monitoringReportDel(ids);
        return CommonResponse.success("内部审核-监督监察报告-删除成功");
    }

    /**
     * 监督监察报告-导入
     *
     * @param excelType 类型 observe观察项  ncr NCR
     * @param request   request
     * @return 结果
     */
    @RequestMapping(value = "monitoringReport/excelImport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<JSONObject> monitoringReportExcelImport(@RequestParam("excelType") String excelType, HttpServletRequest request) {
        return server.monitoringReportExcelImport(excelType, request);
    }

    /**
     * 监督监察报告-导入保存
     *
     * @return 结果
     */
    @RequestMapping(value = "monitoringReport/excelImport/save", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Boolean> monitoringReportExcelImportSave(@RequestBody List<MonitoringReportEntity> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error("导入的数据为空！");
        }
        server.monitoringReportExcelImportSave(importVos);
        return CommonResponse.success("内部审核-监督监察报告-导入成功");
    }

    /**
     * 监督监察报告-导出
     *
     * @param ids      ids
     * @param response response
     */
    @RequestMapping(value = "monitoringReport/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> monitoringReportExcelExport(@RequestBody List<Long> ids, HttpServletResponse response) {
        server.monitoringReportExcelExport(ids, response);
        return CommonResponse.success("内部审核-监督监察报告-导出成功");
    }

    /**
     * 监督监察报告-获取年份
     */
    @RequestMapping(value = "monitoringReport/getYear", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Object>> nonConformityGetYear() {
        return server.monitoringReportGetYear();
    }

    /**
     * 监督监察报告-统计
     */
    @RequestMapping(value = "monitoringReport/statistics", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> nonConformityStatistics() {
        return server.monitoringReportStatistics();
    }
}
