package com.ejianc.business.quality.enums;

import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONUtil;
import com.beust.jcommander.internal.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.List;
import java.util.StringJoiner;

/**
 * @Author: LCL
 * @Date: 2024/5/10 下午2:57
 * @Description: 适用项目类别(核电 、 火电 、 送变电 、 风电 、 光伏 、 市政 、 房建 、 通用)
 */
@Getter
@AllArgsConstructor
public enum ApplicableProjectCategoriesEnum {
    /**
     * 核电项目
     */
    HEDIAN("HEDIAN", "核电项目", "0"),
    /**
     * 火电项目
     */
    HUODIAN("HUODIAN", "火电项目", "1"),
    /**
     * 送变电项目
     */
    SONGBIANDIAN("SONGBIANDIAN", "送变电项目", "2"),
    /**
     * 风电项目
     */
    FENGDIAN("FENGDIAN", "风电项目", "3"),
    /**
     * 光伏项目
     */
    GUANGFU("GUANGFU", "光伏项目", "4"),
    /**
     * 市政项目
     */
    SHIZHENG("SHIZHENG", "市政项目", "5"),
    /**
     * 房建项目
     */
    FANGJIAN("FANGJIAN", "房建项目", "6"),
    /**
     * 通用
     */
    GENERAL("GENERAL", "通用", "7"),
    ;

    private final String projectCode;

    private final String projectName;

    private final String apiCode;

    public static final ApplicableProjectCategoriesEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static String getNamesByCodes(String scopeCode) {
        JSONArray objects = JSONUtil.parseArray(scopeCode, true);
        StringJoiner stringJoiner = new StringJoiner(",");
        for (Object object : objects) {
            for (ApplicableProjectCategoriesEnum applicableScopeEnum : values()) {
                if (applicableScopeEnum.getProjectCode().equals(object)) {
                    stringJoiner.add(applicableScopeEnum.getProjectName());
                }
            }
        }
        return stringJoiner.toString();
    }


    /**
     * api数据转换
     */
    public static String conversionApiData(String syfw) {
        String[] split = syfw.split(",");
        List<String> objects = Lists.newArrayList();
        for (String apiCode : split) {
            String scopeCodeByApiCode = getScopeCodeByApiCode(apiCode);
            objects.add(scopeCodeByApiCode);
        }
        return JSONUtil.toJsonStr(objects);
    }

    public static String getScopeCodeByApiCode(String apiCode) {
        for (ApplicableProjectCategoriesEnum applicableProjectCategoriesEnum : values()) {
            if (applicableProjectCategoriesEnum.getApiCode().equals(apiCode)) {
                return applicableProjectCategoriesEnum.getProjectCode();
            }
        }
        return "errorCode";
    }
}
