package com.ejianc.business.quality.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 监督监察报告——管理类型
 * @author 朱若尘
 * @since 2025-07-28
 */
@Getter
@AllArgsConstructor
public enum MonitoringReportTypeEnum {
    ZZ("ZZ", "组织"),
    WJKZ("WJKZ", "文件控制"),
    SJKZ("SJKZ", "设计控制"),
    CGKZ("CGKZ", "采购控制"),
    WXKZ("WXKZ", "物项控制"),
    GYGCKZ("GYGCKZ", "工艺工程控制"),
    JCHSYKZ("JCHSYKZ", "检查和试验控制"),
    DBFHXDKZ("DBFHXDKZ", "对不符合项的控制"),
    JZCS("JZCS", "纠正措施"),
    JL("JL", "记录"),
    JC("JC", "监查"),
    FZJ("FZJ", "防造假"),
    ;

    private final String typeCode;

    private final String typeName;

    public static final MonitoringReportTypeEnum[] VALUES;

    static {
        VALUES = values();
    }

    public static final List<String> CODELIST = Arrays.stream(VALUES).map(MonitoringReportTypeEnum::getTypeCode).collect(Collectors.toList());

    public static String getNameByCode(String typeCode) {
        for (MonitoringReportTypeEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getTypeCode().equals(typeCode)) {
                return managementSystemEnum.getTypeName();
            }
        }
        return "未知";
    }

    public static String getCodeByName(String typeName) {
        for (MonitoringReportTypeEnum managementSystemEnum : values()) {
            if (managementSystemEnum.getTypeName().equals(typeName)) {
                return managementSystemEnum.getTypeCode();
            }
        }
        return "errorCode";
    }
}
