package com.ejianc.business.quality.model.res;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;


/**
* @Author: LCL
* @Date: 2024/12/2 上午10:33
* @Description: oa制度库api返回
*/
@Data
@AllArgsConstructor
@NoArgsConstructor
public class OaInstitutionalRes {

    @JsonProperty("success")
    private Boolean success;
    @JsonProperty("errorCode")
    private Integer errorCode;
    @JsonProperty("errorInfo")
    private String errorInfo;
    @JsonProperty("data")
    private List<DataDTO> data;
    @JsonProperty("space")
    private Integer space;
    @JsonProperty("jdbcQuerySpace")
    private Integer jdbcQuerySpace;
    @JsonProperty("affectedRow")
    private Object affectedRow;
    @JsonProperty("header")
    private Object header;
    @JsonProperty("page")
    private PageDTO page;
    @JsonProperty("requestSQL")
    private Object requestSQL;
    @JsonProperty("timestamp")
    private Object timestamp;
    @JsonProperty("traceId")
    private String traceId;

    @NoArgsConstructor
    @Data
    public static class PageDTO {
        @JsonProperty("totalPage")
        private Integer totalPage;
        @JsonProperty("pageSize")
        private Integer pageSize;
        @JsonProperty("totalCount")
        private Integer totalCount;
        @JsonProperty("currentPage")
        private Integer currentPage;
    }

    @NoArgsConstructor
    @Data
    public static class DataDTO {
        @JsonProperty("id")
        private Integer id;
        @JsonProperty("requestId")
        private Object requestId;
        @JsonProperty("lsh")
        private String lsh;
        @JsonProperty("cjr")
        private Integer cjr;
        @JsonProperty("cjrq")
        private String cjrq;
        @JsonProperty("bm")
        private Integer bm;
        @JsonProperty("szdw")
        private Integer szdw;
        @JsonProperty("xglc")
        private String xglc;
        @JsonProperty("xgfj")
        private String xgfj;
        @JsonProperty("bz")
        private String bz;
        @JsonProperty("zdbt")
        private String zdbt;
        @JsonProperty("zdzw")
        private Integer zdzw;
        @JsonProperty("zdbh")
        private String zdbh;
        @JsonProperty("zddj")
        private Integer zddj;
        @JsonProperty("gsbb")
        private Integer gsbb;
        @JsonProperty("zgs")
        private Integer zgs;
        @JsonProperty("fgs")
        private Integer fgs;
        @JsonProperty("zgxm")
        private Integer zgxm;
        @JsonProperty("sjzdly")
        private Object sjzdly;
        @JsonProperty("fbrq")
        private String fbrq;
        @JsonProperty("zdbb")
        private Integer zdbb;
        @JsonProperty("zdglbm")
        private Object zdglbm;
        @JsonProperty("formmodeid")
        private Integer formmodeid;
        @JsonProperty("modedatacreater")
        private Integer modedatacreater;
        @JsonProperty("modedatacreatertype")
        private Integer modedatacreatertype;
        @JsonProperty("modedatacreatedate")
        private String modedatacreatedate;
        @JsonProperty("modedatacreatetime")
        private String modedatacreatetime;
        @JsonProperty("modedatamodifier")
        private Integer modedatamodifier;
        @JsonProperty("modedatamodifydatetime")
        private String modedatamodifydatetime;
        @JsonProperty("form_biz_id")
        private String formBizId;
        @JsonProperty("MODEUUID")
        private String modeuuid;
        @JsonProperty("yhzt")
        private Integer yhzt;
        @JsonProperty("fwh")
        private String fwh;
        @JsonProperty("ndjh")
        private Integer ndjh;
        @JsonProperty("zdfj")
        private String zdfj;
        @JsonProperty("zdfl")
        private String zdfl;
        @JsonProperty("qqidcfzd")
        private String qqidcfzd;
        @JsonProperty("xsyczt")
        private Integer xsyczt;
        @JsonProperty("zdbtllanxz")
        private Object zdbtllanxz;
        @JsonProperty("sflszd")
        private Integer sflszd;
        @JsonProperty("zdqqidzd")
        private String zdqqidzd;
        @JsonProperty("syjg")
        private String syjg;
        @JsonProperty("spjg")
        private String spjg;
        @JsonProperty("lszd")
        private Object lszd;
        @JsonProperty("lszdqqid")
        private String lszdqqid;
        @JsonProperty("bzbm")
        private Integer bzbm;
        @JsonProperty("bzdw")
        private Integer bzdw;
        @JsonProperty("zdpdfzw")
        private Object zdpdfzw;
        @JsonProperty("bfdwmc")
        private Object bfdwmc;
    }
}
