package com.ejianc.business.quality.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.quality.model.vo.ReviewPlanVo;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @Author: DJF
 * @Date: 2024/5/21 上午9:50
 * @Description: 评审管理-计划
 */
public interface ReviewPlanServer {
    /**
     * 新增或编辑
     *
     * @param saveOrUpdateVO saveOrUpdateVO
     * @return ReviewPlanVo
     */
    ReviewPlanVo saveOrUpdate(ReviewPlanVo saveOrUpdateVO);

    /**
     * 删除
     *
     * @param vos vos
     * @return 结果
     */
    CommonResponse<Object> del(List<ReviewPlanVo> vos);

    /**
     * 详情
     *
     * @param id id
     * @return ReviewPlanVo
     */
    ReviewPlanVo detail(Long id);

    /**
     * 查询
     *
     * @param param param
     * @return IPage<ReviewPlanVo>
     */
    IPage<ReviewPlanVo> list(QueryParam param);

    /**
     * 导出
     *
     * @param ids      ids
     * @param response 文件
     */
    void excelExport(List<Long> ids, HttpServletResponse response);
}
