package com.ejianc.business.scene.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 安全费用使用情况
 * 
 * @author generator
 * 
 */
public class PlanUseVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer state; // 状态
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long employeeId; // 填报人id
    private String employeeName; // 填报人名称
    private String employeeCode; // 填报人编码
    private String employeePart; // 填报人部门
    private Long orgId; // 组织id
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String secondUnit; // 二级单位
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 编制日期
    private Long projectTypeId; // 项目类型id
    private String projectTypeName; // 项目类型name
    private Integer accureRateType; // 计提比例类型,1-0%,2-1.5%,3-2.0%,4-2.5%,5-3.0%,6-3.5%,7-3.75%
    private BigDecimal planFeeMny; // 计划费用(万元)
    private BigDecimal planValueMny; // 计划产值(万元)
    private BigDecimal accureMny; // 计提金额(万元)
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date monthDate; // 使用月份
    private BigDecimal financialAccureMny; // 财务计提金额(万元)
    private BigDecimal sumMonthUseMny; // 月度累计使用费用(万元)
    private BigDecimal monthUseMny; // 本期使用费用(万元)
    private String billStateName; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private BigDecimal lastSumMonthUseMny; // 上期月度累计使用费用(万元)

    public BigDecimal getLastSumMonthUseMny() {
        return lastSumMonthUseMny;
    }

    public void setLastSumMonthUseMny(BigDecimal lastSumMonthUseMny) {
        this.lastSumMonthUseMny = lastSumMonthUseMny;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    private List<PlanUseDetailVO> planUseDetailList = new ArrayList<>(); // 安全费用使用情况-子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectTypeId() {
        return projectTypeId;
    }
    @ReferDeserialTransfer
    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Integer getAccureRateType() {
        return accureRateType;
    }

    public void setAccureRateType(Integer accureRateType) {
        this.accureRateType = accureRateType;
    }
    public BigDecimal getPlanFeeMny() {
        return planFeeMny;
    }

    public void setPlanFeeMny(BigDecimal planFeeMny) {
        this.planFeeMny = planFeeMny;
    }
    public BigDecimal getPlanValueMny() {
        return planValueMny;
    }

    public void setPlanValueMny(BigDecimal planValueMny) {
        this.planValueMny = planValueMny;
    }
    public BigDecimal getAccureMny() {
        return accureMny;
    }

    public void setAccureMny(BigDecimal accureMny) {
        this.accureMny = accureMny;
    }
    public Date getMonthDate() {
        return monthDate;
    }

    public void setMonthDate(Date monthDate) {
        this.monthDate = monthDate;
    }
    public BigDecimal getFinancialAccureMny() {
        return financialAccureMny;
    }

    public void setFinancialAccureMny(BigDecimal financialAccureMny) {
        this.financialAccureMny = financialAccureMny;
    }
    public BigDecimal getSumMonthUseMny() {
        return sumMonthUseMny;
    }

    public void setSumMonthUseMny(BigDecimal sumMonthUseMny) {
        this.sumMonthUseMny = sumMonthUseMny;
    }
    public BigDecimal getMonthUseMny() {
        return monthUseMny;
    }

    public void setMonthUseMny(BigDecimal monthUseMny) {
        this.monthUseMny = monthUseMny;
    }
    
     public List<PlanUseDetailVO> getPlanUseDetailList() {
        return planUseDetailList;
     }

     public void setPlanUseDetailList(List<PlanUseDetailVO> planUseDetailList) {
        this.planUseDetailList = planUseDetailList;
     }
}
