package com.ejianc.business.scene.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 安全费用月度计划
 * 
 * @author generator
 * 
 */
public class PlanMonthUseAnalysisVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private String name; // 科目名称
    private String code; // 科目编码
    private Integer state; // 状态
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long employeeId; // 填报人id
    private String employeeName; // 填报人名称
    private String employeeCode; // 填报人编码
    private String employeePart; // 填报人部门
    private Long orgId; // 组织id
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String secondUnit; // 二级单位
    private String memo; // 备注
    private Date createDate; // 编制日期
    private Long projectTypeId; // 项目类型id
    private String projectTypeName; // 项目类型name
    private Integer accureRateType; // 计提比例类型,1-0%,2-1.5%,3-2.0%,4-2.5%,5-3.0%,6-3.5%,7-3.75%
    private String accureRateTypeName; // 计提比例类型,1-0%,2-1.5%,3-2.0%,4-2.5%,5-3.0%,6-3.5%,7-3.75%

    private BigDecimal planValueMny; // 计划产值(万元)
    private BigDecimal accureMny; // 计提金额(万元)
    @JsonFormat(pattern = "yyyy-MM", timezone = "GMT+8")
    private Date monthDate; // 计划月份

    private String billStateName; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Integer accureStatus; // 计提状态: 0- 未计提,1-已计提
    private String accureStatusName; // 计提状态: 0- 未计提,1-已计提

    private BigDecimal financialAccureMny; // 财务计提金额(万元)
    private BigDecimal accureRate; // 计提使用率
    private BigDecimal planFeeMny; // 计划金额合计
    private BigDecimal useFeeMny; // 使用金额合计
    private BigDecimal useFeeRate; // 使用比例

    //    安全防护设施设备支出
    private BigDecimal aqfhPLanMny; // 计划金额
    private BigDecimal aqfhUseMny; // 使用金额
    private BigDecimal aqfhRate; // 使用比例
//    应急救援设备演练支出
    private BigDecimal yjjyPLanMny; // 计划金额
    private BigDecimal yjjyUseMny; // 使用金额
    private BigDecimal yjjyRate; // 使用比例
    //    重大危险源评估整改支出
    private BigDecimal zdwxPLanMny; // 计划金额
    private BigDecimal zdwxUseMny; // 使用金额
    private BigDecimal zdwxRate; // 使用比例
    //    安全检查和标准化支出
    private BigDecimal aqjcPLanMny; // 计划金额
    private BigDecimal aqjcUseMny; // 使用金额
    private BigDecimal aqjcRate; // 使用比例
    //    安全防护用品支出
    private BigDecimal aqfhypPLanMny; // 计划金额
    private BigDecimal aqfhypUseMny; // 使用金额
    private BigDecimal aqfhypRate; // 使用比例
    //    安全宣传教育培训支出
    private BigDecimal aqxcPLanMny; // 计划金额
    private BigDecimal aqxcUseMny; // 使用金额
    private BigDecimal aqxcRate; // 使用比例
    //   安全四新技术应用支出
    private BigDecimal aqsxPLanMny; // 计划金额
    private BigDecimal aqsxUseMny; // 使用金额
    private BigDecimal aqsxRate; // 使用比例
    //   安全设施设备检测支出
    private BigDecimal aqssPLanMny; // 计划金额
    private BigDecimal aqssUseMny; // 使用金额
    private BigDecimal aqssRate; // 使用比例
    //   安全生产责任保险支出
    private BigDecimal aqscPLanMny; // 计划金额
    private BigDecimal aqscUseMny; // 使用金额
    private BigDecimal aqscRate; // 使用比例
    //  其他安全相关费用支出
    private BigDecimal qtaqPLanMny; // 计划金额
    private BigDecimal qtaqUseMny; // 使用金额
    private BigDecimal qtaqRate; // 使用比例







    private List<PlanMonthDetailVO> planMonthDetailList = new ArrayList<>(); // 安全费用月度计划-子表

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getAccureRate() {
        return accureRate;
    }

    public void setAccureRate(BigDecimal accureRate) {
        this.accureRate = accureRate;
    }

    public BigDecimal getUseFeeMny() {
        return useFeeMny;
    }

    public void setUseFeeMny(BigDecimal useFeeMny) {
        this.useFeeMny = useFeeMny;
    }

    public BigDecimal getUseFeeRate() {
        return useFeeRate;
    }

    public void setUseFeeRate(BigDecimal useFeeRate) {
        this.useFeeRate = useFeeRate;
    }

    public BigDecimal getAqfhPLanMny() {
        return aqfhPLanMny;
    }

    public void setAqfhPLanMny(BigDecimal aqfhPLanMny) {
        this.aqfhPLanMny = aqfhPLanMny;
    }

    public BigDecimal getAqfhUseMny() {
        return aqfhUseMny;
    }

    public void setAqfhUseMny(BigDecimal aqfhUseMny) {
        this.aqfhUseMny = aqfhUseMny;
    }

    public BigDecimal getAqfhRate() {
        return aqfhRate;
    }

    public void setAqfhRate(BigDecimal aqfhRate) {
        this.aqfhRate = aqfhRate;
    }

    public BigDecimal getYjjyPLanMny() {
        return yjjyPLanMny;
    }

    public void setYjjyPLanMny(BigDecimal yjjyPLanMny) {
        this.yjjyPLanMny = yjjyPLanMny;
    }

    public BigDecimal getYjjyUseMny() {
        return yjjyUseMny;
    }

    public void setYjjyUseMny(BigDecimal yjjyUseMny) {
        this.yjjyUseMny = yjjyUseMny;
    }

    public BigDecimal getYjjyRate() {
        return yjjyRate;
    }

    public void setYjjyRate(BigDecimal yjjyRate) {
        this.yjjyRate = yjjyRate;
    }

    public BigDecimal getZdwxPLanMny() {
        return zdwxPLanMny;
    }

    public void setZdwxPLanMny(BigDecimal zdwxPLanMny) {
        this.zdwxPLanMny = zdwxPLanMny;
    }

    public BigDecimal getZdwxUseMny() {
        return zdwxUseMny;
    }

    public void setZdwxUseMny(BigDecimal zdwxUseMny) {
        this.zdwxUseMny = zdwxUseMny;
    }

    public BigDecimal getZdwxRate() {
        return zdwxRate;
    }

    public void setZdwxRate(BigDecimal zdwxRate) {
        this.zdwxRate = zdwxRate;
    }

    public BigDecimal getAqjcPLanMny() {
        return aqjcPLanMny;
    }

    public void setAqjcPLanMny(BigDecimal aqjcPLanMny) {
        this.aqjcPLanMny = aqjcPLanMny;
    }

    public BigDecimal getAqjcUseMny() {
        return aqjcUseMny;
    }

    public void setAqjcUseMny(BigDecimal aqjcUseMny) {
        this.aqjcUseMny = aqjcUseMny;
    }

    public BigDecimal getAqjcRate() {
        return aqjcRate;
    }

    public void setAqjcRate(BigDecimal aqjcRate) {
        this.aqjcRate = aqjcRate;
    }

    public BigDecimal getAqfhypPLanMny() {
        return aqfhypPLanMny;
    }

    public void setAqfhypPLanMny(BigDecimal aqfhypPLanMny) {
        this.aqfhypPLanMny = aqfhypPLanMny;
    }

    public BigDecimal getAqfhypUseMny() {
        return aqfhypUseMny;
    }

    public void setAqfhypUseMny(BigDecimal aqfhypUseMny) {
        this.aqfhypUseMny = aqfhypUseMny;
    }

    public BigDecimal getAqfhypRate() {
        return aqfhypRate;
    }

    public void setAqfhypRate(BigDecimal aqfhypRate) {
        this.aqfhypRate = aqfhypRate;
    }

    public BigDecimal getAqxcPLanMny() {
        return aqxcPLanMny;
    }

    public void setAqxcPLanMny(BigDecimal aqxcPLanMny) {
        this.aqxcPLanMny = aqxcPLanMny;
    }

    public BigDecimal getAqxcUseMny() {
        return aqxcUseMny;
    }

    public void setAqxcUseMny(BigDecimal aqxcUseMny) {
        this.aqxcUseMny = aqxcUseMny;
    }

    public BigDecimal getAqxcRate() {
        return aqxcRate;
    }

    public void setAqxcRate(BigDecimal aqxcRate) {
        this.aqxcRate = aqxcRate;
    }

    public BigDecimal getAqsxPLanMny() {
        return aqsxPLanMny;
    }

    public void setAqsxPLanMny(BigDecimal aqsxPLanMny) {
        this.aqsxPLanMny = aqsxPLanMny;
    }

    public BigDecimal getAqsxUseMny() {
        return aqsxUseMny;
    }

    public void setAqsxUseMny(BigDecimal aqsxUseMny) {
        this.aqsxUseMny = aqsxUseMny;
    }

    public BigDecimal getAqsxRate() {
        return aqsxRate;
    }

    public void setAqsxRate(BigDecimal aqsxRate) {
        this.aqsxRate = aqsxRate;
    }

    public BigDecimal getAqssPLanMny() {
        return aqssPLanMny;
    }

    public void setAqssPLanMny(BigDecimal aqssPLanMny) {
        this.aqssPLanMny = aqssPLanMny;
    }

    public BigDecimal getAqssUseMny() {
        return aqssUseMny;
    }

    public void setAqssUseMny(BigDecimal aqssUseMny) {
        this.aqssUseMny = aqssUseMny;
    }

    public BigDecimal getAqssRate() {
        return aqssRate;
    }

    public void setAqssRate(BigDecimal aqssRate) {
        this.aqssRate = aqssRate;
    }

    public BigDecimal getAqscPLanMny() {
        return aqscPLanMny;
    }

    public void setAqscPLanMny(BigDecimal aqscPLanMny) {
        this.aqscPLanMny = aqscPLanMny;
    }

    public BigDecimal getAqscUseMny() {
        return aqscUseMny;
    }

    public void setAqscUseMny(BigDecimal aqscUseMny) {
        this.aqscUseMny = aqscUseMny;
    }

    public BigDecimal getAqscRate() {
        return aqscRate;
    }

    public void setAqscRate(BigDecimal aqscRate) {
        this.aqscRate = aqscRate;
    }

    public BigDecimal getQtaqPLanMny() {
        return qtaqPLanMny;
    }

    public void setQtaqPLanMny(BigDecimal qtaqPLanMny) {
        this.qtaqPLanMny = qtaqPLanMny;
    }

    public BigDecimal getQtaqUseMny() {
        return qtaqUseMny;
    }

    public void setQtaqUseMny(BigDecimal qtaqUseMny) {
        this.qtaqUseMny = qtaqUseMny;
    }

    public BigDecimal getQtaqRate() {
        return qtaqRate;
    }

    public void setQtaqRate(BigDecimal qtaqRate) {
        this.qtaqRate = qtaqRate;
    }

    public Integer getAccureStatus() {
        return accureStatus;
    }

    public void setAccureStatus(Integer accureStatus) {
        this.accureStatus = accureStatus;
    }

    public String getAccureStatusName() {
        return accureStatusName;
    }

    public void setAccureStatusName(String accureStatusName) {
        this.accureStatusName = accureStatusName;
    }

    public String getAccureRateTypeName() {
        return accureRateTypeName;
    }

    public void setAccureRateTypeName(String accureRateTypeName) {
        this.accureRateTypeName = accureRateTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getProjectTypeId() {
        return projectTypeId;
    }
    @ReferDeserialTransfer
    public void setProjectTypeId(Long projectTypeId) {
        this.projectTypeId = projectTypeId;
    }
    public String getProjectTypeName() {
        return projectTypeName;
    }

    public void setProjectTypeName(String projectTypeName) {
        this.projectTypeName = projectTypeName;
    }
    public Integer getAccureRateType() {
        return accureRateType;
    }

    public void setAccureRateType(Integer accureRateType) {
        this.accureRateType = accureRateType;
    }
    public BigDecimal getPlanFeeMny() {
        return planFeeMny;
    }

    public void setPlanFeeMny(BigDecimal planFeeMny) {
        this.planFeeMny = planFeeMny;
    }
    public BigDecimal getPlanValueMny() {
        return planValueMny;
    }

    public void setPlanValueMny(BigDecimal planValueMny) {
        this.planValueMny = planValueMny;
    }
    public BigDecimal getAccureMny() {
        return accureMny;
    }

    public void setAccureMny(BigDecimal accureMny) {
        this.accureMny = accureMny;
    }
    public Date getMonthDate() {
        return monthDate;
    }

    public void setMonthDate(Date monthDate) {
        this.monthDate = monthDate;
    }
    public BigDecimal getFinancialAccureMny() {
        return financialAccureMny;
    }

    public void setFinancialAccureMny(BigDecimal financialAccureMny) {
        this.financialAccureMny = financialAccureMny;
    }
    
     public List<PlanMonthDetailVO> getPlanMonthDetailList() {
        return planMonthDetailList;
     }

     public void setPlanMonthDetailList(List<PlanMonthDetailVO> planMonthDetailList) {
        this.planMonthDetailList = planMonthDetailList;
     }
}
