package com.ejianc.business.safety.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.quality.bean.QualityAcceptEntity;
import com.ejianc.business.safety.bean.*;
import com.ejianc.business.safety.mapper.PlanMonthMapper;
import com.ejianc.business.safety.service.IPlanMonthDetailService;
import com.ejianc.business.safety.service.IPlanUseService;
import com.ejianc.business.scene.vo.*;
import com.ejianc.business.util.CommonUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.safety.service.IPlanMonthService;

/**
 * 安全费用月度计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("planMonth")
public class PlanMonthController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "QUALITY_MONTH_PLAN";//此处需要根据实际修改

    @Autowired
    private IPlanMonthService service;
    @Autowired
    private IPlanUseService planUseService;


    @Autowired
    private IPlanMonthDetailService planMonthDetailService;
    private static final DateTimeFormatter YEAR_MONTH_FORMATTER =
            DateTimeFormatter.ofPattern("yyyyMM");

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private PlanMonthMapper planMonthMapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanMonthVO> saveOrUpdate(@RequestBody PlanMonthVO saveOrUpdateVO) {
    	PlanMonthEntity entity = BeanMapper.map(saveOrUpdateVO, PlanMonthEntity.class);
        entity.setAccureStatus(0);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //设置parentID
        List<PlanMonthDetailEntity> detailList = entity.getPlanMonthDetailList();
        if (!detailList.isEmpty()) {
            Map<String, Long> idMap = new HashMap<>();
            for (PlanMonthDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (sd.getId() == null || entity.getId() == null) {
                        sd.setId(IdWorker.getId());
                    }
                    idMap.put(sd.getTid(), sd.getId());
                    sd.setParentId(null);
                }
            }
            for (PlanMonthDetailEntity sd : detailList) {
                if (!("del").equals(sd.getRowState())){
                    if (StringUtils.isNotEmpty(sd.getTpid())) {
                        sd.setParentId(idMap.get(sd.getTpid()));
                    }
                }
            }
        }

    	service.saveOrUpdate(entity, false);
    	PlanMonthVO vo = BeanMapper.map(entity, PlanMonthVO.class);
        List<PlanMonthDetailVO> detailAllList = vo.getPlanMonthDetailList();
        if (!detailList.isEmpty()) {
            for (PlanMonthDetailVO detail : detailAllList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanMonthDetailList(TreeNodeBUtil.buildTree(detailAllList));
        }

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PlanMonthVO> queryDetail(Long id) {
    	PlanMonthEntity entity = service.selectById(id);
    	PlanMonthVO vo = BeanMapper.map(entity, PlanMonthVO.class);
        List<PlanMonthDetailVO> detailList = vo.getPlanMonthDetailList();
        if (!detailList.isEmpty()) {
            for (PlanMonthDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0 ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanMonthDetailList(TreeNodeBUtil.buildTree(detailList));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description 更新财务计提金额
     */
    @RequestMapping(value = "/updateDataById", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PlanMonthVO> updateDataById(@RequestBody PlanMonthVO saveOrUpdateVO) {
        PlanMonthEntity planMonthEntity = service.selectById(saveOrUpdateVO.getId());
        planMonthEntity.setFinancialAccureMny(saveOrUpdateVO.getFinancialAccureMny());
        planMonthEntity.setAccureStatus(1);
        service.updateById(planMonthEntity);
        PlanMonthVO planMonthVO = BeanMapper.map(planMonthEntity, PlanMonthVO.class);

        return CommonResponse.success("查询详情数据成功！",planMonthVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanMonthVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PlanMonthVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PlanMonthVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanMonthVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectTypeName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlanMonthEntity> page = service.queryPage(param,false);
        IPage<PlanMonthVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PlanMonthVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * @Description queryList 安全费用趋势分析
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/feeUseAnalysis", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PlanMonthUseAnalysisVO>> feeUseAnalysis(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");

        /** 租户隔离 */
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PlanMonthEntity> page = service.queryPage(param,false);
        IPage<PlanMonthUseAnalysisVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<PlanMonthUseAnalysisVO> planMonthVOS = BeanMapper.mapList(page.getRecords(), PlanMonthUseAnalysisVO.class);
        getData(planMonthVOS);
        pageData.setRecords(planMonthVOS);

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    private void getData(List<PlanMonthUseAnalysisVO> planMonthVOS) {
        if (CollectionUtils.isNotEmpty(planMonthVOS)){

            List<Long> projectIds = planMonthVOS.stream().map(PlanMonthUseAnalysisVO::getProjectId).collect(Collectors.toList());
            List<Long> ids = planMonthVOS.stream().map(PlanMonthUseAnalysisVO::getId).collect(Collectors.toList());
            //获取使用金额合计
            LambdaQueryWrapper<PlanUseEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(PlanUseEntity::getProjectId,projectIds);
            queryWrapper.in(PlanUseEntity::getBillState,1,3);
            List<PlanUseEntity> useEntityList = planUseService.list(queryWrapper);
            Map<String, BigDecimal> numUseMap = useEntityList.stream()
                    .collect(Collectors.groupingBy(
                            score -> score.getProjectId() + "_" +
                                    score.getMonthDate().toInstant()
                                            .atZone(ZoneId.systemDefault())
                                            .toLocalDate()
                                            .format(YEAR_MONTH_FORMATTER),
                            Collectors.collectingAndThen(
                                    Collectors.toList(),
                                    m -> m.stream()
                                            .map(a -> a.getMonthUseMny())
                                            .reduce(BigDecimal.ZERO, BigDecimal::add)
                            )
                    ));

            //获取计划金额子表信息
            LambdaQueryWrapper<PlanMonthDetailEntity> queryPLanDetailWrapper = new LambdaQueryWrapper<>();
            queryPLanDetailWrapper.in(PlanMonthDetailEntity::getMid,ids);
            List<PlanMonthDetailEntity> planMonthDetailEntityList = planMonthDetailService.list(queryPLanDetailWrapper);
            Map<String, BigDecimal> numPlanDetailMap = planMonthDetailEntityList.stream()
            .collect(Collectors.groupingBy(
                    score -> score.getMid() + "_" +
                            score.getName(),
                    Collectors.collectingAndThen(
                            Collectors.toList(),
                            m -> m.stream()
                                    .map(a -> a.getMonthPlanDetailMny())
                                    .reduce(BigDecimal.ZERO, BigDecimal::add)
                    )
            ));

            List<PlanMonthUseAnalysisVO> planMonthUseAnalysisVOS = planMonthMapper.queryuseDetailMnyByProjectIds(projectIds);
            Map<String, BigDecimal> numUseDetailMap = planMonthUseAnalysisVOS.stream()
                    .collect(Collectors.groupingBy(
                            score -> score.getProjectId() + "_" + score.getName() + "_" +
                                    score.getMonthDate().toInstant()
                                            .atZone(ZoneId.systemDefault())
                                            .toLocalDate()
                                            .format(YEAR_MONTH_FORMATTER),
                            Collectors.collectingAndThen(
                                    Collectors.toList(),
                                    m -> m.stream()
                                            .map(a -> a.getUseFeeMny())
                                            .reduce(BigDecimal.ZERO, BigDecimal::add)
                            )
                    ));


            for (PlanMonthUseAnalysisVO planMonthUseAnalysisVO : planMonthVOS){
                String keyUse = planMonthUseAnalysisVO.getProjectId() + "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);
                if (numUseMap.containsKey(keyUse)){
                    planMonthUseAnalysisVO.setUseFeeMny(numUseMap.get(keyUse));
                }
                //计算计提使用率
                planMonthUseAnalysisVO.setAccureRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getUseFeeMny(),planMonthUseAnalysisVO.getFinancialAccureMny()));
                //合计-使用比例
                planMonthUseAnalysisVO.setUseFeeRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getUseFeeMny(),planMonthUseAnalysisVO.getPlanFeeMny()));

                //计算10个一级科目数据
                //安全防护设施设备支出
                //获取计划金额
                String keyPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全防护设施设备支出";
                if (numPlanDetailMap.containsKey(keyPlanDetial)){
                    planMonthUseAnalysisVO.setAqfhPLanMny(numPlanDetailMap.get(keyPlanDetial));
                }

                String keyuseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全防护设施设备支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyuseDetial)){
                    planMonthUseAnalysisVO.setAqfhUseMny(numUseDetailMap.get(keyuseDetial));
                }
                planMonthUseAnalysisVO.setAqfhRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqfhUseMny(),planMonthUseAnalysisVO.getAqfhPLanMny()));
                //应急救援设备演练支出
//                private BigDecimal yjjyPLanMny; // 计划金额
//                private BigDecimal yjjyUseMny; // 使用金额
//                private BigDecimal yjjyRate; // 使用比例


                //获取计划金额
                String keyyjjyPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "应急救援设备演练支出";
                if (numPlanDetailMap.containsKey(keyyjjyPlanDetial)){
                    planMonthUseAnalysisVO.setYjjyPLanMny(numPlanDetailMap.get(keyyjjyPlanDetial));
                }
                String keyyjjyuseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "应急救援设备演练支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyyjjyuseDetial)){
                    planMonthUseAnalysisVO.setYjjyUseMny(numUseDetailMap.get(keyyjjyuseDetial));
                }
                planMonthUseAnalysisVO.setYjjyRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getYjjyUseMny(),planMonthUseAnalysisVO.getYjjyPLanMny()));
//                重大危险源评估整改支出
                //获取计划金额
                String keyZdwxPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "重大危险源评估整改支出";
                if (numPlanDetailMap.containsKey(keyZdwxPlanDetial)){
                    planMonthUseAnalysisVO.setZdwxPLanMny(numPlanDetailMap.get(keyZdwxPlanDetial));
                }

                String keyZdwxUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "重大危险源评估整改支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyZdwxUseDetial)){
                    planMonthUseAnalysisVO.setZdwxUseMny(numUseDetailMap.get(keyZdwxUseDetial));
                }
                planMonthUseAnalysisVO.setZdwxRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getZdwxUseMny(),planMonthUseAnalysisVO.getZdwxPLanMny()));
//                安全检查和标准化支出
                //获取计划金额
                String keyAqjcPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全检查和标准化支出";
                if (numPlanDetailMap.containsKey(keyAqjcPlanDetial)){
                    planMonthUseAnalysisVO.setAqjcPLanMny(numPlanDetailMap.get(keyAqjcPlanDetial));
                }

                String keyAqjcUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全检查和标准化支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyAqjcUseDetial)){
                    planMonthUseAnalysisVO.setAqjcUseMny(numUseDetailMap.get(keyAqjcUseDetial));
                }
                planMonthUseAnalysisVO.setAqjcRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqjcUseMny(),planMonthUseAnalysisVO.getAqjcPLanMny()));

//                安全防护用品支出
                //获取计划金额
                String keyAqfhypPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全防护用品支出";
                if (numPlanDetailMap.containsKey(keyAqfhypPlanDetial)){
                    planMonthUseAnalysisVO.setAqfhypPLanMny(numPlanDetailMap.get(keyAqfhypPlanDetial));
                }

                String keyAqfhypUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全防护用品支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyAqfhypUseDetial)){
                    planMonthUseAnalysisVO.setAqfhypUseMny(numUseDetailMap.get(keyAqfhypUseDetial));
                }
                planMonthUseAnalysisVO.setAqfhypRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqfhypUseMny(),planMonthUseAnalysisVO.getAqfhypPLanMny()));
//                安全宣传教育培训支出
                //获取计划金额
                String keyAqxcPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全宣传教育培训支出";
                if (numPlanDetailMap.containsKey(keyAqxcPlanDetial)){
                    planMonthUseAnalysisVO.setAqxcPLanMny(numPlanDetailMap.get(keyAqxcPlanDetial));
                }

                String keyAqxcUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全宣传教育培训支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyAqxcUseDetial)){
                    planMonthUseAnalysisVO.setAqxcUseMny(numUseDetailMap.get(keyAqxcUseDetial));
                }
                planMonthUseAnalysisVO.setAqxcRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqxcUseMny(),planMonthUseAnalysisVO.getAqxcPLanMny()));
//                安全四新技术应用支出
                //获取计划金额
                String keyAqsxPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全四新技术应用支出";
                if (numPlanDetailMap.containsKey(keyAqsxPlanDetial)){
                    planMonthUseAnalysisVO.setAqsxPLanMny(numPlanDetailMap.get(keyAqsxPlanDetial));
                }

                String keyAqsxUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全四新技术应用支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyAqsxUseDetial)){
                    planMonthUseAnalysisVO.setAqsxUseMny(numUseDetailMap.get(keyAqsxUseDetial));
                }
                planMonthUseAnalysisVO.setAqsxRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqsxUseMny(),planMonthUseAnalysisVO.getAqsxPLanMny()));
//                安全设施设备检测支出
                //获取计划金额
                String keyAqssPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全设施设备检测支出";
                if (numPlanDetailMap.containsKey(keyAqssPlanDetial)){
                    planMonthUseAnalysisVO.setAqssPLanMny(numPlanDetailMap.get(keyAqssPlanDetial));
                }

                String keyAqssUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全设施设备检测支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyAqssUseDetial)){
                    planMonthUseAnalysisVO.setAqssUseMny(numUseDetailMap.get(keyAqssUseDetial));
                }
                planMonthUseAnalysisVO.setAqssRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqssUseMny(),planMonthUseAnalysisVO.getAqssPLanMny()));

//                安全生产责任保险支出
                //获取计划金额
                String keyAqscPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "安全生产责任保险支出";
                if (numPlanDetailMap.containsKey(keyAqscPlanDetial)){
                    planMonthUseAnalysisVO.setAqscPLanMny(numPlanDetailMap.get(keyAqscPlanDetial));
                }

                String keyAqscUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "安全生产责任保险支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyAqscUseDetial)){
                    planMonthUseAnalysisVO.setAqscUseMny(numUseDetailMap.get(keyAqscUseDetial));
                }
                planMonthUseAnalysisVO.setAqscRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getAqscUseMny(),planMonthUseAnalysisVO.getAqscPLanMny()));
//                其他安全相关费用支出
                //获取计划金额
                String keyQtaqPlanDetial = planMonthUseAnalysisVO.getId() + "_" + "其他安全相关费用支出";
                if (numPlanDetailMap.containsKey(keyQtaqPlanDetial)){
                    planMonthUseAnalysisVO.setQtaqPLanMny(numPlanDetailMap.get(keyQtaqPlanDetial));
                }

                String keyQtaqUseDetial = planMonthUseAnalysisVO.getProjectId() + "_" + "其他安全相关费用支出"+ "_" + planMonthUseAnalysisVO.getMonthDate().toInstant()
                        .atZone(ZoneId.systemDefault())
                        .toLocalDate()
                        .format(YEAR_MONTH_FORMATTER);

                if (numUseDetailMap.containsKey(keyQtaqUseDetial)){
                    planMonthUseAnalysisVO.setQtaqUseMny(numUseDetailMap.get(keyQtaqUseDetial));
                }
                planMonthUseAnalysisVO.setQtaqRate(CommonUtils.calculateRate(planMonthUseAnalysisVO.getQtaqUseMny(),planMonthUseAnalysisVO.getQtaqPLanMny()));

            }

        }
    }

    /**
     * @Description 导出--安全费用趋势分析导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExportAnalysis", method = RequestMethod.POST)
    @ResponseBody
    public void excelExportAnalysis(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("parentOrgName");
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        /** 租户隔离 */
        List<Integer> billStateList = new ArrayList<>();
        billStateList.add(1);
        billStateList.add(3);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));

        List<PlanMonthEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<PlanMonthUseAnalysisVO> sceneCheckVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            sceneCheckVOS = BeanMapper.mapList(list, PlanMonthUseAnalysisVO.class);
            getData(sceneCheckVOS);
        }
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("PlanMonthAnalysis-export.xlsx", beans, response);
    }


    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PlanMonthEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<PlanMonthVO> sceneCheckVOS = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            sceneCheckVOS = BeanMapper.mapList(list, PlanMonthVO.class);
            for (PlanMonthVO workSummaryVO : sceneCheckVOS) {
                if (workSummaryVO.getAccureRateType().equals(1)){
                    workSummaryVO.setAccureRateTypeName("0%");
                }
                if (workSummaryVO.getAccureRateType().equals(2)){
                    workSummaryVO.setAccureRateTypeName("1.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(3)){
                    workSummaryVO.setAccureRateTypeName("2.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(4)){
                    workSummaryVO.setAccureRateTypeName("2.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(5)){
                    workSummaryVO.setAccureRateTypeName("3.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(6)){
                    workSummaryVO.setAccureRateTypeName("3.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(7)){
                    workSummaryVO.setAccureRateTypeName("3.75%");
                }
                //计提状态
                if (workSummaryVO.getAccureStatus().equals(0)){
                    workSummaryVO.setAccureStatusName("未计提");
                }
                if (workSummaryVO.getAccureStatus().equals(1)){
                    workSummaryVO.setAccureStatusName("已计提");
                }

                workSummaryVO.setBillStateName(BillStateEnum.getEnumByStateCode(workSummaryVO.getBillState()).getDescription());
            }

        }
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("PlanMonth-export.xlsx", beans, response);
    }





    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refPlanMonthData", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> refPlanMonthData(@RequestParam(value = "searchText", required = false) String searchText,
                                                     @RequestParam(value = "condition", required = false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getOrderMap().put("code", "asc");
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            LambdaQueryWrapper<PlanMonthEntity> queryWrapper = new LambdaQueryWrapper<>();
            String month = _con.getString("month");
            String projectId = _con.getString("projectId");
            queryWrapper.apply("DATE_FORMAT(month_date, '%Y-%m') = '" + month + "'");
            queryWrapper.eq(PlanMonthEntity::getProjectId,projectId);
            queryWrapper.in(PlanMonthEntity::getBillState,1,3);
            List<PlanMonthEntity> planYearEntityList = service.list(queryWrapper);
            if (CollectionUtils.isNotEmpty(planYearEntityList)){
                Long id = planYearEntityList.stream().findFirst().get().getId();
                param.getParams().put("mid", new Parameter(QueryParam.EQ, id));
            }else{
                param.getParams().put("mid", new Parameter(QueryParam.EQ, null));

            }
        }

        List<PlanMonthDetailEntity> list = planMonthDetailService.queryList(param, false);
        List<Map> resultMapList = new ArrayList<Map>();
        Map map = null;
        for(PlanMonthDetailEntity entity:list) {
            map = new HashMap<>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("monthPlanDetailMny", entity.getMonthPlanDetailMny());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }


    /**
     * @Description 每月25日进行项目预警提示：查询项目是否做月度计划预警
     */
    @RequestMapping(value = "/planMonthWarn", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse planMonthWarn(HttpServletRequest request) {
        return service.planMonthWarn(request);
    }



}
