package com.ejianc.business.safety.mapper;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.ejianc.business.safety.bean.SafetySceneCheckEntity;
import com.ejianc.business.scene.vo.CheckDetailReportVO;
import com.ejianc.business.scene.vo.DangerReportVo;
import com.ejianc.business.scene.vo.NewProblemVo;
import com.ejianc.business.scene.vo.XcjcsssjhzVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 检查单主表
 * 
 * @author generator
 * 
 */
@Mapper
public interface SafetySceneCheckMapper extends BaseCrudMapper<SafetySceneCheckEntity> {
    /**
     *  修改逾期状态和检查结果状态描述
     */
    public void updateSceneCheckOverdue();
    /**
     *  修改逾期数量
     */
    public void updateSceneCheckOverdueNumber();

	List<XcjcsssjhzVO> getXcjcsssjhz(@Param(value = "orgIds") List<Long> orgIds,
	                                 @Param(value = "jcxSort") String jcxSort,
	                                 @Param(value = "dzgSort") String dzgSort,
	                                 @Param(value = "yqwzgSort") String yqwzgSort);


    List<CheckDetailReportVO> queryCheckItemList(IPage<CheckDetailReportVO> page, @Param(Constants.WRAPPER) QueryWrapper wrapper, @Param(value = "orgIds") List<Long> orgIds);

    JSONObject queryCheckItemCount(@Param(Constants.WRAPPER) QueryWrapper wrapper);
    JSONObject queryBoardCheckItemCount(@Param(Constants.WRAPPER) QueryWrapper wrapper);

    List<NewProblemVo>  queryNewProblemReport(@Param(value = "date") String date,@Param(value = "tenantid") Long tenantid,@Param(value = "projectId") Long projectId);

    List<DangerReportVo>  queryDangerReport(@Param(value = "date") String date, @Param(value = "tenantid") Long tenantid);

    List<NewProblemVo>  queryProblemTopN(@Param("projectId") Long projectId,@Param("orgIds") List<Long> orgIds);

    List<XcjcsssjhzVO> queryQualityOrSafeCount(@Param("projectId") Long projectId, @Param("checkTypeIds") List<Long> checkTypeIds,@Param("orgIds") List<Long> orgIds);

    List<XcjcsssjhzVO> queryQualityOrSafeByDate(@Param("projectId") Long projectId, @Param("checkTypeIds") List<Long> checkTypeIds, @Param("startMonth") String startMonth, @Param("endMonth") String endMonth);

    JSONObject queryOtherDetail(@Param("orgIds")List<Long> orgIds);
}
