package com.ejianc.business.safety.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.safety.bean.SafetySceneQualityCheckCategoryEntity;
import com.ejianc.business.safety.mapper.SafetySceneQualityCheckCategoryMapper;
import com.ejianc.business.safety.service.ISafetySceneQualityCheckCategoryService;
import com.ejianc.business.scene.vo.SafetySceneQualityCheckCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 资源管理-质量检查分类实体
 * 
 * @author generator
 * 
 */
@Service("safetySceneQualityCheckCategoryService")
public class SafetySceneQualityCheckCategoryServiceImpl extends BaseServiceImpl<SafetySceneQualityCheckCategoryMapper,
        SafetySceneQualityCheckCategoryEntity> implements ISafetySceneQualityCheckCategoryService {

    @Autowired
    private SafetySceneQualityCheckCategoryMapper mapper;

    @Override
    public SafetySceneQualityCheckCategoryEntity queryByCode(String code) {
        QueryWrapper<SafetySceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    @Override
    public List<SafetySceneQualityCheckCategoryEntity> queryListByPid(List<Long> ids) {
        QueryWrapper<SafetySceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("parent_id", ids);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<SafetySceneQualityCheckCategoryEntity> queryByCodes(ArrayList<String> codes) {
        QueryWrapper<SafetySceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public List<SafetySceneQualityCheckCategoryVO> queryAllByPid(Long pid) {
        List<SafetySceneQualityCheckCategoryVO> resp = new ArrayList<>();
        SafetySceneQualityCheckCategoryEntity entity = super.selectById(pid);

        QueryWrapper<SafetySceneQualityCheckCategoryEntity> query = new QueryWrapper<>();
        query.likeRight("inner_code", entity.getInnerCode());
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SafetySceneQualityCheckCategoryEntity> dataList = super.list(query);

        if(CollectionUtils.isNotEmpty(dataList)) {
            resp = BeanMapper.mapList(dataList, SafetySceneQualityCheckCategoryVO.class);
        }
        return resp;
    }

    @Override
    public List<SafetySceneQualityCheckCategoryVO> queryList(Map<String, Object> condition) {
        return mapper.queryList(condition);
    }
}