/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.scene.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.quality.bean.QualityAcceptContentEntity;
import com.ejianc.business.quality.bean.QualityAcceptEntity;
import com.ejianc.business.quality.service.IQualityAcceptContentService;
import com.ejianc.business.quality.service.IQualityAcceptService;
import com.ejianc.business.scene.vo.PartDocDetailDataVO;
import com.ejianc.foundation.share.api.IPartApi;
import com.ejianc.foundation.share.vo.PartDocVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bi"})
public class BiController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IQualityAcceptService qualityAcceptService;
    @Autowired
    private IQualityAcceptContentService qualityAcceptContentService;
    @Autowired
    private IPartApi partApi;

    @RequestMapping(value={"/queryListTree"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(Long projectId) {
        if (projectId == null) {
            throw new BusinessException("\u8bf7\u5148\u9009\u62e9\u9879\u76ee!");
        }
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(QualityAcceptEntity::getProjectId, (Object)projectId);
        lambdaQueryWrapper.in(QualityAcceptEntity::getBillState, new Object[]{1, 3});
        List acceptEntityList = this.qualityAcceptService.list((Wrapper)lambdaQueryWrapper);
        ArrayList listAll = new ArrayList();
        ArrayList qualityAcceptContentEntityList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)acceptEntityList)) {
            List ids = acceptEntityList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper contentEntityLambdaQueryWrapper = new LambdaQueryWrapper();
            contentEntityLambdaQueryWrapper.in(QualityAcceptContentEntity::getQualityAcceptId, ids);
            List qualityAcceptEntityList = this.qualityAcceptContentService.list((Wrapper)contentEntityLambdaQueryWrapper);
            qualityAcceptEntityList.sort(Comparator.comparing(QualityAcceptContentEntity::getCheckBatch, Comparator.reverseOrder()).thenComparing(QualityAcceptContentEntity::getAcceptDate, Comparator.reverseOrder()));
            List partDocDetailDataVOS = BeanMapper.mapList((Iterable)qualityAcceptEntityList, PartDocDetailDataVO.class);
            for (PartDocDetailDataVO partDocDetailDataVO : partDocDetailDataVOS) {
                Date acceptDate = partDocDetailDataVO.getAcceptDate();
                String formattedDate = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(acceptDate.toInstant().atZone(ZoneId.systemDefault()));
                partDocDetailDataVO.setAcceptStrDate(formattedDate);
            }
            Map<Long, List<PartDocDetailDataVO>> groups = partDocDetailDataVOS.stream().collect(Collectors.groupingBy(PartDocDetailDataVO::getParentId));
            groups.values().forEach(group -> {
                for (int i = 0; i < group.size(); ++i) {
                    ((PartDocDetailDataVO)group.get(i)).setCode(String.valueOf(i + 1));
                }
            });
            listAll.addAll(partDocDetailDataVOS);
            String result = "";
            if (CollectionUtils.isNotEmpty((Collection)qualityAcceptEntityList)) {
                result = qualityAcceptEntityList.stream().map(QualityAcceptContentEntity::getInnerCode).filter(code -> code != null && !code.trim().isEmpty()).collect(Collectors.joining(", "));
                List longList = Collections.emptyList();
                if (result != null && !result.isEmpty()) {
                    longList = Arrays.stream(result.split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(Long::parseLong).collect(Collectors.toList());
                    PartDocVO partDocVO = new PartDocVO();
                    partDocVO.setIds(longList);
                    CommonResponse partDetailListByIds = this.partApi.getPartDetailListByIds(partDocVO);
                    if (!partDetailListByIds.isSuccess()) {
                        throw new BusinessException("\u83b7\u53d6\u5206\u90e8\u5206\u9879\u8be6\u60c5\u4fe1\u606f\u5931\u8d25");
                    }
                    List partDetailListByIdsData = (List)partDetailListByIds.getData();
                    List list = BeanMapper.mapList((Iterable)partDetailListByIdsData, PartDocDetailDataVO.class);
                    List partDocIds = list.stream().filter(s -> s.getParentId() == null).map(PartDocDetailDataVO::getPartDocId).collect(Collectors.toList());
                    PartDocVO partDocMVO = new PartDocVO();
                    partDocMVO.setIds(partDocIds);
                    CommonResponse partListByIds = this.partApi.getPartListByIds(partDocMVO);
                    if (!partListByIds.isSuccess()) {
                        throw new BusinessException("\u83b7\u53d6\u5206\u90e8\u5206\u9879\u4fe1\u606f\u5931\u8d25");
                    }
                    List partListByIdsData = (List)partListByIds.getData();
                    List partDocList = BeanMapper.mapList((Iterable)partListByIdsData, PartDocDetailDataVO.class);
                    listAll.addAll(partDocList);
                    for (PartDocDetailDataVO partDocDetailDataVO : list) {
                        if (partDocDetailDataVO.getParentId() != null) continue;
                        partDocDetailDataVO.setParentId(partDocDetailDataVO.getPartDocId());
                    }
                    listAll.addAll(list);
                }
            }
        }
        List resultMapList = BeanMapper.mapList(listAll, Map.class);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("records", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)jsonObject);
    }
}

