package com.ejianc.business.safety.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.safety.bean.*;
import com.ejianc.business.safety.service.IEmergencyExecuteDetailService;
import com.ejianc.business.safety.service.IEmergencyPlanService;
import com.ejianc.business.scene.vo.EmergencyPlanDetailVO;
import com.ejianc.business.scene.vo.trainPlanDetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.safety.service.IEmergencyPlanDetailService;

/**
 * 应急演练计划清单
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("emergencyPlanDetail")
public class EmergencyPlanDetailController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IEmergencyPlanDetailService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmergencyPlanService emergencyPlanService;

    @Autowired
    private IEmergencyExecuteDetailService emergencyExecuteDetailService;
    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<EmergencyPlanDetailVO> saveOrUpdate(@RequestBody EmergencyPlanDetailVO saveOrUpdateVO) {
    	EmergencyPlanDetailEntity entity = BeanMapper.map(saveOrUpdateVO, EmergencyPlanDetailEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	EmergencyPlanDetailVO vo = BeanMapper.map(entity, EmergencyPlanDetailVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<EmergencyPlanDetailVO> queryDetail(Long id) {
    	EmergencyPlanDetailEntity entity = service.selectById(id);
    	EmergencyPlanDetailVO vo = BeanMapper.map(entity, EmergencyPlanDetailVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<EmergencyPlanDetailVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (EmergencyPlanDetailVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(EmergencyPlanDetailVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<EmergencyPlanDetailVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<EmergencyPlanDetailEntity> page = service.queryPage(param,false);
        IPage<EmergencyPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), EmergencyPlanDetailVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<EmergencyPlanDetailEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("EmergencyPlanDetail-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refEmergencyPlanDetailData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<EmergencyPlanDetailVO>> refEmergencyPlanDetailData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if (condition.contains("projectId") && condition.contains("orgId")) {
                List<EmergencyPlanEntity> emergencyPlanEntityList = emergencyPlanService.list(new QueryWrapper<EmergencyPlanEntity>()
                        .eq("project_id", _con.getString("projectId"))
                        .eq("org_id", _con.getString("orgId"))
                        .eq("tenant_id", InvocationInfoProxy.getTenantid())
                        .eq("dr", 0)
                        .in("bill_state", 1, 3));
                List<Long> trainPlanIds = emergencyPlanEntityList.stream().map(EmergencyPlanEntity -> EmergencyPlanEntity.getId()).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(trainPlanIds)) {
                    List<EmergencyExecuteDetailEntity> emergencyExecuteDetailEntities = emergencyExecuteDetailService.list(new QueryWrapper<EmergencyExecuteDetailEntity>()
                            .eq("dr",0));
                    List<Long> executeDetailIds = emergencyExecuteDetailEntities.stream().filter(s->s.getSourceId() != null).map(EmergencyExecuteDetailEntity -> EmergencyExecuteDetailEntity.getSourceId()).collect(Collectors.toList());
                    if (executeDetailIds!= null && executeDetailIds.size() > 0){
                        param.getParams().put("id", new Parameter(QueryParam.NOT_IN, executeDetailIds));
                    }
                    param.getParams().put("pid", new Parameter(QueryParam.IN, trainPlanIds));
                    IPage<EmergencyPlanDetailEntity> page = service.queryPage(param, false);
                    IPage<EmergencyPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
                    pageData.setRecords(BeanMapper.mapList(page.getRecords(), EmergencyPlanDetailVO.class));
                    return CommonResponse.success("查询参照数据成功！", pageData);
                }

                IPage<EmergencyPlanDetailVO> pageData = new Page<>();
                return CommonResponse.success("查询参照数据成功！", pageData);
            }
        } else {
            IPage<EmergencyPlanDetailVO> pageData = new Page<>();
            return CommonResponse.success("查询参照数据成功！", pageData);
        }
        IPage<EmergencyPlanDetailVO> pageData = new Page<>();
        return CommonResponse.success("查询参照数据成功！", pageData);
     }
}
