/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.quality.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.quality.bean.QualityExcellenceEntity;
import com.ejianc.business.quality.service.IQualityExcellenceService;
import com.ejianc.business.quality.vo.QualityExcellenceVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"qualityExcellence"})
public class QualityExcellenceController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "QUALITY-EXCELLENCE";
    @Autowired
    private IQualityExcellenceService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QualityExcellenceVO> saveOrUpdate(@RequestBody QualityExcellenceVO saveOrUpdateVO) {
        QualityExcellenceEntity entity = (QualityExcellenceEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), QualityExcellenceEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setState(0);
        this.service.saveOrUpdate((Object)entity, false);
        QualityExcellenceVO vo = (QualityExcellenceVO)((Object)BeanMapper.map((Object)((Object)entity), QualityExcellenceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<QualityExcellenceVO> update(@RequestBody QualityExcellenceVO updateVO) {
        QualityExcellenceEntity entity = (QualityExcellenceEntity)((Object)BeanMapper.map((Object)((Object)updateVO), QualityExcellenceEntity.class));
        if (entity.getIsReward() == 0) {
            entity.setState(2);
        } else {
            entity.setState(3);
        }
        this.service.update((Wrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().set((Object)"is_reward", (Object)entity.getIsReward())).set((Object)"reward_date", (Object)entity.getRewardDate())).set((Object)"explain", (Object)entity.getExplain())).set((Object)"state", (Object)entity.getState())).eq((Object)"id", (Object)entity.getId()));
        QualityExcellenceVO vo = (QualityExcellenceVO)((Object)BeanMapper.map((Object)((Object)entity), QualityExcellenceVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<QualityExcellenceVO> queryDetail(Long id) {
        QualityExcellenceEntity entity = (QualityExcellenceEntity)((Object)this.service.selectById(id));
        QualityExcellenceVO vo = (QualityExcellenceVO)((Object)BeanMapper.map((Object)((Object)entity), QualityExcellenceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QualityExcellenceVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (QualityExcellenceVO qualityExcellenceVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<QualityExcellenceVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("excellentName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QualityExcellenceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("excellentName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage pageData = this.service.queryPage(param, false);
        HashMap<String, List> beans = new HashMap<String, List>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty((Collection)pageData.getRecords())) {
            List list = BeanMapper.mapList((Iterable)pageData.getRecords(), QualityExcellenceVO.class);
            list.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                if (vo.getState() == 0) {
                    vo.setStateName("\u7533\u8bf7\u4e2d");
                } else if (vo.getState() == 1) {
                    vo.setStateName("\u8bc4\u5ba1\u4e2d");
                } else if (vo.getState() == 2) {
                    vo.setStateName("\u672a\u83b7\u5956");
                } else if (vo.getState() == 3) {
                    vo.setStateName("\u5df2\u83b7\u5956");
                }
                if (vo.getRewardType() == 0) {
                    vo.setRewardTypeName("\u521b\u5730\u5e02\u7ea7\u201c\u4f18\u8d28\u7ed3\u6784\u5de5\u7a0b\u201d");
                } else if (vo.getRewardType() == 1) {
                    vo.setRewardTypeName("\u521b\u5730\u5e02\u7ea7\u201c\u4f18\u8d28\u5de5\u7a0b\u201d");
                } else if (vo.getRewardType() == 2) {
                    vo.setRewardTypeName("\u521b\u7701\u7ea7\u201c\u4f18\u8d28\u7ed3\u6784\u5de5\u7a0b\u201d");
                } else if (vo.getRewardType() == 3) {
                    vo.setRewardTypeName("\u521b\u7701\u90e8\u7ea7\u201c\u4f18\u8d28\u5de5\u7a0b\u201d");
                } else if (vo.getRewardType() == 4) {
                    vo.setRewardTypeName("\u521b\u56fd\u5bb6\u7ea7\u201c\u4f18\u8d28\u5de5\u7a0b\u201d");
                } else if (vo.getRewardType() == 5) {
                    vo.setRewardTypeName("\u9c81\u73ed\u5956");
                }
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("QualityExcellence-export.xlsx", beans, response);
        }
    }

    @RequestMapping(value={"/refQualityExcellenceData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<QualityExcellenceVO>> refQualityExcellenceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), QualityExcellenceVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

