package com.ejianc.business.safety.controller;

import java.io.Serializable;

import com.ejianc.business.safety.bean.trainPlanDetailEntity;
import com.ejianc.business.safety.service.ItrainPlanDetailService;
import com.ejianc.business.scene.vo.EmergencyPlanDetailVO;
import com.ejianc.business.scene.vo.EmergencyPlanVO;
import com.ejianc.business.scene.vo.trainPlanDetailVO;
import com.ejianc.business.scene.vo.trainPlanVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.safety.bean.trainPlanEntity;
import com.ejianc.business.safety.service.ItrainPlanService;

/**
 * 教育培训计划
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("trainPlan")
public class trainPlanController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "TRAIN-PLAN";//此处需要根据实际修改

    @Autowired
    private ItrainPlanService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ItrainPlanDetailService detailService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<trainPlanVO> saveOrUpdate(@RequestBody trainPlanVO saveOrUpdateVO) {
    	trainPlanEntity entity = BeanMapper.map(saveOrUpdateVO, trainPlanEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	trainPlanVO vo = BeanMapper.map(entity, trainPlanVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<trainPlanVO> queryDetail(Long id) {
    	trainPlanEntity entity = service.selectById(id);
    	trainPlanVO vo = BeanMapper.map(entity, trainPlanVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<trainPlanVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (trainPlanVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(trainPlanVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<trainPlanVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<trainPlanEntity> page = service.queryPage(param,false);
        IPage<trainPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), trainPlanVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @RequestMapping(value = "/queryTZList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<trainPlanDetailVO>> queryTZList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        QueryParam queryParam = new QueryParam();
        queryParam.getFuzzyFields().add("projectName");
        queryParam.getFuzzyFields().add("unitName");

        param.getFuzzyFields().add("trainObject");
        param.getFuzzyFields().add("trainTarget");
        /** 租户隔离 */

        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        queryParam.getParams().put("billState",new Parameter(QueryParam.IN,Arrays.asList(1,3)));
        List<trainPlanEntity> trainPlanEntityList = service.queryList(queryParam);
        if(!CollectionUtils.isEmpty(trainPlanEntityList)&&trainPlanEntityList.size()>0) {
            List<Long> ids = trainPlanEntityList.stream().map(trainPlanEntity::getId).collect(Collectors.toList());
            Map<Long, String> projectName = trainPlanEntityList.stream().collect(Collectors.toMap(trainPlanEntity::getId, trainPlanEntity::getProjectName));
            Map<Long, String> unitName = trainPlanEntityList.stream().collect(Collectors.toMap(trainPlanEntity::getId, trainPlanEntity::getUnitName));
            param.getParams().put("pid", new Parameter(QueryParam.IN, ids));
            IPage<trainPlanDetailEntity> page = detailService.queryPage(param, false);
            List<trainPlanDetailVO> voList = BeanMapper.mapList(page.getRecords(), trainPlanDetailVO.class);
            voList.forEach(e -> {
                e.setProjectName(projectName.get(e.getPid()));
                e.setUnitName(unitName.get(e.getPid()));
            });
            IPage<trainPlanDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
            pageData.setRecords(voList);
            return CommonResponse.success("查询列表数据成功！",pageData);
        }
        return CommonResponse.success("查询列表数据成功！");
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<trainPlanEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<trainPlanVO> voList = BeanMapper.mapList(list, trainPlanVO.class);
        voList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", voList);
        ExcelExport.getInstance().export("trainPlan-export.xlsx", beans, response);
    }
    @RequestMapping(value = "/excelTZExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelTZExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        QueryParam queryParam = new QueryParam();
        /** 租户隔离 */
        queryParam.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<trainPlanEntity> trainPlanEntityList = service.queryList(queryParam);

        List<Long> ids = trainPlanEntityList.stream().map(trainPlanEntity::getId).collect(Collectors.toList());
        Map<Long,String> projectName=trainPlanEntityList.stream().collect(Collectors.toMap(trainPlanEntity::getId,trainPlanEntity::getProjectName));
        Map<Long,String> unitName=trainPlanEntityList.stream().collect(Collectors.toMap(trainPlanEntity::getId,trainPlanEntity::getUnitName));
        param.getParams().put("pid",new Parameter(QueryParam.IN,ids));
        IPage<trainPlanDetailEntity> page = detailService.queryPage(param, false);
        List<trainPlanDetailVO> voList = BeanMapper.mapList(page.getRecords(), trainPlanDetailVO.class);
        voList.forEach(e -> {
            e.setProjectName(projectName.get(e.getPid()));
            e.setUnitName(unitName.get(e.getPid()));
        });
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", voList);
        ExcelExport.getInstance().export("trainPlanTZ-export.xlsx", beans, response);
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/reftrainPlanData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<trainPlanVO>> reftrainPlanData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            //根据项目过滤
            if (condition.contains("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.getString("projectId")));
            }
            if (condition.contains("orgId")) {
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, _con.getString("orgId")));
            }
        }
        IPage<trainPlanEntity> page = service.queryPage(param,false);

        IPage<trainPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), trainPlanVO.class));
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
