package com.ejianc.business.safety.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.safety.bean.FinancialOrgEntity;
import com.ejianc.business.safety.mapper.FinancialOrgMapper;
import com.ejianc.business.safety.service.IFinancialOrgService;
import com.ejianc.business.scene.vo.FinancialOrgVO;
import com.ejianc.business.util.ExcelImportUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.*;

//import com.ejianc.foundation.share.service.IFinancialProjectService;

/**
 * 集团财务科目实体
 *
 * @author generator
 */
@Service("financialOrgService")
public class FinancialOrgServiceImpl extends BaseServiceImpl<FinancialOrgMapper, FinancialOrgEntity> implements IFinancialOrgService {

//    @Autowired
//    private IFinancialProjectService financialProjectService;

    @Autowired
    private IFinancialOrgService financialService;

    @Autowired
    private FinancialOrgMapper financialMapper;

    @Override
    public CommonResponse<FinancialOrgVO> saveOrUpdate(FinancialOrgVO saveorUpdateVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        FinancialOrgEntity entity = null;
        if (saveorUpdateVO.getId() != null && saveorUpdateVO.getId() > 0) { //修改
            List<Long> ids = new ArrayList<>();
            ids.add(saveorUpdateVO.getId());
//            Boolean flag = financialProjectService.delRefCheck(ids);
//            if (flag) {
//                return CommonResponse.error("存在被引用的核算对象，暂不允许编辑!");
//            }
            //修改  校验合同编号是否重复
            LambdaQueryWrapper<FinancialOrgEntity> lambda = Wrappers.<FinancialOrgEntity>lambdaQuery();
            lambda.eq(FinancialOrgEntity::getCode, saveorUpdateVO.getCode());
            lambda.eq(FinancialOrgEntity::getTenantId, tenantId);
            lambda.ne(FinancialOrgEntity::getId, saveorUpdateVO.getId());
            List<FinancialOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }

            entity = BeanMapper.map(saveorUpdateVO, FinancialOrgEntity.class);
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("修改成功！");
        } else {//新增
            //校验合同编号是否重复
            LambdaQueryWrapper<FinancialOrgEntity> lambda = Wrappers.<FinancialOrgEntity>lambdaQuery();
            lambda.eq(FinancialOrgEntity::getTenantId, tenantId);
            lambda.eq(FinancialOrgEntity::getCode, saveorUpdateVO.getCode());
            List<FinancialOrgEntity> entities = super.list(lambda);
            if (entities != null && entities.size() > 0) {
                return CommonResponse.error("存在相同编码，不允许保存!");
            }
            entity = BeanMapper.map(saveorUpdateVO, FinancialOrgEntity.class);
            entity.setId(IdWorker.getId());
            if (entity.getParentId() != null && entity.getParentId() > 0) {
                FinancialOrgEntity uniqueBean = baseMapper.selectById(entity.getParentId());
                entity.setInnerCode(uniqueBean.getInnerCode() + "," + entity.getId());
            } else {
                entity.setInnerCode(entity.getId().toString());
            }
            //默认最上级父级id为999
            if(entity.getParentId() == null){
                entity.setParentId(Long.parseLong(String.valueOf(999)));
            }
            super.saveOrUpdate(entity, false);
            return CommonResponse.success("保存成功！");
        }
    }

    @Override
    public CommonResponse<FinancialOrgVO> updateEn(FinancialOrgVO saveorUpdateVO) {
        //修改子节点
        List<FinancialOrgEntity> list = BeanMapper.mapList(getChildrenByPid(saveorUpdateVO.getId()),FinancialOrgEntity.class);
        for (FinancialOrgEntity entity : list) {
            if(saveorUpdateVO.getEnabled()==1) {
                entity.setEnabled(1);
            }else{
                entity.setEnabled(0);
            }
        }
        saveOrUpdateBatch(list);

        return CommonResponse.success("修改成功！");
    }

    @Override
    public List<FinancialOrgVO> getChildrenByPid(Long id) {
        FinancialOrgEntity parent = this.selectById(id);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("innerCode", new Parameter(QueryParam.LIKE_RIGHT, parent.getInnerCode()));
        List<FinancialOrgEntity> list = super.queryList(queryParam, false);
        return BeanMapper.mapList(list, FinancialOrgVO.class);
    }

    @Override
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        JSONObject resp = new JSONObject();
        if(isFailed) {
            return CommonResponse.error("文件格式不合法");
        }else{
            List<List<String>> result = ExcelReader.readExcel(mf);
            if(result != null && result.size() > 0) {
                //父子关系重复校验
                Map<String, Integer> indexMap = new HashMap<>();
                //父子关系虚拟主键映射
                List<FinancialOrgVO> voList = new ArrayList<>();
                Map<String,String> tidMap = new HashMap<>();
                //编码重复校验
                List<String> excelCodeList = new ArrayList<>();
                //查询所有财务科目-集团
                QueryParam queryParam = new QueryParam();
                List<String> codeList = new ArrayList<>();
                List<FinancialOrgEntity> oldList = financialService.queryList(queryParam);
                for(FinancialOrgEntity vo : oldList){
                    codeList.add(vo.getCode());
                }
                //结果集遍历
                for (int i = 0; i < result.size(); i++) {
                    List<String> datas = result.get(i);
                    FinancialOrgVO vo = new FinancialOrgVO();
                    boolean flag = false;
                    boolean parentWarn = false;
                    String warnType = "";

                    //编号
                    String code = datas.get(0);
                    vo.setCode(code);
                    //父编号
                    String parentCode = datas.get(1);
                    //维护父子关系(虚拟id)
                    String id = UUID.randomUUID().toString().replaceAll("-", "");
                    //设置虚拟id
                    vo.setTid(id);
                    //虚拟id映射
                    tidMap.put(code,id);
                    //设置虚拟父id
                    vo.setTpid(parentCode);
                    //导入数据校验
                    //编码非空
                    if(StringUtils.isEmpty(code)){
                        vo.setCode(null);
                        warnType = warnType+"编码为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        //编码重复
                        if(codeList.contains(code)){
                            vo.setCode(code);
                            warnType = warnType+"编码重复,";
                            flag = true;
                            parentWarn = true;
                        }
                        if(excelCodeList.contains(code)){
                            vo.setCode(code);
                            warnType = warnType+"导入编码重复,";
                            flag = true;
                            parentWarn = true;
                        }else{
                            excelCodeList.add(code);
                        }
                        vo.setCode(code);
                    }
                    String name = datas.get(2);
                    if(StringUtils.isEmpty(name)){
                        vo.setName(null);
                        warnType = warnType+"名称为空,";
                        flag = true;
                        parentWarn = true;
                    }else{
                        vo.setName(name);
                    }

                    vo.setMemo(datas.get(3));
                    vo.setEnabled(1);
                    // true=可以导入，false=不可导入
                    vo.setImportFlag(!flag);
                    vo.setParentWarn(parentWarn);
                    if(flag){
                        warnType = warnType.substring(0,warnType.length()-1);
                    }
                    vo.setWarnType(warnType);
                    vo.setRowState("add");
                    vo.setShadowId(vo.getTid());
//                    vo.setChangeType(3);//增补项

                    voList.add(vo);
                }
                //此处将之前存储的父级code转换为虚拟父级id
                for(FinancialOrgVO vo: voList){
                    if(StringUtils.isNotEmpty(tidMap.get(vo.getTpid()))){
                        vo.setTpid(tidMap.get(vo.getTpid()));
                    }
                }
                List<Map<String, Object>> deailTreeData =ExcelImportUtil.treeData(BeanMapper.mapList(voList, Map.class));
                List<Map<String, Object>> mapList = ExcelImportUtil.importFlag(deailTreeData);
                List<Map<String, Object>> falseList = new ArrayList<>();
                List<List<Map<String, Object>>> allList = ExcelImportUtil.separate(mapList, falseList);
                List<Map<String, Object>> errorList=ExcelImportUtil.treeToList(allList.get(1),true);
                List<Map<String, Object>> successList=ExcelImportUtil.treeToList(allList.get(0),false);
                resp.put("successList",successList);
                resp.put("errorList",errorList);
                resp.put("successNum",result.size() - errorList.size());
                resp.put("errorNum",errorList.size());
                return CommonResponse.success(resp);
            }
            return CommonResponse.error("Excel为空");
        }
    }

    @Override
    public String saveImportExcel(HttpServletRequest request, List<FinancialOrgVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            throw new BusinessException("导入的数据为空！");
        }
        List<FinancialOrgEntity> saveList = BeanMapper.mapList(importVOS, FinancialOrgEntity.class);
        financialService.saveOrUpdateBatch(saveList, saveList.size(), false);
        if (saveList.size() > 0) {
            //维护父子级关系
            Map<String, Long> idMap = new HashMap<>();
            for (FinancialOrgEntity entity : saveList) {
                //存储虚拟id和真实id
                idMap.put(entity.getTid(), entity.getId());
            }
            for (FinancialOrgEntity vo : saveList) {
                if (StringUtils.isNotEmpty(vo.getTpid())) {
                    //通过虚拟id父子关系存储真实导入id
                    if(idMap.get(vo.getTpid())==null){
                       //tpid不为空且导入中不存在父子关系，查询已存在父id
                        LambdaQueryWrapper<FinancialOrgEntity> lambda = Wrappers.<FinancialOrgEntity>lambdaQuery();
                        lambda.eq(FinancialOrgEntity::getCode, vo.getTpid());
                        FinancialOrgEntity entity = financialService.getOne(lambda);
                        if(entity!=null){
                            vo.setParentId(entity.getId());
                        }
                    }else{
                        //导入父子关系替换父id
                        vo.setParentId(idMap.get(vo.getTpid()));
                    }
                }
            }
            //innercode
            for(FinancialOrgEntity vo : saveList){
                if (vo.getParentId() != null && vo.getParentId() > 0) {
                    FinancialOrgEntity entity = baseMapper.selectById(vo.getParentId());
                    vo.setInnerCode(entity.getInnerCode() + "," + vo.getId());
                } else {
                    vo.setInnerCode(vo.getId().toString());
                }
                financialService.saveOrUpdate(vo);
            }
            financialService.saveOrUpdateBatch(saveList, saveList.size(), false);
        }
        return "保存成功！";
    }

    @Override
    public List<Long> queryFinancialOrgIds(String name) {
        return baseMapper.queryFinancialOrgIds(name);
    }

}
