package com.ejianc.business.safety.service.impl;


import com.ejianc.business.safety.bean.SafetySceneDailyEntity;
import com.ejianc.business.safety.mapper.SafetySceneDailyMapper;
import com.ejianc.business.safety.service.ISafetySceneDailyService;
import com.ejianc.business.safety.service.SafetyCheckMessageService;
import com.ejianc.business.scene.util.*;

import com.ejianc.business.scene.vo.SceneDailyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

/**
 * 日常检查主表
 * 
 * @author generator
 * 
 */
@Service("safetySceneDailyService")
public class SafetySceneDailyServiceImpl extends BaseServiceImpl<SafetySceneDailyMapper, SafetySceneDailyEntity>
        implements ISafetySceneDailyService {
    @Autowired
    private SafetyCheckMessageService safetyCheckMessageService;
    @Override
    public void checkSubmitHandle(Long billId) {
        if(billId != null){
            SafetySceneDailyEntity sceneDailyEntity = this.selectById(billId);
            String notifRelevantId = sceneDailyEntity.getNotifRelevantId();
            SceneDailyVO vo = BeanMapper.map(sceneDailyEntity, SceneDailyVO.class);
            if(StringUtils.isNotBlank(notifRelevantId)){
                String[] notifRelevant = notifRelevantId.split(",");
                //发送消息给需要通知人员
                vo.setMsgNum(0);
                vo.setMsgBillCode(vo.getBillCode());
                vo.setMsgId(vo.getId());
                safetyCheckMessageService.sendDailyMsg(vo,notifRelevant,NoticeEnum.CHECK_Detail_COMMIT_PASS_REVIEW);
            }


        }
    }
}
