package com.ejianc.business.quality.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 质量成本汇总表-子表
 * 
 * @author generator
 * 
 */
public class QualityCostallDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer state; // 状态
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String name; // 质量风险名称
    private String process; // 生产过程
    private String controlMeasure; // 控制措施
    private String description; // 质量风险源描述
    private Long mid; // 主表id
    private String memo; // 备注
    private Long costLevelId; // 费用构成id
    private String costLevelName; // 费用构成name
    private Long detailOrgId; // 组织id
    private String detailOrgCode; // 组织code
    private String detailOrgName; // 组织名称
    private Long detailParentOrgId; // 项目部上级组织Id
    private String detailParentOrgName; // 项目部上级组织名称
    private String detailParentOrgCode; // 项目部上级组织编码
    private Long detailProjectId; // 项目id
    private String detailProjectName; // 项目名称
    private BigDecimal oneCostMny; // 第1季度实际发生费用（元）
    private BigDecimal twoCostMny; // 第2季度实际发生费用（元）
    private BigDecimal threeCostMny; // 第3季度实际发生费用（元）
    private BigDecimal fourCostMny; // 第4季度实际发生费用（元）
    private BigDecimal costMny; // 合计
    private BigDecimal rate; // 占比(%)
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public String getProcess() {
        return process;
    }

    public void setProcess(String process) {
        this.process = process;
    }
    public String getControlMeasure() {
        return controlMeasure;
    }

    public void setControlMeasure(String controlMeasure) {
        this.controlMeasure = controlMeasure;
    }
    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getCostLevelId() {
        return costLevelId;
    }

    public void setCostLevelId(Long costLevelId) {
        this.costLevelId = costLevelId;
    }
    public String getCostLevelName() {
        return costLevelName;
    }

    public void setCostLevelName(String costLevelName) {
        this.costLevelName = costLevelName;
    }


    @ReferSerialTransfer(referCode="idm-org")
    public Long getDetailOrgId() {
        return detailOrgId;
    }
    @ReferDeserialTransfer
    public void setDetailOrgId(Long detailOrgId) {
        this.detailOrgId = detailOrgId;
    }
    public String getDetailOrgCode() {
        return detailOrgCode;
    }

    public void setDetailOrgCode(String detailOrgCode) {
        this.detailOrgCode = detailOrgCode;
    }
    public String getDetailOrgName() {
        return detailOrgName;
    }

    public void setDetailOrgName(String detailOrgName) {
        this.detailOrgName = detailOrgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getDetailParentOrgId() {
        return detailParentOrgId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public void setDetailParentOrgId(Long detailParentOrgId) {
        this.detailParentOrgId = detailParentOrgId;
    }

    public String getDetailParentOrgName() {
        return detailParentOrgName;
    }

    public void setDetailParentOrgName(String detailParentOrgName) {
        this.detailParentOrgName = detailParentOrgName;
    }
    public String getDetailParentOrgCode() {
        return detailParentOrgCode;
    }

    public void setDetailParentOrgCode(String detailParentOrgCode) {
        this.detailParentOrgCode = detailParentOrgCode;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getDetailProjectId() {
        return detailProjectId;
    }
    @ReferDeserialTransfer
    public void setDetailProjectId(Long detailProjectId) {
        this.detailProjectId = detailProjectId;
    }
    public String getDetailProjectName() {
        return detailProjectName;
    }

    public void setDetailProjectName(String detailProjectName) {
        this.detailProjectName = detailProjectName;
    }
    public BigDecimal getOneCostMny() {
        return oneCostMny;
    }

    public void setOneCostMny(BigDecimal oneCostMny) {
        this.oneCostMny = oneCostMny;
    }
    public BigDecimal getTwoCostMny() {
        return twoCostMny;
    }

    public void setTwoCostMny(BigDecimal twoCostMny) {
        this.twoCostMny = twoCostMny;
    }
    public BigDecimal getThreeCostMny() {
        return threeCostMny;
    }

    public void setThreeCostMny(BigDecimal threeCostMny) {
        this.threeCostMny = threeCostMny;
    }
    public BigDecimal getFourCostMny() {
        return fourCostMny;
    }

    public void setFourCostMny(BigDecimal fourCostMny) {
        this.fourCostMny = fourCostMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getRate() {
        return rate;
    }

    public void setRate(BigDecimal rate) {
        this.rate = rate;
    }
    
}
