package com.ejianc.business.quality.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.quality.vo.QualityExcellenceContentVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 质量创优
 * 
 * @author generator
 * 
 */
public class QualityExcellenceVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer state; // 状态
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private String projectLocation; // 项目地址
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date beginDate; // 开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date completeDate; // 竣工日期
    private String projectScan; // 工程规模
    private String projectManager; // 项目经理
    private Integer rewardType; // 奖励类型
    private String excellentName; // 创优名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date excellentDate; // 创优申报日期
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private String employeeCode; // 经办人编码
    private String employeePart; // 经办部门
    private String excellentCondition; // 创优活动开展情况
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date checkDate; // 检查日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date rewardDate; // 获奖日期
    private Integer isReward; // 是否获奖
    private String explain; // 说明
    private Long orgId; // 组织id
    private String orgCode; // 组织code
    private String orgName; // 组织名称
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // 项目部上级组织名称
    private String parentOrgCode; // 项目部上级组织编码
    private String projectCode; // 项目编码
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private String secondUnit; // 二级单位

    private String billStateName; // 单据状态名称
    private String stateName; // 状态名称
    private String rewardTypeName; // 奖励类型名称

    public String getStateName() {
        return stateName;
    }

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getRewardTypeName() {
        return rewardTypeName;
    }

    public void setRewardTypeName(String rewardTypeName) {
        this.rewardTypeName = rewardTypeName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    private List<QualityExcellenceContentVO> qualityExcellenceContentList = new ArrayList<>(); // 质量创优子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getCompleteDate() {
        return completeDate;
    }

    public void setCompleteDate(Date completeDate) {
        this.completeDate = completeDate;
    }
    public String getProjectScan() {
        return projectScan;
    }

    public void setProjectScan(String projectScan) {
        this.projectScan = projectScan;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    public Integer getRewardType() {
        return rewardType;
    }

    public void setRewardType(Integer rewardType) {
        this.rewardType = rewardType;
    }
    public String getExcellentName() {
        return excellentName;
    }

    public void setExcellentName(String excellentName) {
        this.excellentName = excellentName;
    }
    public Date getExcellentDate() {
        return excellentDate;
    }

    public void setExcellentDate(Date excellentDate) {
        this.excellentDate = excellentDate;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public String getExcellentCondition() {
        return excellentCondition;
    }

    public void setExcellentCondition(String excellentCondition) {
        this.excellentCondition = excellentCondition;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getRewardDate() {
        return rewardDate;
    }

    public void setRewardDate(Date rewardDate) {
        this.rewardDate = rewardDate;
    }
    public Integer getIsReward() {
        return isReward;
    }

    public void setIsReward(Integer isReward) {
        this.isReward = isReward;
    }
    public String getExplain() {
        return explain;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    
     public List<QualityExcellenceContentVO> getQualityExcellenceContentList() {
        return qualityExcellenceContentList;
     }

     public void setQualityExcellenceContentList(List<QualityExcellenceContentVO> qualityExcellenceContentList) {
        this.qualityExcellenceContentList = qualityExcellenceContentList;
     }
}
