/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.safety.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.prosub.utils.TreeNodeBUtil;
import com.ejianc.business.safety.bean.PlanYearDetailEntity;
import com.ejianc.business.safety.bean.PlanYearEntity;
import com.ejianc.business.safety.service.IPlanYearDetailService;
import com.ejianc.business.safety.service.IPlanYearService;
import com.ejianc.business.scene.vo.PlanYearDetailVO;
import com.ejianc.business.scene.vo.PlanYearVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"planYear"})
public class PlanYearController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "QUALITY_YEAR_PLAN";
    @Autowired
    private IPlanYearService service;
    @Autowired
    private IPlanYearDetailService planYearDetailService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PlanYearVO> saveOrUpdate(@RequestBody PlanYearVO saveOrUpdateVO) {
        List<PlanYearDetailEntity> detailList;
        PlanYearEntity entity = (PlanYearEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanYearEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (!(detailList = entity.getPlanYearDetailList()).isEmpty()) {
            HashMap<String, Long> idMap = new HashMap<String, Long>();
            for (PlanYearDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState())) continue;
                if (sd.getId() == null || entity.getId() == null) {
                    sd.setId(IdWorker.getId());
                }
                idMap.put(sd.getTid(), sd.getId());
                sd.setParentId(null);
            }
            for (PlanYearDetailEntity sd : detailList) {
                if ("del".equals(sd.getRowState()) || !StringUtils.isNotEmpty((CharSequence)sd.getTpid())) continue;
                sd.setParentId((Long)idMap.get(sd.getTpid()));
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PlanYearVO vo = (PlanYearVO)BeanMapper.map((Object)((Object)entity), PlanYearVO.class);
        List detailAllList = vo.getPlanYearDetailList();
        if (!detailList.isEmpty()) {
            for (PlanYearDetailVO detail : detailAllList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanYearDetailList(TreeNodeBUtil.buildTree((List)detailAllList));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanYearVO> queryDetail(Long id) {
        PlanYearEntity entity = (PlanYearEntity)((Object)this.service.selectById(id));
        PlanYearVO vo = (PlanYearVO)BeanMapper.map((Object)((Object)entity), PlanYearVO.class);
        List detailList = vo.getPlanYearDetailList();
        if (!detailList.isEmpty()) {
            for (PlanYearDetailVO detail : detailList) {
                detail.setTid(String.valueOf(detail.getId()));
                detail.setTpid(detail.getParentId() != null && detail.getParentId() > 0L ? String.valueOf(detail.getParentId()) : null);
                detail.setParentId(null != detail.getTpid() ? Long.valueOf(detail.getTpid()) : null);
            }
            vo.setPlanYearDetailList(TreeNodeBUtil.buildTree((List)detailList));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PlanYearVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PlanYearVO planYearVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PlanYearVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectTypeName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PlanYearVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List sceneCheckVOS = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            sceneCheckVOS = BeanMapper.mapList((Iterable)list, PlanYearVO.class);
            for (PlanYearVO workSummaryVO : sceneCheckVOS) {
                if (workSummaryVO.getAccureRateType().equals(1)) {
                    workSummaryVO.setAccureRateTypeName("0%");
                }
                if (workSummaryVO.getAccureRateType().equals(2)) {
                    workSummaryVO.setAccureRateTypeName("1.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(3)) {
                    workSummaryVO.setAccureRateTypeName("2.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(4)) {
                    workSummaryVO.setAccureRateTypeName("2.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(5)) {
                    workSummaryVO.setAccureRateTypeName("3.0%");
                }
                if (workSummaryVO.getAccureRateType().equals(6)) {
                    workSummaryVO.setAccureRateTypeName("3.5%");
                }
                if (workSummaryVO.getAccureRateType().equals(7)) {
                    workSummaryVO.setAccureRateTypeName("3.75%");
                }
                workSummaryVO.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)workSummaryVO.getBillState()).getDescription());
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", sceneCheckVOS);
        ExcelExport.getInstance().export("PlanYear-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPlanYearData"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> refPlanYearData(@RequestParam(value="searchText", required=false) String searchText, @RequestParam(value="condition", required=false) String condition) {
        QueryParam param = new QueryParam();
        param.setSearchText(searchText);
        param.getFuzzyFields().add("name");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getOrderMap().put("code", "asc");
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            String year = _con.getString("year");
            String projectId = _con.getString("projectId");
            queryWrapper.apply("DATE_FORMAT(year_date, '%Y') = '" + year + "'", new Object[0]);
            queryWrapper.eq(PlanYearEntity::getProjectId, (Object)projectId);
            queryWrapper.in(PlanYearEntity::getBillState, new Object[]{1, 3});
            List planYearEntityList = this.service.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)planYearEntityList)) {
                Long id = ((PlanYearEntity)((Object)planYearEntityList.stream().findFirst().get())).getId();
                param.getParams().put("mid", new Parameter("eq", (Object)id));
            } else {
                param.getParams().put("mid", new Parameter("eq", null));
            }
        }
        List list = this.planYearDetailService.queryList(param, false);
        ArrayList resultMapList = new ArrayList();
        HashMap<String, Object> map = null;
        for (PlanYearDetailEntity entity : list) {
            map = new HashMap<String, Object>();
            map.put("id", entity.getId());
            map.put("key", entity.getId());
            map.put("name", entity.getName());
            map.put("code", entity.getCode());
            map.put("parentId", entity.getParentId());
            map.put("memo", entity.getMemo());
            map.put("yearPlanDetailMny", entity.getYearPlanDetailMny());
            resultMapList.add(map);
        }
        return ResultAsTree.createTreeData(resultMapList);
    }

    @RequestMapping(value={"/getPlanYearInfo"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PlanYearEntity> getPlanYearInfo(Long projectId, String year) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.apply("DATE_FORMAT(year_date, '%Y') = '" + year + "'", new Object[0]);
        queryWrapper.eq(PlanYearEntity::getProjectId, (Object)projectId);
        queryWrapper.in(PlanYearEntity::getBillState, new Object[]{1, 3});
        List useEntityList = this.service.list((Wrapper)queryWrapper);
        PlanYearEntity planYearEntity = new PlanYearEntity();
        if (CollectionUtils.isNotEmpty((Collection)useEntityList)) {
            planYearEntity = (PlanYearEntity)((Object)useEntityList.stream().findFirst().get());
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)planYearEntity));
    }
}

