package com.ejianc.business.scene.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.scene.bean.SceneCheckDetailEntity;
import com.ejianc.business.scene.bean.SceneCheckEntity;
import com.ejianc.business.scene.bean.SceneCheckRecordEntity;
import com.ejianc.business.scene.service.CheckMessageService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SceneCheckVO;
import com.ejianc.business.scene.vo.SceneDailyVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.scene.mapper.SceneDailyMapper;
import com.ejianc.business.scene.bean.SceneDailyEntity;
import com.ejianc.business.scene.service.ISceneDailyService;

import java.util.ArrayList;
import java.util.List;

/**
 * 日常检查主表
 * 
 * @author generator
 * 
 */
@Service("sceneDailyService")
public class SceneDailyServiceImpl extends BaseServiceImpl<SceneDailyMapper, SceneDailyEntity> implements ISceneDailyService{
    @Autowired
    private CheckMessageService checkMessageService;
    @Override
    public void checkSubmitHandle(Long billId) {
        if(billId != null){
            SceneDailyEntity sceneDailyEntity = this.selectById(billId);
            String notifRelevantId = sceneDailyEntity.getNotifRelevantId();
            SceneDailyVO vo = BeanMapper.map(sceneDailyEntity, SceneDailyVO.class);
            if(StringUtils.isNotBlank(notifRelevantId)){
                String[] notifRelevant = notifRelevantId.split(",");
                //发送消息给需要通知人员
                vo.setMsgNum(0);
                vo.setMsgBillCode(vo.getBillCode());
                vo.setMsgId(vo.getId());
                checkMessageService.sendDailyMsg(vo,notifRelevant,NoticeEnum.CHECK_Detail_COMMIT_PASS_REVIEW);
            }


        }
    }
}
