package com.ejianc.business.safety.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import com.ejianc.business.safety.bean.SafetySceneCheckDetailEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckRecordEntity;
import com.ejianc.business.safety.service.ISafetySceneCheckDetailService;
import com.ejianc.business.safety.service.ISafetySceneCheckRecordService;
import com.ejianc.business.safety.service.ISafetySceneCheckService;
import com.ejianc.business.scene.util.CheckItemReformState;
import com.ejianc.business.scene.vo.SafetySceneCheckDetailVO;
import com.ejianc.business.scene.vo.SafetySceneCheckRecordVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Controller
@RequestMapping("safetyReform")
@Api(value = "待复查", tags = {"检查单主子表"})
public class SafetyReformController {

    @Autowired
    private ISafetySceneCheckDetailService sceneCheckDetailService;

    @Autowired
    private ISafetySceneCheckRecordService sceneCheckRecordService;

    @Autowired
    private ISafetySceneCheckService sceneCheckService;

    @Autowired
    private SessionManager sessionManager;

    @Value("${common.env.base-host}")
    private String baseHost;


    private static final String BILL_CODE = "SAFETY_SCENE_CHECK_DETAIL_CODE";//此处需要根据实际修改


    @ApiOperation("待整改查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafetySceneCheckDetailVO> queryDetail(@RequestParam Long id) {
        SafetySceneCheckDetailEntity entity = sceneCheckDetailService.selectById(id);
        //根据检查项id重新查询检查及复查整改记录数，根据创建时间倒序
        Long detailId = entity.getId();
        QueryParam param = new QueryParam();
        param.getParams().put("pid",new Parameter(QueryParam.EQ, detailId));
        param.getOrderMap().put("createTime", QueryParam.DESC);
        List<SafetySceneCheckRecordEntity> sceneCheckRecordList = sceneCheckRecordService.queryList(param);
        List<SafetySceneCheckRecordVO> sceneCheckRecordVO = BeanMapper.mapList(sceneCheckRecordList, SafetySceneCheckRecordVO.class);
        SafetySceneCheckDetailVO vo = BeanMapper.map(entity, SafetySceneCheckDetailVO.class);
        vo.setSceneCheckRecords(sceneCheckRecordVO, baseHost);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待整改单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckDetailVO>> queryList(@RequestBody QueryParam param) {
        Map<String, Parameter> params = param.getParams();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("checkItem");
        fuzzyFields.add("checkPerson");
        fuzzyFields.add("checkName");
        /** 租户隔离 */
        params.put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        //param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("is_reform", new Parameter(QueryParam.IN, Arrays.asList(CheckItemReformState.REFORM_STATE.getCode(),CheckItemReformState.REFORM_FAILED_STATE.getCode())));
        param.getParams().put("rectification_id",new Parameter(QueryParam.LIKE,sessionManager.getUserContext().getUserId().toString()));
        param.getParams().put("dr", new Parameter(QueryParam.EQ, BaseVO.DR_UNDELETE));

        if (params.containsKey("rectificationId") && "all".equals(params.get("rectificationId").getValue().toString())) {
            params.remove("rectification_id");
            params.remove("rectificationId");
        }

        if (params.containsKey("projectId") && params.get("projectId") != null) {
            LambdaQueryWrapper<SafetySceneCheckEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(SafetySceneCheckEntity::getProjectId, Long.valueOf(params.get("projectId").getValue().toString()));
            List<SafetySceneCheckEntity> list = sceneCheckService.list(queryWrapper);
            List<Long> pids = list.stream().map(SafetySceneCheckEntity::getId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(pids)) {
                pids = Arrays.asList(1L);
            }
            params.put("pid", new Parameter(QueryParam.IN, pids));
            params.remove("projectId");
        }

        IPage<SafetySceneCheckDetailEntity> page = sceneCheckDetailService.queryPage(param, false);
        IPage<SafetySceneCheckDetailVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafetySceneCheckDetailVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }


    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SafetySceneCheckDetailVO> saveOrUpdate(@ApiParam(name="saveorUpdateVO", required=true) @RequestBody SafetySceneCheckDetailVO saveorUpdateVO) {
        return sceneCheckDetailService.insertOrUpdate(saveorUpdateVO);
    }

}
