package com.ejianc.business.scene.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 变更状态
 */
public enum ReformStatusEnum {

    /**
     * 整改状态: 1-待整改
     */
    待整改(1, "待整改"),

    /**
     * 整改状态: 2-待复查
     */
    待复查(2, "待复查"),

    /**
     * 整改状态: 3-复查不合格
     */
    复查不合格(3, "复查不合格"),

    /**
     * 整改状态: 4-已完成
     */
    已完成(4, "已完成");

    private Integer code;
    private String description;
    private static Map<Integer, ReformStatusEnum> enumMap = new HashMap<>();

    ReformStatusEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(ReformStatusEnum.class).stream().collect(Collectors.toMap(ReformStatusEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ReformStatusEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
