package com.ejianc.business.quality.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 质量验收子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_quality_accept_content")
public class QualityAcceptContentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="quality_accept_id")
    private Long qualityAcceptId; // 质量验收id
    @TableField(value="inner_code")
    private String innerCode; // 内置编码
    @TableField(value="parent_id")
    private Long parentId; // 父id
    @TableField(value="sub_project_name")
    private String subProjectName; // 分部工程
    @TableField(value="sub_item_name")
    private String subItemName; // 分项工程
    @TableField(value="check_batch")
    private String checkBatch; // 检验批
    @TableField(value="quality_control_point")
    private String qualityControlPoint; // 质量控制点
    @TableField(value="accept_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date acceptDate; // 验收日期
    @TableField(value="accept_conclusion")
    private String acceptConclusion; // 验收结论
    @TableField(value="accept_person")
    private String acceptPerson; // 验收人员
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value = "sub_item_id")
    private Long subItemId; //分部分项id
    
    

    public Long getQualityAcceptId() {
        return qualityAcceptId;
    }

    public void setQualityAcceptId(Long qualityAcceptId) {
        this.qualityAcceptId = qualityAcceptId;
    }
    public String getInnerCode() {
        return innerCode;
    }

    public void setInnerCode(String innerCode) {
        this.innerCode = innerCode;
    }
    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }
    public String getSubProjectName() {
        return subProjectName;
    }

    public void setSubProjectName(String subProjectName) {
        this.subProjectName = subProjectName;
    }
    public String getSubItemName() {
        return subItemName;
    }

    public void setSubItemName(String subItemName) {
        this.subItemName = subItemName;
    }
    public String getCheckBatch() {
        return checkBatch;
    }

    public void setCheckBatch(String checkBatch) {
        this.checkBatch = checkBatch;
    }
    public String getQualityControlPoint() {
        return qualityControlPoint;
    }

    public void setQualityControlPoint(String qualityControlPoint) {
        this.qualityControlPoint = qualityControlPoint;
    }
    public Date getAcceptDate() {
        return acceptDate;
    }

    public void setAcceptDate(Date acceptDate) {
        this.acceptDate = acceptDate;
    }
    public String getAcceptConclusion() {
        return acceptConclusion;
    }

    public void setAcceptConclusion(String acceptConclusion) {
        this.acceptConclusion = acceptConclusion;
    }
    public String getAcceptPerson() {
        return acceptPerson;
    }

    public void setAcceptPerson(String acceptPerson) {
        this.acceptPerson = acceptPerson;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Long getSubItemId() {
        return subItemId;
    }

    public void setSubItemId(Long subItemId) {
        this.subItemId = subItemId;
    }
}
