package com.ejianc.business.quality.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.quality.bean.QualityExcellenceEntity;
import com.ejianc.business.quality.service.IQualityExcellenceService;
import com.ejianc.business.quality.vo.QualityExcellenceVO;

/**
 * 质量创优
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("qualityExcellence")
public class QualityExcellenceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "QUALITY-EXCELLENCE";//此处需要根据实际修改

    @Autowired
    private IQualityExcellenceService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QualityExcellenceVO> saveOrUpdate(@RequestBody QualityExcellenceVO saveOrUpdateVO) {
    	QualityExcellenceEntity entity = BeanMapper.map(saveOrUpdateVO, QualityExcellenceEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //默认设置获奖状态
        entity.setState(0);
    	service.saveOrUpdate(entity, false);
    	QualityExcellenceVO vo = BeanMapper.map(entity, QualityExcellenceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<QualityExcellenceVO> update(@RequestBody QualityExcellenceVO updateVO) {
        QualityExcellenceEntity entity = BeanMapper.map(updateVO, QualityExcellenceEntity.class);
        //设置获奖状态
        if (entity.getIsReward() == 0) {
            entity.setState(2);//未获奖
        } else {
            entity.setState(3);//已获奖
        }
        service.update(new UpdateWrapper<QualityExcellenceEntity>().set("is_reward",entity.getIsReward()).set("reward_date",entity.getRewardDate()).set("explain",entity.getExplain()).set("state",entity.getState()).eq("id",entity.getId()));
        QualityExcellenceVO vo = BeanMapper.map(entity, QualityExcellenceVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<QualityExcellenceVO> queryDetail(Long id) {
    	QualityExcellenceEntity entity = service.selectById(id);
    	QualityExcellenceVO vo = BeanMapper.map(entity, QualityExcellenceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<QualityExcellenceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (QualityExcellenceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(QualityExcellenceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<QualityExcellenceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("excellentName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        IPage<QualityExcellenceEntity> page = service.queryPage(param,false);
        IPage<QualityExcellenceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), QualityExcellenceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("secondUnit");
        fuzzyFields.add("projectName");
        fuzzyFields.add("excellentName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<QualityExcellenceEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<QualityExcellenceVO> list = BeanMapper.mapList(pageData.getRecords(), QualityExcellenceVO.class);
            list.forEach(vo -> {
                        vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                        if (vo.getState() == 0)
                            vo.setStateName("申请中");
                        else if (vo.getState() == 1)
                            vo.setStateName("评审中");
                        else if (vo.getState() == 2)
                            vo.setStateName("未获奖");
                        else if (vo.getState() == 3)
                            vo.setStateName("已获奖");
                        if(vo.getRewardType() == 0)
                            vo.setRewardTypeName("创地市级“优质结构工程”");
                        else if(vo.getRewardType() == 1)
                            vo.setRewardTypeName("创地市级“优质工程”");
                        else if(vo.getRewardType() == 2)
                            vo.setRewardTypeName("创省级“优质结构工程”");
                        else if(vo.getRewardType() == 3)
                            vo.setRewardTypeName("创省部级“优质工程”");
                        else if(vo.getRewardType() == 4)
                            vo.setRewardTypeName("创国家级“优质工程”");
                        else if(vo.getRewardType() == 5)
                            vo.setRewardTypeName("鲁班奖");
                    });
            beans.put("records", list);
            ExcelExport.getInstance().export("QualityExcellence-export.xlsx", beans, response);
        }
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refQualityExcellenceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<QualityExcellenceVO>> refQualityExcellenceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<QualityExcellenceEntity> page = service.queryPage(param,false);
        IPage<QualityExcellenceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), QualityExcellenceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
