package com.ejianc.business.safety.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;


import com.ejianc.business.safety.bean.SafetySceneSafetyCheckCategoryEntity;
import com.ejianc.business.safety.mapper.SafetySceneSafetyCheckCategoryMapper;
import com.ejianc.business.safety.service.ISafetySceneSafetyCheckCategoryService;
import com.ejianc.business.scene.vo.SafetySceneSafetyCheckCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * 资源管理-安全检查分类表
 * 
 * @author generator
 * 
 */
@Service("safetySceneSafetyCheckCategoryService")
public class SafetySceneSafetyCheckCategoryServiceImpl extends BaseServiceImpl<SafetySceneSafetyCheckCategoryMapper, SafetySceneSafetyCheckCategoryEntity> implements ISafetySceneSafetyCheckCategoryService {

    @Autowired
    private SafetySceneSafetyCheckCategoryMapper mapper;

    @Override
    public SafetySceneSafetyCheckCategoryEntity queryByCode(String code) {
        QueryWrapper<SafetySceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.eq("code", code);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.getOne(query);
    }

    @Override
    public List<SafetySceneSafetyCheckCategoryEntity> queryListByPid(List<Long> ids) {
        QueryWrapper<SafetySceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("parent_id", ids);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);

        return super.list(query);
    }

    @Override
    public List<SafetySceneSafetyCheckCategoryEntity> queryByCodes(ArrayList<String> codes) {
        QueryWrapper<SafetySceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.in("code", codes);
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        return super.list(query);
    }

    @Override
    public List<SafetySceneSafetyCheckCategoryVO> queryAllByPid(Long pid) {
        List<SafetySceneSafetyCheckCategoryVO> resp = new ArrayList<>();
        SafetySceneSafetyCheckCategoryEntity entity = super.selectById(pid);

        QueryWrapper<SafetySceneSafetyCheckCategoryEntity> query = new QueryWrapper<>();
        query.likeRight("inner_code", entity.getInnerCode());
        query.eq("tenant_id", InvocationInfoProxy.getTenantid());
        query.eq("dr", BaseVO.DR_UNDELETE);
        List<SafetySceneSafetyCheckCategoryEntity> dataList = super.list(query);

        if(CollectionUtils.isNotEmpty(dataList)) {
            resp = BeanMapper.mapList(dataList, SafetySceneSafetyCheckCategoryVO.class);
        }
        return resp;
    }

    @Override
    public List<SafetySceneSafetyCheckCategoryVO> queryList(Map<String, Object> condition) {
        return mapper.queryList(condition);
    }
}
