package com.ejianc.business.safety.controller;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.safety.bean.SafetySceneCheckDetailEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckEntity;
import com.ejianc.business.safety.bean.SafetySceneCheckRecordEntity;
import com.ejianc.business.safety.service.ISafetySceneCheckDetailService;
import com.ejianc.business.safety.service.ISafetySceneCheckRecordService;
import com.ejianc.business.safety.service.ISafetySceneCheckService;
import com.ejianc.business.safety.service.SafetyCheckMessageService;
import com.ejianc.business.scene.util.*;
import com.ejianc.business.scene.vo.SafetySceneCheckDetailVO;
import com.ejianc.business.scene.vo.SafetySceneCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Controller
@RequestMapping("safetyReview")
@Api(value = "待复检", tags = {"检查单主子表"})
public class SafetyReviewController {

    @Autowired
    private ISafetySceneCheckService service;
    @Autowired
    private ISafetySceneCheckDetailService sceneCheckDetailService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ISafetySceneCheckRecordService sceneCheckRecordService;
    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IAttachmentApi iAttachmentApi;

    @Autowired
    private SafetyCheckMessageService checkMessageService;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${oms.fileServerPath}")
    private String baseImgUrl;



    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @ApiOperation("待复检查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> queryDetail(@RequestParam Long id) {
        SafetySceneCheckEntity entity = service.selectById(id);
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        List<SafetySceneCheckDetailVO> sceneCheckDetailVOList = BeanMapper.mapList(sceneCheckDetails, SafetySceneCheckDetailVO.class);
        if (CollectionUtils.isNotEmpty(sceneCheckDetails))
        {
            sceneCheckDetailVOList.forEach(item->{
                item.setBaseImgUrl(baseImgUrl);
            });
        }
        SafetySceneCheckVO vo = BeanMapper.map(entity, SafetySceneCheckVO.class);
        vo.setSceneCheckDetails(sceneCheckDetailVOList);
        return CommonResponse.success("查询详情数据成功！", vo);
    }


    @ApiOperation("查询待复检单据")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SafetySceneCheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("checkName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("reviewPerson");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        //  待复检的（待整改全部提交） 复查不合格的
        param.getParams().put("reform_status", new Parameter(QueryParam.IN, Arrays.asList(ReformState.REVIEW_STATE.getCode(), ReformState.REVIEW_FAILED_STATE.getCode())));
        param.getParams().put("review_id", new Parameter(QueryParam.LIKE, sessionManager.getUserContext().getUserId().toString()));
        IPage<SafetySceneCheckEntity> page = service.queryPage(param, false);
        IPage<SafetySceneCheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SafetySceneCheckVO.class));
        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    @ApiOperation("提交复查信息")
    @RequestMapping(value = "/submitReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> submitReviewNews(@ApiParam(name = "submitReviewNews", required = true) @RequestBody SafetySceneCheckVO param) {
        SafetySceneCheckEntity entity = BeanMapper.map(param, SafetySceneCheckEntity.class);
        SafetySceneCheckVO vo = BeanMapper.map(entity, SafetySceneCheckVO.class);
        LambdaUpdateWrapper<SafetySceneCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.eq(SafetySceneCheckEntity::getId, entity.getId());
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            List<Integer> reviewResults = sceneCheckDetails.stream().map(SafetySceneCheckDetailEntity::getReviewResult).collect(Collectors.toList());
            //提交是否复查不合格的话
            List<SafetySceneCheckRecordEntity> list = new ArrayList<>();
            List<SafetySceneCheckDetailEntity> sceneCheckDetailList = null;
            if (reviewResults.contains(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                //复检不合格的话，把整改状态设置为3
                updateWrapper.set(SafetySceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FAILED_STATE.getCode()));
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgId(entity.getId());
                vo.setMsgBillCode(entity.getBillCode());
                vo.setMsgNum(sceneCheckDetailList.size());
                String reformDutyId = vo.getReformDutyId();
                if (reformDutyId!=null){
                    String[] reformDutyIds = reformDutyId.split(",");
                    checkMessageService.sendMsg(vo,reformDutyIds, NoticeEnum.REVIEW_COMMIT_UNPASS);
                }
            }
            //合格的个数
            int size = reviewResults.stream().filter(reviewResult -> reviewResult == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList()).size();
            //合格的数等于检查项的数 全部合格
            if (size == sceneCheckDetails.size()) {
                //全部合格的话，整改状态该为reformStatus 设置为4 全部完成
                updateWrapper.set(SafetySceneCheckEntity::getReformStatus, Integer.parseInt(ReformState.REVIEW_FINISHED_STATE.getCode()));
                //设置复检信息
                sceneCheckDetailList = sceneCheckDetails.stream().filter(sceneCheckDetail -> sceneCheckDetail.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).collect(Collectors.toList());
                vo.setMsgBillCode(entity.getBillCode());
                String notifRelevantId = vo.getNotifRelevantId();
                if (notifRelevantId!=null) {
                    String[] notifRelevantIds = notifRelevantId.split(",");
                    vo.setMsgId(entity.getId());
                    vo.setMsgNum(0);
                    checkMessageService.sendMsg(vo,notifRelevantIds,NoticeEnum.REVIEW_COMMIT_PASS);
                }
            }
            //生成复查信息
            sceneCheckDetailList.forEach(item -> {
                if (item.getIsReform()==Integer.parseInt(CheckItemReformState.REVIEW_REFORM_STATE.getCode())) {
                    SafetySceneCheckRecordEntity sceneCheckRecord = new SafetySceneCheckRecordEntity();
                    sceneCheckRecord.setPid(item.getId());
                    sceneCheckRecord.setCheckId(item.getPid());
                    //设置操作状态
                    sceneCheckRecord.setOperationType(Integer.parseInt(OperationState.REVIEW_STATE.getCode()));
                    sceneCheckRecord.setReviewPerson(item.getActualReviewer());
                    sceneCheckRecord.setReviewDescribe(item.getReviewDescribe());
                    sceneCheckRecord.setReviewResult(item.getReviewResult());
                    sceneCheckRecord.setImgIds(item.getReviewImgIds());
                    sceneCheckRecord.setImgUrl(item.getReviewImgUrl());
                    sceneCheckRecord.setCheckPerson(item.getCheckPerson());
                    sceneCheckRecord.setCheckItem(item.getCheckItem());
                    sceneCheckRecord.setRectificationPerson(item.getCurrentRectificationPerson());
                    sceneCheckRecord.setRectificationDescribe(item.getReformMsg());
                    list.add(sceneCheckRecord);
                }
            });
            if (CollectionUtils.isNotEmpty(list)) {
                sceneCheckRecordService.saveBatch(list, list.size());
            }




            //解除文件服务器和待整改的绑定
            sceneCheckDetails.forEach(sceneCheckitem->{
                if (ReviewState.REVIEW_FAILED_STATE.getCode().equals(sceneCheckitem.getReviewResult())){
                    QueryParam queryParam = new QueryParam();
                    queryParam.getParams().put("pid", new Parameter(QueryParam.EQ,sceneCheckitem.getId() ));
                    queryParam.getOrderMap().put("createTime", QueryParam.DESC);
                    queryParam.getParams().put("operation_type", new Parameter(QueryParam.EQ, Integer.parseInt(OperationState.REFORM_STATE.getCode())));

                    List<SafetySceneCheckRecordEntity> sceneCheckRecords = sceneCheckRecordService.queryList(queryParam);
                    if (CollectionUtils.isNotEmpty(sceneCheckRecords)) {
                        System.out.println(sceneCheckRecords);
                        SafetySceneCheckRecordEntity sceneCheckRecordEntity = sceneCheckRecords.get(0);
                        if (sceneCheckRecordEntity.getImgIds()!=null)
                        {
                            List<String> imgids = Arrays.asList(sceneCheckRecordEntity.getImgIds().split(","));
                            List<Long> attachIds = new ArrayList<>();
                            imgids.forEach(item->{
                                attachIds.add(Long.parseLong(item));
                            });
                            iAttachmentApi.updateAttachRef(sceneCheckRecordEntity.getId(), attachIds);
                        }
                    }
                }
            });


            //设置（检查结果）复查信息
            sceneCheckDetails.forEach(item -> {
                LambdaUpdateWrapper<SafetySceneCheckDetailEntity> updateReviewMsgWrapper = new LambdaUpdateWrapper<>();
                updateReviewMsgWrapper.eq(SafetySceneCheckDetailEntity::getId, item.getId());
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                String dateTime = df.format(new Date());
                String reviewDescribe = "";
                if (StringUtils.isNotEmpty(item.getReviewDescribe())) {
                    reviewDescribe = item.getReviewDescribe();
                }
                updateReviewMsgWrapper.set(SafetySceneCheckDetailEntity::getReviewMsg, item.getActualReviewer() + "-" + dateTime + "-" + reviewDescribe);
                Integer reviewResult = item.getReviewResult();
                sceneCheckDetailService.update(updateReviewMsgWrapper);
            });
        }
        //复检结果为复查不合格或者合格  isModify 修改为1 待复检为 0
        sceneCheckDetails.forEach(item -> {
            if (item.getReviewResult() != Integer.parseInt(ReviewState.REVIEW_STATE.getCode())) {
                LambdaUpdateWrapper<SafetySceneCheckDetailEntity> isModifyWrapper = new LambdaUpdateWrapper<>();
                isModifyWrapper.eq(SafetySceneCheckDetailEntity::getId, item.getId());
                isModifyWrapper.set(SafetySceneCheckDetailEntity::getIsModify, Integer.parseInt(ModifyState.MODIFIED_STATE.getCode()));
                sceneCheckDetailService.update(isModifyWrapper);
            }
        });
        System.out.println("=============");
        System.out.println(sceneCheckDetails);
        //设置 整改状态  检查结果状态描述
        sceneCheckDetails.forEach(item -> {
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())) {
                LambdaUpdateWrapper<SafetySceneCheckDetailEntity> sceneUpdateWrapper = new LambdaUpdateWrapper<>();
                sceneUpdateWrapper.eq(SafetySceneCheckDetailEntity::getId, item.getId());
                sceneUpdateWrapper.set(SafetySceneCheckDetailEntity::getReviewDate,new Date());
                sceneUpdateWrapper.set(SafetySceneCheckDetailEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
                sceneUpdateWrapper.set(SafetySceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_FAILED_STATE.getDescription());
                sceneUpdateWrapper.set(SafetySceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_FAILED_STATE.getCode()));
                sceneUpdateWrapper.set(SafetySceneCheckDetailEntity::getReviewResult, ReviewState.REVIEW_FAILED_STATE.getCode());
                sceneCheckDetailService.update(sceneUpdateWrapper);
            }
            //合格设置为3
            if ((item.getReviewResult() != null) && item.getReviewResult() == Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())) {
                LambdaUpdateWrapper<SafetySceneCheckDetailEntity> successWrapper = new LambdaUpdateWrapper<>();
                successWrapper.eq(SafetySceneCheckDetailEntity::getId, item.getId());
                successWrapper.set(SafetySceneCheckDetailEntity::getTaskState, CheckItemReformState.REFORM_SUCCESS_STATE.getDescription());

                successWrapper.set(SafetySceneCheckDetailEntity::getReviewResult, ReviewState.REVIEW_FINISHED_STATE.getCode());
                successWrapper.set(SafetySceneCheckDetailEntity::getIsReform, Integer.parseInt(CheckItemReformState.REFORM_SUCCESS_STATE.getCode()));
                if (item.getReviewDate()==null)
                {
                    successWrapper.set(SafetySceneCheckDetailEntity::getReviewDate,new Date());
                }
                sceneCheckDetailService.update(successWrapper);
            }
        });
        //分组
        Map<Integer, List<SafetySceneCheckDetailEntity>> reviewMap = sceneCheckDetails.stream().filter(reviewItem -> reviewItem.getReviewResult() != null)
                .collect(Collectors.groupingBy(SafetySceneCheckDetailEntity::getReviewResult));

        //设置已提交
        updateWrapper.set(SafetySceneCheckEntity::getReviewStatus, Integer.parseInt(SubmitState.IS_SUBMITTED.getCode()));
        if (!reviewMap.isEmpty()) {
            //设置已完成  合格的
            int reviewFinished = 0;
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode()))) {
                LambdaUpdateWrapper<SafetySceneCheckEntity> revieweFinishedWrapper = new LambdaUpdateWrapper<>();
                reviewFinished = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FINISHED_STATE.getCode())).size();
                revieweFinishedWrapper.set(SafetySceneCheckEntity::getReviewPass, reviewFinished);
                revieweFinishedWrapper.eq(SafetySceneCheckEntity::getId, entity.getId());
                boolean update = service.update(revieweFinishedWrapper);
            }
            //设置已复查（合格不合格的）
            if (reviewMap.containsKey(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode()))) {
                LambdaUpdateWrapper<SafetySceneCheckEntity> revieweFailedWrapper = new LambdaUpdateWrapper<>();
                int reviewFailed = reviewMap.get(Integer.parseInt(ReviewState.REVIEW_FAILED_STATE.getCode())).size();
                int size = reviewFinished + reviewFailed;
                revieweFailedWrapper.set(SafetySceneCheckEntity::getReviewedNum, size);
                revieweFailedWrapper.eq(SafetySceneCheckEntity::getId, entity.getId());
                boolean update = service.update(revieweFailedWrapper);
            }
        }

        boolean update = service.update(updateWrapper);
        if (update) {
            Long id = entity.getId();
            SafetySceneCheckEntity checkenEntity = service.selectById(id);
            SafetySceneCheckVO scenecheckvo = BeanMapper.map(checkenEntity, SafetySceneCheckVO.class);
            return CommonResponse.success("提交成功！", scenecheckvo);
        }
        return CommonResponse.error("提交失败！");
    }


    @ApiOperation("保存复查信息")
    @RequestMapping(value = "/saveReviewNews", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SafetySceneCheckVO> saveReviewNews(@ApiParam(name = "saveReviewNews", required = true) @RequestBody SafetySceneCheckVO param) {
        SafetySceneCheckEntity entity = BeanMapper.map(param, SafetySceneCheckEntity.class);
        List<SafetySceneCheckDetailEntity> sceneCheckDetails = entity.getSceneCheckDetails();
        //设置，复查结果，复查描述，复查图片 信息  /设置当前登录人为实际复查人
        if (CollectionUtils.isNotEmpty(sceneCheckDetails)) {
            sceneCheckDetails.forEach(sceneCheckDetail -> {
                LambdaUpdateWrapper<SafetySceneCheckDetailEntity> updateWrapper = new LambdaUpdateWrapper<>();
                String userName = sessionManager.getUserContext().getUserName();
                updateWrapper.set(SafetySceneCheckDetailEntity::getActualReviewer, userName);
                updateWrapper.eq(SafetySceneCheckDetailEntity::getId, sceneCheckDetail.getId());
                updateWrapper.set(SafetySceneCheckDetailEntity::getReviewResult, sceneCheckDetail.getReviewResult());
                updateWrapper.set(SafetySceneCheckDetailEntity::getReviewDescribe, sceneCheckDetail.getReviewDescribe());
                updateWrapper.set(SafetySceneCheckDetailEntity::getReviewImgIds, sceneCheckDetail.getReviewImgIds());
                updateWrapper.set(SafetySceneCheckDetailEntity::getReviewImgUrl, sceneCheckDetail.getReviewImgUrl());
                sceneCheckDetailService.update(updateWrapper);
            });
        }
        Long id = entity.getId();
        SafetySceneCheckEntity sceneCheck = service.selectById(id);
        SafetySceneCheckVO vo = BeanMapper.map(sceneCheck, SafetySceneCheckVO.class);
        return CommonResponse.success("保存或修改单据成功！", vo);
    }


}
