package com.ejianc.business.quality.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.quality.bean.QualityExcellenceContentEntity;
/**
 * 质量创优
 * 
 * @author generator
 * 
 */
 @TableName("ejc_scene_quality_excellence")
public class QualityExcellenceEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="state")
    private Integer state; // 状态
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="project_location")
    private String projectLocation; // 项目地址
    @TableField(value="begin_date")
    private Date beginDate; // 开工日期
    @TableField(value="complete_date")
    private Date completeDate; // 竣工日期
    @TableField(value="project_scan")
    private String projectScan; // 工程规模
    @TableField(value="project_manager")
    private String projectManager; // 项目经理
    @TableField(value="reward_type")
    private Integer rewardType; // 奖励类型
    @TableField(value="excellent_name")
    private String excellentName; // 创优名称
    @TableField(value="excellent_date")
    private Date excellentDate; // 创优申报日期
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="employee_code")
    private String employeeCode; // 经办人编码
    @TableField(value="employee_part")
    private String employeePart; // 经办部门
    @TableField(value="excellent_condition")
    private String excellentCondition; // 创优活动开展情况
    @TableField(value="check_date")
    private Date checkDate; // 检查日期
    @TableField(value="reward_date")
    private Date rewardDate; // 获奖日期
    @TableField(value="is_reward")
    private Integer isReward; // 是否获奖
    @TableField(value="explain")
    private String explain; // 说明
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_code")
    private String orgCode; // 组织code
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="second_unit")
    private String secondUnit; // 二级单位
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="qualityExcellenceContentService",pidName = "pid")
    private List<QualityExcellenceContentEntity> qualityExcellenceContentList = new ArrayList<>(); // 质量创优子表
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getState() {
        return state;
    }

    public void setState(Integer state) {
        this.state = state;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getProjectLocation() {
        return projectLocation;
    }

    public void setProjectLocation(String projectLocation) {
        this.projectLocation = projectLocation;
    }
    public Date getBeginDate() {
        return beginDate;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }
    public Date getCompleteDate() {
        return completeDate;
    }

    public void setCompleteDate(Date completeDate) {
        this.completeDate = completeDate;
    }
    public String getProjectScan() {
        return projectScan;
    }

    public void setProjectScan(String projectScan) {
        this.projectScan = projectScan;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    public Integer getRewardType() {
        return rewardType;
    }

    public void setRewardType(Integer rewardType) {
        this.rewardType = rewardType;
    }
    public String getExcellentName() {
        return excellentName;
    }

    public void setExcellentName(String excellentName) {
        this.excellentName = excellentName;
    }
    public Date getExcellentDate() {
        return excellentDate;
    }

    public void setExcellentDate(Date excellentDate) {
        this.excellentDate = excellentDate;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getEmployeeCode() {
        return employeeCode;
    }

    public void setEmployeeCode(String employeeCode) {
        this.employeeCode = employeeCode;
    }
    public String getEmployeePart() {
        return employeePart;
    }

    public void setEmployeePart(String employeePart) {
        this.employeePart = employeePart;
    }
    public String getExcellentCondition() {
        return excellentCondition;
    }

    public void setExcellentCondition(String excellentCondition) {
        this.excellentCondition = excellentCondition;
    }
    public Date getCheckDate() {
        return checkDate;
    }

    public void setCheckDate(Date checkDate) {
        this.checkDate = checkDate;
    }
    public Date getRewardDate() {
        return rewardDate;
    }

    public void setRewardDate(Date rewardDate) {
        this.rewardDate = rewardDate;
    }
    public Integer getIsReward() {
        return isReward;
    }

    public void setIsReward(Integer isReward) {
        this.isReward = isReward;
    }
    public String getExplain() {
        return explain;
    }

    public void setExplain(String explain) {
        this.explain = explain;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getSecondUnit() {
        return secondUnit;
    }

    public void setSecondUnit(String secondUnit) {
        this.secondUnit = secondUnit;
    }
    

    public List<QualityExcellenceContentEntity> getQualityExcellenceContentList() {
        return qualityExcellenceContentList;
    }

    public void setQualityExcellenceContentList(List<QualityExcellenceContentEntity> qualityExcellenceContentList) {
        this.qualityExcellenceContentList = qualityExcellenceContentList;
    }
}
