package com.ejianc.business.repay.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 风险金退还表
 *
 * @author generator
 */
public class RepayVO extends BaseVO {
	private static final long serialVersionUID = 1L;

	private Long orgId; // 组织id
	private String orgCode; // 组织编码
	private String orgName; // 组织名称
	private Long employeeId; // 经办人id
	private String employeeName; // 经办人名称
	private Long departmentId; // 经办人部门id
	private String departmentCode; // 经办人部门编码
	private String departmentName; // 经办人部门名称
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private String commitUserName; // 提交人名称
	private String commitUserCode; // 提交人账号
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date effectiveDate; // 生效日期
	private String billCode; // 单据编码
	private String billName; // 单据名称
	private String billType; // 单据类型
	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private Long payerDetailId; // 员工明细id
	private String payerDetailCode; // 员工明细编码
	private String payerDetailName; // 员工明细名称
	private Long userId; // 用户id
	private String userCode; // 用户编码
	private String userName; // 用户名称
	private Long sourceUserId; // 来源用户id
	private String sourceUserCode; // 来源用户编码
	private String sourceUserName; // 来源用户名称
	private Long sourceBillId; // 来源单据id
	private String sourceBillCode; // 来源单据编码
	private String sourceBillName; // 来源单据名称
	private String sourceBillType; // 来源单据类型
	private Long sourceOrgId; // 来源组织id
	private String sourceOrgCode; // 来源组织编码
	private String sourceOrgName; // 来源组织名称
	private Integer sourcePeriodizationFlag; // 来源是否分期（0：否，1：是）
	private BigDecimal sourcePayerMny; // 来源应缴纳金额
	private BigDecimal sourceActualPayerMny; // 来源实际已缴纳金额
	private BigDecimal sourcePayScale; // 来源实际已缴纳比例
	private BigDecimal sourceRemainderPayerMny; // 来源剩余缴纳金额
	private BigDecimal sourcePeriodizationMny; // 来源分期金额
	private Integer sourcePeriodizationNum; // 来源分期数
	private BigDecimal payerMny; // 应缴纳金额
	private String type; // 类型（0：退还，1：调动）
	private String typeName; // 类型名称
	private BigDecimal repayTaxMny; // 本期退/调金额
	private BigDecimal actuallyLastPayTaxMny; // 累计实际缴纳金额
	private BigDecimal actuallyTotalPayTaxMny; // 含本期实际缴纳金额
	private BigDecimal repayAuditedValue; // 退/调前一期审定产值
	private BigDecimal actuallyPayScale; // 含本期实际缴纳占比
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date repayDate; // 退/调日期
	private Long transferOrgId; // 调动组织id
	private String transferOrgCode; // 调动组织编码
	private String transferOrgName; // 调动组织名称
	private String memo; // 备注
	private Integer confirmStatus; // 确认状态（0：待确认，1：确认中，2：已确认）
	private String confirmStatusName; // 确认状态名称
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date confirmDate; // 确认时间
	private Long confirmUserId; // 确认人id
	private String confirmUserName; // 确认人名称
	private String confirmUserCode; // 确认人账号


	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	@ReferDeserialTransfer
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	@ReferDeserialTransfer
	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentCode() {
		return departmentCode;
	}

	public void setDepartmentCode(String departmentCode) {
		this.departmentCode = departmentCode;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getPayerDetailId() {
		return payerDetailId;
	}

	@ReferDeserialTransfer
	public void setPayerDetailId(Long payerDetailId) {
		this.payerDetailId = payerDetailId;
	}

	public String getPayerDetailCode() {
		return payerDetailCode;
	}

	public void setPayerDetailCode(String payerDetailCode) {
		this.payerDetailCode = payerDetailCode;
	}

	public String getPayerDetailName() {
		return payerDetailName;
	}

	public void setPayerDetailName(String payerDetailName) {
		this.payerDetailName = payerDetailName;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public Long getSourceUserId() {
		return sourceUserId;
	}

	public void setSourceUserId(Long sourceUserId) {
		this.sourceUserId = sourceUserId;
	}

	public String getSourceUserCode() {
		return sourceUserCode;
	}

	public void setSourceUserCode(String sourceUserCode) {
		this.sourceUserCode = sourceUserCode;
	}

	public String getSourceUserName() {
		return sourceUserName;
	}

	public void setSourceUserName(String sourceUserName) {
		this.sourceUserName = sourceUserName;
	}

	public Long getSourceBillId() {
		return sourceBillId;
	}

	public void setSourceBillId(Long sourceBillId) {
		this.sourceBillId = sourceBillId;
	}

	public String getSourceBillCode() {
		return sourceBillCode;
	}

	public void setSourceBillCode(String sourceBillCode) {
		this.sourceBillCode = sourceBillCode;
	}

	public String getSourceBillName() {
		return sourceBillName;
	}

	public void setSourceBillName(String sourceBillName) {
		this.sourceBillName = sourceBillName;
	}

	public String getSourceBillType() {
		return sourceBillType;
	}

	public void setSourceBillType(String sourceBillType) {
		this.sourceBillType = sourceBillType;
	}

	public Long getSourceOrgId() {
		return sourceOrgId;
	}

	public void setSourceOrgId(Long sourceOrgId) {
		this.sourceOrgId = sourceOrgId;
	}

	public String getSourceOrgCode() {
		return sourceOrgCode;
	}

	public void setSourceOrgCode(String sourceOrgCode) {
		this.sourceOrgCode = sourceOrgCode;
	}

	public String getSourceOrgName() {
		return sourceOrgName;
	}

	public void setSourceOrgName(String sourceOrgName) {
		this.sourceOrgName = sourceOrgName;
	}

	public Integer getSourcePeriodizationFlag() {
		return sourcePeriodizationFlag;
	}

	public void setSourcePeriodizationFlag(Integer sourcePeriodizationFlag) {
		this.sourcePeriodizationFlag = sourcePeriodizationFlag;
	}

	public BigDecimal getSourcePayerMny() {
		return sourcePayerMny;
	}

	public void setSourcePayerMny(BigDecimal sourcePayerMny) {
		this.sourcePayerMny = sourcePayerMny;
	}

	public BigDecimal getSourceActualPayerMny() {
		return sourceActualPayerMny;
	}

	public void setSourceActualPayerMny(BigDecimal sourceActualPayerMny) {
		this.sourceActualPayerMny = sourceActualPayerMny;
	}

	public BigDecimal getSourcePayScale() {
		return sourcePayScale;
	}

	public void setSourcePayScale(BigDecimal sourcePayScale) {
		this.sourcePayScale = sourcePayScale;
	}

	public BigDecimal getSourceRemainderPayerMny() {
		return sourceRemainderPayerMny;
	}

	public void setSourceRemainderPayerMny(BigDecimal sourceRemainderPayerMny) {
		this.sourceRemainderPayerMny = sourceRemainderPayerMny;
	}

	public BigDecimal getSourcePeriodizationMny() {
		return sourcePeriodizationMny;
	}

	public void setSourcePeriodizationMny(BigDecimal sourcePeriodizationMny) {
		this.sourcePeriodizationMny = sourcePeriodizationMny;
	}

	public Integer getSourcePeriodizationNum() {
		return sourcePeriodizationNum;
	}

	public void setSourcePeriodizationNum(Integer sourcePeriodizationNum) {
		this.sourcePeriodizationNum = sourcePeriodizationNum;
	}

	public BigDecimal getPayerMny() {
		return payerMny;
	}

	public void setPayerMny(BigDecimal payerMny) {
		this.payerMny = payerMny;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public BigDecimal getRepayTaxMny() {
		return repayTaxMny;
	}

	public void setRepayTaxMny(BigDecimal repayTaxMny) {
		this.repayTaxMny = repayTaxMny;
	}

	public BigDecimal getActuallyLastPayTaxMny() {
		return actuallyLastPayTaxMny;
	}

	public void setActuallyLastPayTaxMny(BigDecimal actuallyLastPayTaxMny) {
		this.actuallyLastPayTaxMny = actuallyLastPayTaxMny;
	}

	public BigDecimal getActuallyTotalPayTaxMny() {
		return actuallyTotalPayTaxMny;
	}

	public void setActuallyTotalPayTaxMny(BigDecimal actuallyTotalPayTaxMny) {
		this.actuallyTotalPayTaxMny = actuallyTotalPayTaxMny;
	}

	public BigDecimal getRepayAuditedValue() {
		return repayAuditedValue;
	}

	public void setRepayAuditedValue(BigDecimal repayAuditedValue) {
		this.repayAuditedValue = repayAuditedValue;
	}

	public BigDecimal getActuallyPayScale() {
		return actuallyPayScale;
	}

	public void setActuallyPayScale(BigDecimal actuallyPayScale) {
		this.actuallyPayScale = actuallyPayScale;
	}

	public Date getRepayDate() {
		return repayDate;
	}

	public void setRepayDate(Date repayDate) {
		this.repayDate = repayDate;
	}

	public Long getTransferOrgId() {
		return transferOrgId;
	}

	@ReferDeserialTransfer
	public void setTransferOrgId(Long transferOrgId) {
		this.transferOrgId = transferOrgId;
	}

	public String getTransferOrgCode() {
		return transferOrgCode;
	}

	public void setTransferOrgCode(String transferOrgCode) {
		this.transferOrgCode = transferOrgCode;
	}

	public String getTransferOrgName() {
		return transferOrgName;
	}

	public void setTransferOrgName(String transferOrgName) {
		this.transferOrgName = transferOrgName;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Integer getConfirmStatus() {
		return confirmStatus;
	}

	public void setConfirmStatus(Integer confirmStatus) {
		this.confirmStatus = confirmStatus;
	}

	public String getConfirmStatusName() {
		return confirmStatusName;
	}

	public void setConfirmStatusName(String confirmStatusName) {
		this.confirmStatusName = confirmStatusName;
	}

	public Date getConfirmDate() {
		return confirmDate;
	}

	public void setConfirmDate(Date confirmDate) {
		this.confirmDate = confirmDate;
	}

	public Long getConfirmUserId() {
		return confirmUserId;
	}

	public void setConfirmUserId(Long confirmUserId) {
		this.confirmUserId = confirmUserId;
	}

	public String getConfirmUserName() {
		return confirmUserName;
	}

	public void setConfirmUserName(String confirmUserName) {
		this.confirmUserName = confirmUserName;
	}

	public String getConfirmUserCode() {
		return confirmUserCode;
	}

	public void setConfirmUserCode(String confirmUserCode) {
		this.confirmUserCode = confirmUserCode;
	}

}
