package com.ejianc.business.standard.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.standard.vo.StandardChangeDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 风险金缴纳标准变更表主实体
 * 
 * @author generator
 * 
 */
public class StandardChangeVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 申请组织Id
    private String orgName; // 申请组织名称
    private String orgCode; // 申请组织编码
    private BigDecimal lastYearContractMny; // 上一年度完成合同额
    private BigDecimal lastYearOutputMny; // 上一年度产值
    private BigDecimal workerCongressContractMny; // 本年度职代会合同金额
    private BigDecimal outputMny; // 本年度产值
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date belongYear; // 所属年度
    private BigDecimal riskDepositPayableScale; // 风险金应缴纳比例
    private BigDecimal riskDepositPayableMny; // 风险金应缴纳金额(本年度职代会合同金额*应缴纳比例)
    private BigDecimal riskDepositMny; // 风险金申请缴纳金额
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    private String applyReason; // 申请事由
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ssz", timezone = "GMT+8")
    private Date effectDate; // 生效日期
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private BigDecimal beforeChangeRiskDepositMny; // 变更前缴纳金额
    private BigDecimal changingRiskDepositMny; // 变更中缴纳金额
    private Long directRiskDepositId; // 直管部风险保证金id（用于数据引用）
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private BigDecimal contractMny; // 合同金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractSignDate; // 合同签订日期
    private String riskDepositType; // 风险保证金类型(directDept-直管部、projectDept-项目部)
    private String changeItems; // 变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；
    private Long changeEmployeeId; // 变更经办人id
    private String changeEmployeeName; // 变更经办人名称
    private BigDecimal changeRiskDepositMny; // 本次变更金额
    private BigDecimal changeScale; // 本次变更比例
    private String changeReason; // 变更原因描述
    private Long mainStandardId; // 主风险保证金单据Id
    private String mainStandardCode; // 主风险保证金单据编码
    private BigDecimal baseMny; //初始版本金额
    private BigDecimal afterChangeRiskDepositMny; //变更后金额

    private List<StandardChangeDetailVO> detailList = new ArrayList<>(); // 风险金缴纳标准变更表子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public BigDecimal getLastYearContractMny() {
        return lastYearContractMny;
    }

    public void setLastYearContractMny(BigDecimal lastYearContractMny) {
        this.lastYearContractMny = lastYearContractMny;
    }
    public BigDecimal getLastYearOutputMny() {
        return lastYearOutputMny;
    }

    public void setLastYearOutputMny(BigDecimal lastYearOutputMny) {
        this.lastYearOutputMny = lastYearOutputMny;
    }
    public BigDecimal getWorkerCongressContractMny() {
        return workerCongressContractMny;
    }

    public void setWorkerCongressContractMny(BigDecimal workerCongressContractMny) {
        this.workerCongressContractMny = workerCongressContractMny;
    }
    public BigDecimal getOutputMny() {
        return outputMny;
    }

    public void setOutputMny(BigDecimal outputMny) {
        this.outputMny = outputMny;
    }
    public Date getBelongYear() {
        return belongYear;
    }

    public void setBelongYear(Date belongYear) {
        this.belongYear = belongYear;
    }
    public BigDecimal getRiskDepositPayableScale() {
        return riskDepositPayableScale;
    }

    public void setRiskDepositPayableScale(BigDecimal riskDepositPayableScale) {
        this.riskDepositPayableScale = riskDepositPayableScale;
    }
    public BigDecimal getRiskDepositPayableMny() {
        return riskDepositPayableMny;
    }

    public void setRiskDepositPayableMny(BigDecimal riskDepositPayableMny) {
        this.riskDepositPayableMny = riskDepositPayableMny;
    }
    public BigDecimal getRiskDepositMny() {
        return riskDepositMny;
    }

    public void setRiskDepositMny(BigDecimal riskDepositMny) {
        this.riskDepositMny = riskDepositMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangeRiskDepositMny() {
        return beforeChangeRiskDepositMny;
    }

    public void setBeforeChangeRiskDepositMny(BigDecimal beforeChangeRiskDepositMny) {
        this.beforeChangeRiskDepositMny = beforeChangeRiskDepositMny;
    }
    public BigDecimal getChangingRiskDepositMny() {
        return changingRiskDepositMny;
    }

    public void setChangingRiskDepositMny(BigDecimal changingRiskDepositMny) {
        this.changingRiskDepositMny = changingRiskDepositMny;
    }
    public Long getDirectRiskDepositId() {
        return directRiskDepositId;
    }

    public void setDirectRiskDepositId(Long directRiskDepositId) {
        this.directRiskDepositId = directRiskDepositId;
    }
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }
    public String getRiskDepositType() {
        return riskDepositType;
    }

    public void setRiskDepositType(String riskDepositType) {
        this.riskDepositType = riskDepositType;
    }
    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }
    @ReferDeserialTransfer
    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }
    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }
    public BigDecimal getChangeRiskDepositMny() {
        return changeRiskDepositMny;
    }

    public void setChangeRiskDepositMny(BigDecimal changeRiskDepositMny) {
        this.changeRiskDepositMny = changeRiskDepositMny;
    }
    public BigDecimal getChangeScale() {
        return changeScale;
    }

    public void setChangeScale(BigDecimal changeScale) {
        this.changeScale = changeScale;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Long getMainStandardId() {
        return mainStandardId;
    }

    public void setMainStandardId(Long mainStandardId) {
        this.mainStandardId = mainStandardId;
    }
    public String getMainStandardCode() {
        return mainStandardCode;
    }

    public void setMainStandardCode(String mainStandardCode) {
        this.mainStandardCode = mainStandardCode;
    }

    public List<StandardChangeDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<StandardChangeDetailVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public BigDecimal getAfterChangeRiskDepositMny() {
        return afterChangeRiskDepositMny;
    }

    public void setAfterChangeRiskDepositMny(BigDecimal afterChangeRiskDepositMny) {
        this.afterChangeRiskDepositMny = afterChangeRiskDepositMny;
    }
}
