package com.ejianc.business.standard.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.standard.vo.StandardDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 风险金缴纳标准表主实体
 * 
 * @author generator
 * 
 */
public class StandardVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long orgId; // 申请组织Id
    private String orgName; // 申请组织名称
    private String orgCode; // 申请组织编码
    private BigDecimal lastYearContractMny; // 上一年度完成合同额
    private BigDecimal lastYearOutputMny; // 上一年度产值
    private BigDecimal workerCongressContractMny; // 本年度职代会合同金额
    private BigDecimal outputMny; // 本年度产值
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date belongYear; // 所属年度
    private BigDecimal riskDepositPayableScale; // 风险金应缴纳比例
    private BigDecimal riskDepositPayableMny; // 风险金应缴纳金额(本年度职代会合同金额*应缴纳比例)
    private BigDecimal riskDepositMny; // 风险金申请缴纳金额
    private Long employeeId; // 经办人id（申请人）
    private String employeeName; // 经办人名称（申请人）
    private Long departmentId; // 经办人部门id
    private String departmentName; // 经办人部门
    private String applyReason; // 申请事由
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectDate; // 生效日期
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private BigDecimal beforeChangeRiskDepositMny; // 变更前缴纳金额
    private BigDecimal changingRiskDepositMny; // 变更中缴纳金额
    private Long directRiskDepositId; // 直管部风险保证金id（用于数据引用）
    private Long projectId; // 项目Id
    private String projectName; // 项目名称
    private String projectCode; // 项目编码
    private Long contractId; // 合同id
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private BigDecimal contractMny; // 合同金额
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date contractSignDate; // 合同签订日期
    private String riskDepositType; // 风险保证金类型(directDept-直管部、projectDept-项目部)
    private BigDecimal baseMny; //初始版本金额
    private Long changeEmployeeId; // 变更经办人id
    private String changeEmployeeName; // 变更经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date changeEffectDate; // 变更生效日期

    private String billStateName; // 单据状态名称
    private String changeStatusName; // 变更状态名称
    private String belongYearName; // 所属年度



    private BigDecimal lastYearContractMnyWan; // 上一年度完成合同额（万元）
    private BigDecimal lastYearOutputMnyWan; // 上一年度产值（万元）
    private BigDecimal workerCongressContractMnyWan; // 本年度职代会合同金额（万元）
    private BigDecimal outputMnyWan; // 本年度产值（万元）
    private BigDecimal riskDepositPayableMnyWan; // 风险金应缴纳金额(本年度职代会合同金额*应缴纳比例)（万元）
    private BigDecimal riskDepositMnyWan; // 风险金申请缴纳金额（万元）
    private BigDecimal contractMnyWan; // 合同金额（万元）

    private Long projectParentOrgId; //缴纳员工所属项目父组织Id
    private String projectParentOrgName; //缴纳员工所属项目父组织名称
    private String projectParentOrgCode; //缴纳员工所属项目父组织编码



    private List<StandardDetailVO> detailList = new ArrayList<>(); // 风险金缴纳标准表子实体
    private List<StandardRecordVO> recordList = new ArrayList<>(); // 风险金缴纳标准表记录子实体

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public BigDecimal getLastYearContractMny() {
        return lastYearContractMny;
    }

    public void setLastYearContractMny(BigDecimal lastYearContractMny) {
        this.lastYearContractMny = lastYearContractMny;
    }
    public BigDecimal getLastYearOutputMny() {
        return lastYearOutputMny;
    }

    public void setLastYearOutputMny(BigDecimal lastYearOutputMny) {
        this.lastYearOutputMny = lastYearOutputMny;
    }
    public BigDecimal getWorkerCongressContractMny() {
        return workerCongressContractMny;
    }

    public void setWorkerCongressContractMny(BigDecimal workerCongressContractMny) {
        this.workerCongressContractMny = workerCongressContractMny;
    }
    public BigDecimal getOutputMny() {
        return outputMny;
    }

    public void setOutputMny(BigDecimal outputMny) {
        this.outputMny = outputMny;
    }
    public Date getBelongYear() {
        return belongYear;
    }

    public void setBelongYear(Date belongYear) {
        this.belongYear = belongYear;
    }
    public BigDecimal getRiskDepositPayableScale() {
        return riskDepositPayableScale;
    }

    public void setRiskDepositPayableScale(BigDecimal riskDepositPayableScale) {
        this.riskDepositPayableScale = riskDepositPayableScale;
    }
    public BigDecimal getRiskDepositPayableMny() {
        return riskDepositPayableMny;
    }

    public void setRiskDepositPayableMny(BigDecimal riskDepositPayableMny) {
        this.riskDepositPayableMny = riskDepositPayableMny;
    }
    public BigDecimal getRiskDepositMny() {
        return riskDepositMny;
    }

    public void setRiskDepositMny(BigDecimal riskDepositMny) {
        this.riskDepositMny = riskDepositMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    @ReferDeserialTransfer
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getApplyReason() {
        return applyReason;
    }

    public void setApplyReason(String applyReason) {
        this.applyReason = applyReason;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangeRiskDepositMny() {
        return beforeChangeRiskDepositMny;
    }

    public void setBeforeChangeRiskDepositMny(BigDecimal beforeChangeRiskDepositMny) {
        this.beforeChangeRiskDepositMny = beforeChangeRiskDepositMny;
    }
    public BigDecimal getChangingRiskDepositMny() {
        return changingRiskDepositMny;
    }

    public void setChangingRiskDepositMny(BigDecimal changingRiskDepositMny) {
        this.changingRiskDepositMny = changingRiskDepositMny;
    }
    public Long getDirectRiskDepositId() {
        return directRiskDepositId;
    }

    public void setDirectRiskDepositId(Long directRiskDepositId) {
        this.directRiskDepositId = directRiskDepositId;
    }
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public Date getContractSignDate() {
        return contractSignDate;
    }

    public void setContractSignDate(Date contractSignDate) {
        this.contractSignDate = contractSignDate;
    }
    public String getRiskDepositType() {
        return riskDepositType;
    }

    public void setRiskDepositType(String riskDepositType) {
        this.riskDepositType = riskDepositType;
    }

    public List<StandardDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<StandardDetailVO> detailList) {
        this.detailList = detailList;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }

    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }

    public Date getChangeEffectDate() {
        return changeEffectDate;
    }

    public void setChangeEffectDate(Date changeEffectDate) {
        this.changeEffectDate = changeEffectDate;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public String getChangeStatusName() {
        return changeStatusName;
    }

    public void setChangeStatusName(String changeStatusName) {
        this.changeStatusName = changeStatusName;
    }

    public String getBelongYearName() {
        return belongYearName;
    }

    public void setBelongYearName(String belongYearName) {
        this.belongYearName = belongYearName;
    }

    public List<StandardRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<StandardRecordVO> recordList) {
        this.recordList = recordList;
    }

    public BigDecimal getLastYearContractMnyWan() {
        return lastYearContractMnyWan;
    }

    public void setLastYearContractMnyWan(BigDecimal lastYearContractMnyWan) {
        this.lastYearContractMnyWan = lastYearContractMnyWan;
    }

    public BigDecimal getLastYearOutputMnyWan() {
        return lastYearOutputMnyWan;
    }

    public void setLastYearOutputMnyWan(BigDecimal lastYearOutputMnyWan) {
        this.lastYearOutputMnyWan = lastYearOutputMnyWan;
    }

    public BigDecimal getWorkerCongressContractMnyWan() {
        return workerCongressContractMnyWan;
    }

    public void setWorkerCongressContractMnyWan(BigDecimal workerCongressContractMnyWan) {
        this.workerCongressContractMnyWan = workerCongressContractMnyWan;
    }

    public BigDecimal getOutputMnyWan() {
        return outputMnyWan;
    }

    public void setOutputMnyWan(BigDecimal outputMnyWan) {
        this.outputMnyWan = outputMnyWan;
    }

    public BigDecimal getRiskDepositPayableMnyWan() {
        return riskDepositPayableMnyWan;
    }

    public void setRiskDepositPayableMnyWan(BigDecimal riskDepositPayableMnyWan) {
        this.riskDepositPayableMnyWan = riskDepositPayableMnyWan;
    }

    public BigDecimal getRiskDepositMnyWan() {
        return riskDepositMnyWan;
    }

    public void setRiskDepositMnyWan(BigDecimal riskDepositMnyWan) {
        this.riskDepositMnyWan = riskDepositMnyWan;
    }

    public BigDecimal getContractMnyWan() {
        return contractMnyWan;
    }

    public void setContractMnyWan(BigDecimal contractMnyWan) {
        this.contractMnyWan = contractMnyWan;
    }

    public Long getProjectParentOrgId() {
        return projectParentOrgId;
    }

    public void setProjectParentOrgId(Long projectParentOrgId) {
        this.projectParentOrgId = projectParentOrgId;
    }

    public String getProjectParentOrgName() {
        return projectParentOrgName;
    }

    public void setProjectParentOrgName(String projectParentOrgName) {
        this.projectParentOrgName = projectParentOrgName;
    }

    public String getProjectParentOrgCode() {
        return projectParentOrgCode;
    }

    public void setProjectParentOrgCode(String projectParentOrgCode) {
        this.projectParentOrgCode = projectParentOrgCode;
    }
}
