package com.ejianc.business.pay.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 风险金缴纳表
 *
 * @author generator
 */
public class PayVO extends BaseVO {
	private static final long serialVersionUID = 1L;

	private Long orgId; // 组织id
	private String orgCode; // 组织编码
	private String orgName; // 组织名称
	private Long projectId; // 项目id
	private String projectCode; // 项目编码
	private String projectName; // 项目名称
	private Long projectOrgId; // 项目所属组织id
	private String projectOrgCode; // 项目所属组织编码
	private String projectOrgName; // 项目所属组织名称
	private String riskDepositType; // 风险保证金类型
	private Long employeeId; // 经办人id
	private String employeeName; // 经办人名称
	private Long departmentId; // 经办人部门id
	private String departmentCode; // 经办人部门编码
	private String departmentName; // 经办人部门名称
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date commitDate; // 提交日期
	private String commitUserName; // 提交人名称
	private String commitUserCode; // 提交人账号
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date effectiveDate; // 生效日期
	private String billCode; // 单据编码
	private String billName; // 单据名称
	private String billType; // 单据类型
	private Integer billState; // 单据状态
	private String billStateName; // 单据状态名称
	private Long payerDetailId; // 员工明细id
	private String payerDetailCode; // 员工明细编码
	private String payerDetailName; // 员工明细名称
	private Long userId; // 用户id
	private String userCode; // 用户编码
	private String userName; // 用户名称
	private Long sourceUserId; // 来源用户id
	private String sourceUserCode; // 来源用户编码
	private String sourceUserName; // 来源用户名称
	private Long sourceBillId; // 来源单据id
	private String sourceBillCode; // 来源单据编码
	private String sourceBillName; // 来源单据名称
	private String sourceBillType; // 来源单据类型
	private Long sourcePayerId; // 来源明细主表id
	private Long sourceOrgId; // 来源组织id
	private String sourceOrgCode; // 来源组织编码
	private String sourceOrgName; // 来源组织名称
	private Integer sourcePeriodizationFlag; // 来源是否分期（0：否，1：是）
	private BigDecimal sourcePayerMny; // 来源应缴纳金额
	private BigDecimal sourceActualPayerMny; // 来源实际已缴纳金额
	private BigDecimal sourcePayScale; // 来源实际已缴纳比例
	private BigDecimal sourceRemainderPayerMny; // 来源剩余缴纳金额
	private BigDecimal sourcePeriodizationMny; // 来源分期金额
	private Integer sourcePeriodizationNum; // 来源分期数
	private Integer type; // 类型（0：缴纳，1：调入）
	private String typeName; // 类型名称
	private BigDecimal payerMny; // 应缴纳金额
	private BigDecimal payTaxMny; // 本期缴纳金额
	private BigDecimal lastPayTaxMny; // 历史版本缴纳金额
	private BigDecimal totalTaxMny; // 含本期已缴纳金额
	private BigDecimal payScale; // 含本期已缴纳比例
	private BigDecimal remainPayTaxMny; // 剩余缴纳金额
	private String installmentFlag; // 是否分期（0：否，1：是）
	private String installmentFlagName; // 是否分期名称
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date payDate; // 缴纳日期
	private BigDecimal installmentTaxMny; // 分期金额
	private Integer installmentNum; // 分期数
	private String memo; // 备注
	private Integer confirmStatus; // 确认状态（0：待确认，1：确认中，2：已确认）
	private String confirmStatusName; // 确认状态名称
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
	private Date confirmDate; // 确认时间
	private Long confirmUserId; // 确认人id
	private String confirmUserName; // 确认人名称
	private String confirmUserCode; // 确认人账号
	private String realOrgName; // 实际组织名称


	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getProjectId() {
		return projectId;
	}

	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}

	public String getProjectCode() {
		return projectCode;
	}

	public void setProjectCode(String projectCode) {
		this.projectCode = projectCode;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public Long getProjectOrgId() {
		return projectOrgId;
	}

	public void setProjectOrgId(Long projectOrgId) {
		this.projectOrgId = projectOrgId;
	}

	public String getProjectOrgCode() {
		return projectOrgCode;
	}

	public void setProjectOrgCode(String projectOrgCode) {
		this.projectOrgCode = projectOrgCode;
	}

	public String getProjectOrgName() {
		return projectOrgName;
	}

	public void setProjectOrgName(String projectOrgName) {
		this.projectOrgName = projectOrgName;
	}

	public String getRiskDepositType() {
		return riskDepositType;
	}

	public void setRiskDepositType(String riskDepositType) {
		this.riskDepositType = riskDepositType;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	@ReferDeserialTransfer
	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	@ReferDeserialTransfer
	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentCode() {
		return departmentCode;
	}

	public void setDepartmentCode(String departmentCode) {
		this.departmentCode = departmentCode;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public String getBillStateName() {
		return billStateName;
	}

	public void setBillStateName(String billStateName) {
		this.billStateName = billStateName;
	}

	public Long getPayerDetailId() {
		return payerDetailId;
	}

	@ReferDeserialTransfer
	public void setPayerDetailId(Long payerDetailId) {
		this.payerDetailId = payerDetailId;
	}

	public String getPayerDetailCode() {
		return payerDetailCode;
	}

	public void setPayerDetailCode(String payerDetailCode) {
		this.payerDetailCode = payerDetailCode;
	}

	public String getPayerDetailName() {
		return payerDetailName;
	}

	public void setPayerDetailName(String payerDetailName) {
		this.payerDetailName = payerDetailName;
	}

	public Long getUserId() {
		return userId;
	}

	public void setUserId(Long userId) {
		this.userId = userId;
	}

	public String getUserCode() {
		return userCode;
	}

	public void setUserCode(String userCode) {
		this.userCode = userCode;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public Long getSourceUserId() {
		return sourceUserId;
	}

	public void setSourceUserId(Long sourceUserId) {
		this.sourceUserId = sourceUserId;
	}

	public String getSourceUserCode() {
		return sourceUserCode;
	}

	public void setSourceUserCode(String sourceUserCode) {
		this.sourceUserCode = sourceUserCode;
	}

	public String getSourceUserName() {
		return sourceUserName;
	}

	public void setSourceUserName(String sourceUserName) {
		this.sourceUserName = sourceUserName;
	}

	public Long getSourceBillId() {
		return sourceBillId;
	}

	public void setSourceBillId(Long sourceBillId) {
		this.sourceBillId = sourceBillId;
	}

	public String getSourceBillCode() {
		return sourceBillCode;
	}

	public void setSourceBillCode(String sourceBillCode) {
		this.sourceBillCode = sourceBillCode;
	}

	public String getSourceBillName() {
		return sourceBillName;
	}

	public void setSourceBillName(String sourceBillName) {
		this.sourceBillName = sourceBillName;
	}

	public String getSourceBillType() {
		return sourceBillType;
	}

	public void setSourceBillType(String sourceBillType) {
		this.sourceBillType = sourceBillType;
	}

	public Long getSourcePayerId() {
		return sourcePayerId;
	}

	public void setSourcePayerId(Long sourcePayerId) {
		this.sourcePayerId = sourcePayerId;
	}

	public Long getSourceOrgId() {
		return sourceOrgId;
	}

	public void setSourceOrgId(Long sourceOrgId) {
		this.sourceOrgId = sourceOrgId;
	}

	public String getSourceOrgCode() {
		return sourceOrgCode;
	}

	public void setSourceOrgCode(String sourceOrgCode) {
		this.sourceOrgCode = sourceOrgCode;
	}

	public String getSourceOrgName() {
		return sourceOrgName;
	}

	public void setSourceOrgName(String sourceOrgName) {
		this.sourceOrgName = sourceOrgName;
	}

	public Integer getSourcePeriodizationFlag() {
		return sourcePeriodizationFlag;
	}

	public void setSourcePeriodizationFlag(Integer sourcePeriodizationFlag) {
		this.sourcePeriodizationFlag = sourcePeriodizationFlag;
	}

	public BigDecimal getSourcePayerMny() {
		return sourcePayerMny;
	}

	public void setSourcePayerMny(BigDecimal sourcePayerMny) {
		this.sourcePayerMny = sourcePayerMny;
	}

	public BigDecimal getSourceActualPayerMny() {
		return sourceActualPayerMny;
	}

	public void setSourceActualPayerMny(BigDecimal sourceActualPayerMny) {
		this.sourceActualPayerMny = sourceActualPayerMny;
	}

	public BigDecimal getSourcePayScale() {
		return sourcePayScale;
	}

	public void setSourcePayScale(BigDecimal sourcePayScale) {
		this.sourcePayScale = sourcePayScale;
	}

	public BigDecimal getSourceRemainderPayerMny() {
		return sourceRemainderPayerMny;
	}

	public void setSourceRemainderPayerMny(BigDecimal sourceRemainderPayerMny) {
		this.sourceRemainderPayerMny = sourceRemainderPayerMny;
	}

	public BigDecimal getSourcePeriodizationMny() {
		return sourcePeriodizationMny;
	}

	public void setSourcePeriodizationMny(BigDecimal sourcePeriodizationMny) {
		this.sourcePeriodizationMny = sourcePeriodizationMny;
	}

	public Integer getSourcePeriodizationNum() {
		return sourcePeriodizationNum;
	}

	public void setSourcePeriodizationNum(Integer sourcePeriodizationNum) {
		this.sourcePeriodizationNum = sourcePeriodizationNum;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public String getTypeName() {
		return typeName;
	}

	public void setTypeName(String typeName) {
		this.typeName = typeName;
	}

	public BigDecimal getPayerMny() {
		return payerMny;
	}

	public void setPayerMny(BigDecimal payerMny) {
		this.payerMny = payerMny;
	}

	public BigDecimal getPayTaxMny() {
		return payTaxMny;
	}

	public void setPayTaxMny(BigDecimal payTaxMny) {
		this.payTaxMny = payTaxMny;
	}

	public BigDecimal getLastPayTaxMny() {
		return lastPayTaxMny;
	}

	public void setLastPayTaxMny(BigDecimal lastPayTaxMny) {
		this.lastPayTaxMny = lastPayTaxMny;
	}

	public BigDecimal getTotalTaxMny() {
		return totalTaxMny;
	}

	public void setTotalTaxMny(BigDecimal totalTaxMny) {
		this.totalTaxMny = totalTaxMny;
	}

	public BigDecimal getPayScale() {
		return payScale;
	}

	public void setPayScale(BigDecimal payScale) {
		this.payScale = payScale;
	}

	public BigDecimal getRemainPayTaxMny() {
		return remainPayTaxMny;
	}

	public void setRemainPayTaxMny(BigDecimal remainPayTaxMny) {
		this.remainPayTaxMny = remainPayTaxMny;
	}

	public String getInstallmentFlag() {
		return installmentFlag;
	}

	public void setInstallmentFlag(String installmentFlag) {
		this.installmentFlag = installmentFlag;
	}

	public String getInstallmentFlagName() {
		return installmentFlagName;
	}

	public void setInstallmentFlagName(String installmentFlagName) {
		this.installmentFlagName = installmentFlagName;
	}

	public Date getPayDate() {
		return payDate;
	}

	public void setPayDate(Date payDate) {
		this.payDate = payDate;
	}

	public BigDecimal getInstallmentTaxMny() {
		return installmentTaxMny;
	}

	public void setInstallmentTaxMny(BigDecimal installmentTaxMny) {
		this.installmentTaxMny = installmentTaxMny;
	}

	public Integer getInstallmentNum() {
		return installmentNum;
	}

	public void setInstallmentNum(Integer installmentNum) {
		this.installmentNum = installmentNum;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Integer getConfirmStatus() {
		return confirmStatus;
	}

	public void setConfirmStatus(Integer confirmStatus) {
		this.confirmStatus = confirmStatus;
	}

	public String getConfirmStatusName() {
		return confirmStatusName;
	}

	public void setConfirmStatusName(String confirmStatusName) {
		this.confirmStatusName = confirmStatusName;
	}

	public Date getConfirmDate() {
		return confirmDate;
	}

	public void setConfirmDate(Date confirmDate) {
		this.confirmDate = confirmDate;
	}

	public Long getConfirmUserId() {
		return confirmUserId;
	}

	public void setConfirmUserId(Long confirmUserId) {
		this.confirmUserId = confirmUserId;
	}

	public String getConfirmUserName() {
		return confirmUserName;
	}

	public void setConfirmUserName(String confirmUserName) {
		this.confirmUserName = confirmUserName;
	}

	public String getConfirmUserCode() {
		return confirmUserCode;
	}

	public void setConfirmUserCode(String confirmUserCode) {
		this.confirmUserCode = confirmUserCode;
	}

	public String getRealOrgName() {
		return realOrgName;
	}

	public void setRealOrgName(String realOrgName) {
		this.realOrgName = realOrgName;
	}
}
