package com.ejianc.business.cash.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 兑现计算表
 * 
 * @author generator
 * 
 */
public class CashVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectOrgId; // 项目所属组织id
    private String projectOrgCode; // 项目所属组织编码
    private String projectOrgName; // 项目所属组织名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String nodeStage; // 节点阶段
    private BigDecimal approveCostMny; // 审定造价
    private BigDecimal payEngineeringMny; // 已收工程款
    private BigDecimal costMny; // 已归集实际成本
    private BigDecimal taxMny; // 应缴税金
    private BigDecimal payTaxMny; // 已交税金
    private BigDecimal managementMny; // 应交管理费
    private BigDecimal payManagementMny; // 已缴管理费
    private BigDecimal projectPhaseMny; // 项目盈亏金额
    private BigDecimal corpProfitMny; // 应交公司利润
    private BigDecimal payCorpProfitMny; // 已缴公司利润
    private BigDecimal projectCashMny; // 项目应兑现金额
    private BigDecimal payProjectCashMny; // 已预支兑现
    private BigDecimal deductionMny; // 未完成责任指标扣款
    private BigDecimal riskDeductionMny; // 风险金抵扣
    private BigDecimal examineCashMny; // 考核兑现金额
    private String memo; // 备注
    private String billCode; // 单据编码
    private Integer approveFlag; // 是否被兑现审批引用  1-引用  0-未引用

    public Integer getApproveFlag() {
        return approveFlag;
    }

    public void setApproveFlag(Integer approveFlag) {
        this.approveFlag = approveFlag;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }
    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getNodeStage() {
        return nodeStage;
    }

    public void setNodeStage(String nodeStage) {
        this.nodeStage = nodeStage;
    }
    public BigDecimal getApproveCostMny() {
        return approveCostMny;
    }

    public void setApproveCostMny(BigDecimal approveCostMny) {
        this.approveCostMny = approveCostMny;
    }
    public BigDecimal getPayEngineeringMny() {
        return payEngineeringMny;
    }

    public void setPayEngineeringMny(BigDecimal payEngineeringMny) {
        this.payEngineeringMny = payEngineeringMny;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getPayTaxMny() {
        return payTaxMny;
    }

    public void setPayTaxMny(BigDecimal payTaxMny) {
        this.payTaxMny = payTaxMny;
    }
    public BigDecimal getManagementMny() {
        return managementMny;
    }

    public void setManagementMny(BigDecimal managementMny) {
        this.managementMny = managementMny;
    }
    public BigDecimal getPayManagementMny() {
        return payManagementMny;
    }

    public void setPayManagementMny(BigDecimal payManagementMny) {
        this.payManagementMny = payManagementMny;
    }
    public BigDecimal getProjectPhaseMny() {
        return projectPhaseMny;
    }

    public void setProjectPhaseMny(BigDecimal projectPhaseMny) {
        this.projectPhaseMny = projectPhaseMny;
    }
    public BigDecimal getCorpProfitMny() {
        return corpProfitMny;
    }

    public void setCorpProfitMny(BigDecimal corpProfitMny) {
        this.corpProfitMny = corpProfitMny;
    }
    public BigDecimal getPayCorpProfitMny() {
        return payCorpProfitMny;
    }

    public void setPayCorpProfitMny(BigDecimal payCorpProfitMny) {
        this.payCorpProfitMny = payCorpProfitMny;
    }
    public BigDecimal getProjectCashMny() {
        return projectCashMny;
    }

    public void setProjectCashMny(BigDecimal projectCashMny) {
        this.projectCashMny = projectCashMny;
    }
    public BigDecimal getPayProjectCashMny() {
        return payProjectCashMny;
    }

    public void setPayProjectCashMny(BigDecimal payProjectCashMny) {
        this.payProjectCashMny = payProjectCashMny;
    }
    public BigDecimal getDeductionMny() {
        return deductionMny;
    }

    public void setDeductionMny(BigDecimal deductionMny) {
        this.deductionMny = deductionMny;
    }
    public BigDecimal getRiskDeductionMny() {
        return riskDeductionMny;
    }

    public void setRiskDeductionMny(BigDecimal riskDeductionMny) {
        this.riskDeductionMny = riskDeductionMny;
    }
    public BigDecimal getExamineCashMny() {
        return examineCashMny;
    }

    public void setExamineCashMny(BigDecimal examineCashMny) {
        this.examineCashMny = examineCashMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
