package com.ejianc.business.collect.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;


/**
 * 兑现计算汇总表
 * 
 * @author generator
 * 
 */
public class CollectVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectOrgId; // 项目所属组织id
    private String projectOrgCode; // 项目所属组织编码
    private String projectOrgName; // 项目所属组织名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String nodeStage; // 节点阶段
    private BigDecimal engineeringMny; // 工程造价
    private BigDecimal engineeringTax; // 工程税金
    private BigDecimal rgMny; // 人工费
    private BigDecimal materialMny; // 材料费
    private BigDecimal equipmentMny; // 机械使用费
    private BigDecimal zjMny; // 其他直接费
    private BigDecimal jjMny; // 现场间接费
    private BigDecimal subMny; // 专业分包
    private BigDecimal otherMny; // 其他
    private BigDecimal managementMny; // 应交公司管理费
    private BigDecimal profitMny; // 应上交公司利润
    private BigDecimal shareProfitMny; // 项目分配兑现利润
    private BigDecimal receivedMny; // 已收工程款
    private String memo; // 备注
    private Integer approveFlag; // 是否被兑现审批引用  1-引用  0-未引用

    public Integer getApproveFlag() {
        return approveFlag;
    }

    public void setApproveFlag(Integer approveFlag) {
        this.approveFlag = approveFlag;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }
    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getNodeStage() {
        return nodeStage;
    }

    public void setNodeStage(String nodeStage) {
        this.nodeStage = nodeStage;
    }
    public BigDecimal getEngineeringMny() {
        return engineeringMny;
    }

    public void setEngineeringMny(BigDecimal engineeringMny) {
        this.engineeringMny = engineeringMny;
    }
    public BigDecimal getEngineeringTax() {
        return engineeringTax;
    }

    public void setEngineeringTax(BigDecimal engineeringTax) {
        this.engineeringTax = engineeringTax;
    }
    public BigDecimal getRgMny() {
        return rgMny;
    }

    public void setRgMny(BigDecimal rgMny) {
        this.rgMny = rgMny;
    }
    public BigDecimal getMaterialMny() {
        return materialMny;
    }

    public void setMaterialMny(BigDecimal materialMny) {
        this.materialMny = materialMny;
    }
    public BigDecimal getEquipmentMny() {
        return equipmentMny;
    }

    public void setEquipmentMny(BigDecimal equipmentMny) {
        this.equipmentMny = equipmentMny;
    }
    public BigDecimal getZjMny() {
        return zjMny;
    }

    public void setZjMny(BigDecimal zjMny) {
        this.zjMny = zjMny;
    }
    public BigDecimal getJjMny() {
        return jjMny;
    }

    public void setJjMny(BigDecimal jjMny) {
        this.jjMny = jjMny;
    }
    public BigDecimal getSubMny() {
        return subMny;
    }

    public void setSubMny(BigDecimal subMny) {
        this.subMny = subMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getManagementMny() {
        return managementMny;
    }

    public void setManagementMny(BigDecimal managementMny) {
        this.managementMny = managementMny;
    }
    public BigDecimal getProfitMny() {
        return profitMny;
    }

    public void setProfitMny(BigDecimal profitMny) {
        this.profitMny = profitMny;
    }
    public BigDecimal getShareProfitMny() {
        return shareProfitMny;
    }

    public void setShareProfitMny(BigDecimal shareProfitMny) {
        this.shareProfitMny = shareProfitMny;
    }
    public BigDecimal getReceivedMny() {
        return receivedMny;
    }

    public void setReceivedMny(BigDecimal receivedMny) {
        this.receivedMny = receivedMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
