package com.ejianc.business.approve.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.approve.vo.ApproveCashVO;
import com.ejianc.business.approve.vo.ApproveCollectVO;

/**
 * 考核兑现审批表
 * 
 * @author generator
 * 
 */
public class ApproveVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectOrgId; // 项目所属组织id
    private String projectOrgCode; // 项目所属组织编码
    private String projectOrgName; // 项目所属组织名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private String nodeStage; // 节点阶段
    private String projectManager; // 项目经理
    private String projectBookCode; // 项目责任书编号
    private Long contractId; // 合同名称id
    private String contractCode; // 合同编码
    private String contractName; // 合同名称
    private BigDecimal contractMny; // 合同造价
    private BigDecimal approveCostMny; // 审定造价
    private BigDecimal projectCostMny; // 项目责任成本
    private BigDecimal managementMny; // 应交公司管理费
    private BigDecimal payManagementMny; // 已缴公司管理费
    private String engineeringSituation; // 工程交验情况
    private BigDecimal projectPhaseMny; // 项目盈利或亏损金额
    private BigDecimal projectLoanMny; // 项目借款
    private String completedDoc; // 竣工资料归档情况
    private BigDecimal riskDeductionMny; // 应缴风险抵押金
    private BigDecimal payRiskDeductionMny; // 已缴风险抵押金
    private BigDecimal qualityAccidentMny; // 质量事故损失金额
    private BigDecimal subEngineeringMny; // 分包工程造价
    private String subPaySituation; // 分包工程付款情况
    private BigDecimal safeAccidentMny; // 安全事故损失金额
    private String materialSituation; // 甲供材料核销情况
    private BigDecimal qualificationFundMny; // 质保金及期限
    private BigDecimal engineeringFundsMny; // 已收工程款
    private BigDecimal phaseFineMny; // 亏损及罚款扣兑现奖
    private BigDecimal otherMny; // 其他兑现奖款项
    private BigDecimal examineCashMny; // 考核兑现金额
    private String memo; // 备注
    private String billCode; // 单据编码

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    private List<ApproveCashVO> approveCashList = new ArrayList<>(); // 考核兑现审批_兑现计算子表
    private List<ApproveCollectVO> approveCollectList = new ArrayList<>(); // 考核兑现审批_兑现计算汇总子表

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }
    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getNodeStage() {
        return nodeStage;
    }

    public void setNodeStage(String nodeStage) {
        this.nodeStage = nodeStage;
    }
    public String getProjectManager() {
        return projectManager;
    }

    public void setProjectManager(String projectManager) {
        this.projectManager = projectManager;
    }
    public String getProjectBookCode() {
        return projectBookCode;
    }

    public void setProjectBookCode(String projectBookCode) {
        this.projectBookCode = projectBookCode;
    }
    @ReferSerialTransfer(referCode="pro-income-contract")
    public Long getContractId() {
        return contractId;
    }
    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getApproveCostMny() {
        return approveCostMny;
    }

    public void setApproveCostMny(BigDecimal approveCostMny) {
        this.approveCostMny = approveCostMny;
    }
    public BigDecimal getProjectCostMny() {
        return projectCostMny;
    }

    public void setProjectCostMny(BigDecimal projectCostMny) {
        this.projectCostMny = projectCostMny;
    }
    public BigDecimal getManagementMny() {
        return managementMny;
    }

    public void setManagementMny(BigDecimal managementMny) {
        this.managementMny = managementMny;
    }
    public BigDecimal getPayManagementMny() {
        return payManagementMny;
    }

    public void setPayManagementMny(BigDecimal payManagementMny) {
        this.payManagementMny = payManagementMny;
    }
    public String getEngineeringSituation() {
        return engineeringSituation;
    }

    public void setEngineeringSituation(String engineeringSituation) {
        this.engineeringSituation = engineeringSituation;
    }
    public BigDecimal getProjectPhaseMny() {
        return projectPhaseMny;
    }

    public void setProjectPhaseMny(BigDecimal projectPhaseMny) {
        this.projectPhaseMny = projectPhaseMny;
    }
    public BigDecimal getProjectLoanMny() {
        return projectLoanMny;
    }

    public void setProjectLoanMny(BigDecimal projectLoanMny) {
        this.projectLoanMny = projectLoanMny;
    }
    public String getCompletedDoc() {
        return completedDoc;
    }

    public void setCompletedDoc(String completedDoc) {
        this.completedDoc = completedDoc;
    }
    public BigDecimal getRiskDeductionMny() {
        return riskDeductionMny;
    }

    public void setRiskDeductionMny(BigDecimal riskDeductionMny) {
        this.riskDeductionMny = riskDeductionMny;
    }
    public BigDecimal getPayRiskDeductionMny() {
        return payRiskDeductionMny;
    }

    public void setPayRiskDeductionMny(BigDecimal payRiskDeductionMny) {
        this.payRiskDeductionMny = payRiskDeductionMny;
    }
    public BigDecimal getQualityAccidentMny() {
        return qualityAccidentMny;
    }

    public void setQualityAccidentMny(BigDecimal qualityAccidentMny) {
        this.qualityAccidentMny = qualityAccidentMny;
    }
    public BigDecimal getSubEngineeringMny() {
        return subEngineeringMny;
    }

    public void setSubEngineeringMny(BigDecimal subEngineeringMny) {
        this.subEngineeringMny = subEngineeringMny;
    }
    public String getSubPaySituation() {
        return subPaySituation;
    }

    public void setSubPaySituation(String subPaySituation) {
        this.subPaySituation = subPaySituation;
    }
    public BigDecimal getSafeAccidentMny() {
        return safeAccidentMny;
    }

    public void setSafeAccidentMny(BigDecimal safeAccidentMny) {
        this.safeAccidentMny = safeAccidentMny;
    }
    public String getMaterialSituation() {
        return materialSituation;
    }

    public void setMaterialSituation(String materialSituation) {
        this.materialSituation = materialSituation;
    }
    public BigDecimal getQualificationFundMny() {
        return qualificationFundMny;
    }

    public void setQualificationFundMny(BigDecimal qualificationFundMny) {
        this.qualificationFundMny = qualificationFundMny;
    }
    public BigDecimal getEngineeringFundsMny() {
        return engineeringFundsMny;
    }

    public void setEngineeringFundsMny(BigDecimal engineeringFundsMny) {
        this.engineeringFundsMny = engineeringFundsMny;
    }
    public BigDecimal getPhaseFineMny() {
        return phaseFineMny;
    }

    public void setPhaseFineMny(BigDecimal phaseFineMny) {
        this.phaseFineMny = phaseFineMny;
    }
    public BigDecimal getOtherMny() {
        return otherMny;
    }

    public void setOtherMny(BigDecimal otherMny) {
        this.otherMny = otherMny;
    }
    public BigDecimal getExamineCashMny() {
        return examineCashMny;
    }

    public void setExamineCashMny(BigDecimal examineCashMny) {
        this.examineCashMny = examineCashMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<ApproveCashVO> getApproveCashList() {
        return approveCashList;
     }

     public void setApproveCashList(List<ApproveCashVO> approveCashList) {
        this.approveCashList = approveCashList;
     }
     public List<ApproveCollectVO> getApproveCollectList() {
        return approveCollectList;
     }

     public void setApproveCollectList(List<ApproveCollectVO> approveCollectList) {
        this.approveCollectList = approveCollectList;
     }
}
