package com.ejianc.business.payer.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 风险金台账主表-缴纳人员明细
 * 
 * @author generator
 * 
 */
public class ReportPayerDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编码（缴纳标注编号）
    private String name; // 姓名
    private String job; // 角色
    private String phone; // 手机号
    private Integer existState; // 是否在场（0：否 1：是）

    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date payerBelongYear; // 缴纳员工明细所属年度



    private BigDecimal payerMnyWan; // 缴纳金额（万元）
    private BigDecimal actualPayerMnyWan; // 累计已缴纳金额（万元）
    private BigDecimal repayTaxMny; // 累计退还金额（万元）
    private BigDecimal actualPayerMny; // 实际缴纳金额（万元）
    private BigDecimal actualPayerRepayRatio; // 实际缴纳占比
    private BigDecimal shareOrgMny; // 分配金额（万元）
    private BigDecimal shareOrgMnyRatio; // 分配占比

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date leaveTime; // 离场时间
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date enterTime; // 进场时间
    private Integer presenceDays; // 在场天数


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getJob() {
        return job;
    }

    public void setJob(String job) {
        this.job = job;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public Integer getExistState() {
        return existState;
    }

    public void setExistState(Integer existState) {
        this.existState = existState;
    }

    public Date getPayerBelongYear() {
        return payerBelongYear;
    }

    public void setPayerBelongYear(Date payerBelongYear) {
        this.payerBelongYear = payerBelongYear;
    }

    public BigDecimal getPayerMnyWan() {
        return payerMnyWan;
    }

    public void setPayerMnyWan(BigDecimal payerMnyWan) {
        this.payerMnyWan = payerMnyWan;
    }

    public BigDecimal getActualPayerMnyWan() {
        return actualPayerMnyWan;
    }

    public void setActualPayerMnyWan(BigDecimal actualPayerMnyWan) {
        this.actualPayerMnyWan = actualPayerMnyWan;
    }

    public BigDecimal getRepayTaxMny() {
        return repayTaxMny;
    }

    public void setRepayTaxMny(BigDecimal repayTaxMny) {
        this.repayTaxMny = repayTaxMny;
    }

    public BigDecimal getActualPayerMny() {
        return actualPayerMny;
    }

    public void setActualPayerMny(BigDecimal actualPayerMny) {
        this.actualPayerMny = actualPayerMny;
    }

    public BigDecimal getActualPayerRepayRatio() {
        return actualPayerRepayRatio;
    }

    public void setActualPayerRepayRatio(BigDecimal actualPayerRepayRatio) {
        this.actualPayerRepayRatio = actualPayerRepayRatio;
    }

    public BigDecimal getShareOrgMny() {
        return shareOrgMny;
    }

    public void setShareOrgMny(BigDecimal shareOrgMny) {
        this.shareOrgMny = shareOrgMny;
    }

    public BigDecimal getShareOrgMnyRatio() {
        return shareOrgMnyRatio;
    }

    public void setShareOrgMnyRatio(BigDecimal shareOrgMnyRatio) {
        this.shareOrgMnyRatio = shareOrgMnyRatio;
    }

    public Date getLeaveTime() {
        return leaveTime;
    }

    public void setLeaveTime(Date leaveTime) {
        this.leaveTime = leaveTime;
    }

    public Date getEnterTime() {
        return enterTime;
    }

    public void setEnterTime(Date enterTime) {
        this.enterTime = enterTime;
    }

    public Integer getPresenceDays() {
        return presenceDays;
    }

    public void setPresenceDays(Integer presenceDays) {
        this.presenceDays = presenceDays;
    }
}
