package com.ejianc.business.share.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.share.vo.ShareDeptVO;
import com.ejianc.business.share.vo.ShareOrgVO;

/**
 * 激励/补亏分配
 * 
 * @author generator
 * 
 */
public class ShareVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 组织id
    private String orgCode; // 组织编码
    private String orgName; // 组织名称
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long projectOrgId; // 项目所属组织id
    private String projectOrgCode; // 项目所属组织编码
    private String projectOrgName; // 项目所属组织名称
    private Long employeeId; // 经办人id
    private String employeeName; // 经办人名称
    private Long departmentId; // 经办人部门id
    private String departmentCode; // 经办人部门编码
    private String departmentName; // 经办人部门名称
    private Long approveeId; // 兑现审批主键id
    private String approveeCode; // 兑现审批编码
    private Long standardId; // 标准表主键id
    private String standardCode; // 标准表编码
    private String nodeStage; // 绩效激励/补亏节点
    private String year; // 所属年度
    private BigDecimal examineCashMny; // 考核兑现金额
    private BigDecimal shareMny; // 本期分配总金额
    private BigDecimal shareSumMny; // 含本期累计分配总金额
    private BigDecimal lastShareMny; // 本期分配总金额--不含本期
    private String memo; // 备注
    
    private List<ShareDeptVO> shareDeptList = new ArrayList<>(); // 分配—项目分配明细
    private List<ShareOrgVO> shareOrgList = new ArrayList<>(); // 分配-直管部分配明细

    public BigDecimal getLastShareMny() {
        return lastShareMny;
    }

    public void setLastShareMny(BigDecimal lastShareMny) {
        this.lastShareMny = lastShareMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getProjectOrgId() {
        return projectOrgId;
    }

    public void setProjectOrgId(Long projectOrgId) {
        this.projectOrgId = projectOrgId;
    }
    public String getProjectOrgCode() {
        return projectOrgCode;
    }

    public void setProjectOrgCode(String projectOrgCode) {
        this.projectOrgCode = projectOrgCode;
    }
    public String getProjectOrgName() {
        return projectOrgName;
    }

    public void setProjectOrgName(String projectOrgName) {
        this.projectOrgName = projectOrgName;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    @ReferSerialTransfer(referCode = "idm-dept")
    public Long getDepartmentId() {
        return departmentId;
    }
    @ReferDeserialTransfer
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentCode() {
        return departmentCode;
    }

    public void setDepartmentCode(String departmentCode) {
        this.departmentCode = departmentCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    @ReferSerialTransfer(referCode="riskmortgage_approve")
    public Long getApproveeId() {
        return approveeId;
    }
    @ReferDeserialTransfer
    public void setApproveeId(Long approveeId) {
        this.approveeId = approveeId;
    }
    public String getApproveeCode() {
        return approveeCode;
    }

    public void setApproveeCode(String approveeCode) {
        this.approveeCode = approveeCode;
    }
    @ReferSerialTransfer(referCode="standard_ref")
    public Long getStandardId() {
        return standardId;
    }
    @ReferDeserialTransfer
    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }
    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }
    public String getNodeStage() {
        return nodeStage;
    }

    public void setNodeStage(String nodeStage) {
        this.nodeStage = nodeStage;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public BigDecimal getExamineCashMny() {
        return examineCashMny;
    }

    public void setExamineCashMny(BigDecimal examineCashMny) {
        this.examineCashMny = examineCashMny;
    }
    public BigDecimal getShareMny() {
        return shareMny;
    }

    public void setShareMny(BigDecimal shareMny) {
        this.shareMny = shareMny;
    }
    public BigDecimal getShareSumMny() {
        return shareSumMny;
    }

    public void setShareSumMny(BigDecimal shareSumMny) {
        this.shareSumMny = shareSumMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
     public List<ShareDeptVO> getShareDeptList() {
        return shareDeptList;
     }

     public void setShareDeptList(List<ShareDeptVO> shareDeptList) {
        this.shareDeptList = shareDeptList;
     }
     public List<ShareOrgVO> getShareOrgList() {
        return shareOrgList;
     }

     public void setShareOrgList(List<ShareOrgVO> shareOrgList) {
        this.shareOrgList = shareOrgList;
     }
}
