package com.ejianc.business.payer.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 风险金台账
 * 
 * @author generator
 * 
 */
public class ReportPayerVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
//    private String billCode; // 单据编号z
//    private Integer billState; // 单据状态
//    private Long standardId; // 申请标准表Id
//    private String standardCode; // 申请标准表code
//    private String standardName; // 申请标准表名称


    private Long orgId; // 申请组织Id
    private String orgCode; // 申请组织编码
    private String orgName; // 申请组织名称
    private String projectName; // 项目名称

    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private Date belongYear; // 所属年度
    private BigDecimal totalPayerMnyWan; // 应缴纳金额（万元）
    private BigDecimal totalActualPayMnyWan; // 累计已缴纳金额(万元)
    private BigDecimal totalRepayTaxMnyWan; // 累计退还金额(万元)
    private BigDecimal actualPayMnyWan; // 实际缴纳金额(万元)
    private BigDecimal totalShareOrgMnyWan; // 累计分配金额(万元)

    private String riskDepositType; // 风险金台账类型(directDept-直管部、projectDept-项目部)



    private List<ReportPayerDetailVO> detailList = new ArrayList<>(); // 缴纳人员
    private List<ReportPayerRecordVO> recordList = new ArrayList<>(); // 缴纳记录
    private List<ReportPayerShareVO> shareList = new ArrayList<>(); // 分配明细


    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Date getBelongYear() {
        return belongYear;
    }

    public void setBelongYear(Date belongYear) {
        this.belongYear = belongYear;
    }

    public BigDecimal getTotalPayerMnyWan() {
        return totalPayerMnyWan;
    }

    public void setTotalPayerMnyWan(BigDecimal totalPayerMnyWan) {
        this.totalPayerMnyWan = totalPayerMnyWan;
    }

    public BigDecimal getTotalActualPayMnyWan() {
        return totalActualPayMnyWan;
    }

    public void setTotalActualPayMnyWan(BigDecimal totalActualPayMnyWan) {
        this.totalActualPayMnyWan = totalActualPayMnyWan;
    }

    public BigDecimal getTotalRepayTaxMnyWan() {
        return totalRepayTaxMnyWan;
    }

    public void setTotalRepayTaxMnyWan(BigDecimal totalRepayTaxMnyWan) {
        this.totalRepayTaxMnyWan = totalRepayTaxMnyWan;
    }

    public BigDecimal getActualPayMnyWan() {
        return actualPayMnyWan;
    }

    public void setActualPayMnyWan(BigDecimal actualPayMnyWan) {
        this.actualPayMnyWan = actualPayMnyWan;
    }

    public BigDecimal getTotalShareOrgMnyWan() {
        return totalShareOrgMnyWan;
    }

    public void setTotalShareOrgMnyWan(BigDecimal totalShareOrgMnyWan) {
        this.totalShareOrgMnyWan = totalShareOrgMnyWan;
    }

    public String getRiskDepositType() {
        return riskDepositType;
    }

    public void setRiskDepositType(String riskDepositType) {
        this.riskDepositType = riskDepositType;
    }

    public List<ReportPayerDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<ReportPayerDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<ReportPayerRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ReportPayerRecordVO> recordList) {
        this.recordList = recordList;
    }

    public List<ReportPayerShareVO> getShareList() {
        return shareList;
    }

    public void setShareList(List<ReportPayerShareVO> shareList) {
        this.shareList = shareList;
    }
}
