package com.ejianc.business.payer.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 缴纳员工明细表主实体
 * 
 * @author generator
 * 
 */
public class EmployeeMnyVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long employeeId; // 人员id
    private String employeeName; // 人员名称
    private String phone; // 手机号
    private BigDecimal payTaxMny; //累计已缴纳金额（万元）

    private BigDecimal repayTaxMny; //累计退还金额（万元）

    private BigDecimal sjMny; //实际缴纳金额（万元）

    private BigDecimal shareMny; // 已分配金额（万元）

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    private List<EmployeePayVO> employeePayList = new ArrayList<>(); // 缴纳记录

    private List<EmployeeShareVO> employeeShareList = new ArrayList<>(); // 分配记录

    public List<EmployeePayVO> getEmployeePayList() {
        return employeePayList;
    }

    public void setEmployeePayList(List<EmployeePayVO> employeePayList) {
        this.employeePayList = employeePayList;
    }

    public List<EmployeeShareVO> getEmployeeShareList() {
        return employeeShareList;
    }

    public void setEmployeeShareList(List<EmployeeShareVO> employeeShareList) {
        this.employeeShareList = employeeShareList;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getPayTaxMny() {
        return payTaxMny;
    }

    public void setPayTaxMny(BigDecimal payTaxMny) {
        this.payTaxMny = payTaxMny;
    }

    public BigDecimal getRepayTaxMny() {
        return repayTaxMny;
    }

    public void setRepayTaxMny(BigDecimal repayTaxMny) {
        this.repayTaxMny = repayTaxMny;
    }

    public BigDecimal getSjMny() {
        return sjMny;
    }

    public void setSjMny(BigDecimal sjMny) {
        this.sjMny = sjMny;
    }

    public BigDecimal getShareMny() {
        return shareMny;
    }

    public void setShareMny(BigDecimal shareMny) {
        this.shareMny = shareMny;
    }
}
