package com.ejianc.business.pay.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 风险金缴纳表
 *
 * @author baipengyan
 */
@TableName("ejc_riskmortgage_pay")
public class PayEntity extends BaseEntity {
	private static final long serialVersionUID = 1L;

	@TableField(value = "org_id")
	private Long orgId; // 组织id
	@TableField(value = "org_code")
	private String orgCode; // 组织编码
	@TableField(value = "org_name")
	private String orgName; // 组织名称
	@TableField(value = "employee_id")
	private Long employeeId; // 经办人id
	@TableField(value = "employee_name")
	private String employeeName; // 经办人名称
	@TableField(value = "department_id")
	private Long departmentId; // 经办人部门id
	@TableField(value = "department_name")
	private String departmentName; // 经办人部门名称
	@TableField(value = "commit_date")
	private Date commitDate; // 提交日期
	@TableField(value = "commit_user_name")
	private String commitUserName; // 提交人名称
	@TableField(value = "commit_user_code")
	private String commitUserCode; // 提交人账号
	@TableField(value = "effective_date")
	private Date effectiveDate; // 生效日期
	@TableField(value = "bill_code")
	private String billCode; // 单据编码
	@TableField(value = "bill_name")
	private String billName; // 单据名称
	@TableField(value = "bill_type")
	private String billType; // 单据类型
	@TableField(value = "bill_state")
	private Integer billState; // 单据状态
	@TableField(value = "source_bill_id")
	private Long sourceBillId; // 来源单据id
	@TableField(value = "source_bill_code")
	private String sourceBillCode; // 来源单据编码
	@TableField(value = "source_bill_name")
	private String sourceBillName; // 来源单据名称
	@TableField(value = "source_bill_type")
	private String sourceBillType; // 来源单据类型
	@TableField(value = "type")
	private Integer type; // 类型（0：缴纳，1：调入）
	@TableField(value = "payer_mny")
	private BigDecimal payerMny; // 应缴纳金额
	@TableField(value = "pay_tax_mny")
	private BigDecimal payTaxMny; // 本期缴纳金额
	@TableField(value = "last_pay_tax_mny")
	private BigDecimal lastPayTaxMny; // 历史版本缴纳金额
	@TableField(value = "total_tax_mny")
	private BigDecimal totalTaxMny; // 含本期已缴纳金额
	@TableField(value = "pay_scale")
	private BigDecimal payScale; // 含本期已缴纳比例
	@TableField(value = "remain_pay_tax_mny")
	private BigDecimal remainPayTaxMny; // 剩余缴纳金额
	@TableField(value = "installment_flag")
	private Integer installmentFlag; // 是否分期（0：否，1：是）
	@TableField(value = "pay_date")
	private Date payDate; // 缴纳日期
	@TableField(value = "installment_tax_mny")
	private BigDecimal installmentTaxMny; // 分期金额
	@TableField(value = "installment_num")
	private Integer installmentNum; // 分期数
	@TableField(value = "memo")
	private String memo; // 备注
	@TableField(value = "confirm_status")
	private Integer confirmStatus; // 确认状态（0：待确认，1：确认中，2：已确认）
	@TableField(value = "confirm_date")
	private Date confirmDate; // 确认时间
	@TableField(value = "confirm_user_id")
	private Long confirmUserId; // 确认人id
	@TableField(value = "confirm_user_name")
	private String confirmUserName; // 确认人名称
	@TableField(value = "confirm_user_code")
	private String confirmUserCode; // 确认人账号


	public Long getOrgId() {
		return orgId;
	}

	public void setOrgId(Long orgId) {
		this.orgId = orgId;
	}

	public String getOrgCode() {
		return orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public String getOrgName() {
		return orgName;
	}

	public void setOrgName(String orgName) {
		this.orgName = orgName;
	}

	public Long getEmployeeId() {
		return employeeId;
	}

	public void setEmployeeId(Long employeeId) {
		this.employeeId = employeeId;
	}

	public String getEmployeeName() {
		return employeeName;
	}

	public void setEmployeeName(String employeeName) {
		this.employeeName = employeeName;
	}

	public Long getDepartmentId() {
		return departmentId;
	}

	public void setDepartmentId(Long departmentId) {
		this.departmentId = departmentId;
	}

	public String getDepartmentName() {
		return departmentName;
	}

	public void setDepartmentName(String departmentName) {
		this.departmentName = departmentName;
	}

	public Date getCommitDate() {
		return commitDate;
	}

	public void setCommitDate(Date commitDate) {
		this.commitDate = commitDate;
	}

	public String getCommitUserName() {
		return commitUserName;
	}

	public void setCommitUserName(String commitUserName) {
		this.commitUserName = commitUserName;
	}

	public String getCommitUserCode() {
		return commitUserCode;
	}

	public void setCommitUserCode(String commitUserCode) {
		this.commitUserCode = commitUserCode;
	}

	public Date getEffectiveDate() {
		return effectiveDate;
	}

	public void setEffectiveDate(Date effectiveDate) {
		this.effectiveDate = effectiveDate;
	}

	public String getBillCode() {
		return billCode;
	}

	public void setBillCode(String billCode) {
		this.billCode = billCode;
	}

	public String getBillName() {
		return billName;
	}

	public void setBillName(String billName) {
		this.billName = billName;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Integer getBillState() {
		return billState;
	}

	public void setBillState(Integer billState) {
		this.billState = billState;
	}

	public Long getSourceBillId() {
		return sourceBillId;
	}

	public void setSourceBillId(Long sourceBillId) {
		this.sourceBillId = sourceBillId;
	}

	public String getSourceBillCode() {
		return sourceBillCode;
	}

	public void setSourceBillCode(String sourceBillCode) {
		this.sourceBillCode = sourceBillCode;
	}

	public String getSourceBillName() {
		return sourceBillName;
	}

	public void setSourceBillName(String sourceBillName) {
		this.sourceBillName = sourceBillName;
	}

	public String getSourceBillType() {
		return sourceBillType;
	}

	public void setSourceBillType(String sourceBillType) {
		this.sourceBillType = sourceBillType;
	}

	public Integer getType() {
		return type;
	}

	public void setType(Integer type) {
		this.type = type;
	}

	public BigDecimal getPayerMny() {
		return payerMny;
	}

	public void setPayerMny(BigDecimal payerMny) {
		this.payerMny = payerMny;
	}

	public BigDecimal getPayTaxMny() {
		return payTaxMny;
	}

	public void setPayTaxMny(BigDecimal payTaxMny) {
		this.payTaxMny = payTaxMny;
	}

	public BigDecimal getLastPayTaxMny() {
		return lastPayTaxMny;
	}

	public void setLastPayTaxMny(BigDecimal lastPayTaxMny) {
		this.lastPayTaxMny = lastPayTaxMny;
	}

	public BigDecimal getTotalTaxMny() {
		return totalTaxMny;
	}

	public void setTotalTaxMny(BigDecimal totalTaxMny) {
		this.totalTaxMny = totalTaxMny;
	}

	public BigDecimal getPayScale() {
		return payScale;
	}

	public void setPayScale(BigDecimal payScale) {
		this.payScale = payScale;
	}

	public BigDecimal getRemainPayTaxMny() {
		return remainPayTaxMny;
	}

	public void setRemainPayTaxMny(BigDecimal remainPayTaxMny) {
		this.remainPayTaxMny = remainPayTaxMny;
	}

	public Integer getInstallmentFlag() {
		return installmentFlag;
	}

	public void setInstallmentFlag(Integer installmentFlag) {
		this.installmentFlag = installmentFlag;
	}

	public Date getPayDate() {
		return payDate;
	}

	public void setPayDate(Date payDate) {
		this.payDate = payDate;
	}

	public BigDecimal getInstallmentTaxMny() {
		return installmentTaxMny;
	}

	public void setInstallmentTaxMny(BigDecimal installmentTaxMny) {
		this.installmentTaxMny = installmentTaxMny;
	}

	public Integer getInstallmentNum() {
		return installmentNum;
	}

	public void setInstallmentNum(Integer installmentNum) {
		this.installmentNum = installmentNum;
	}

	public String getMemo() {
		return memo;
	}

	public void setMemo(String memo) {
		this.memo = memo;
	}

	public Integer getConfirmStatus() {
		return confirmStatus;
	}

	public void setConfirmStatus(Integer confirmStatus) {
		this.confirmStatus = confirmStatus;
	}

	public Date getConfirmDate() {
		return confirmDate;
	}

	public void setConfirmDate(Date confirmDate) {
		this.confirmDate = confirmDate;
	}

	public Long getConfirmUserId() {
		return confirmUserId;
	}

	public void setConfirmUserId(Long confirmUserId) {
		this.confirmUserId = confirmUserId;
	}

	public String getConfirmUserName() {
		return confirmUserName;
	}

	public void setConfirmUserName(String confirmUserName) {
		this.confirmUserName = confirmUserName;
	}

	public String getConfirmUserCode() {
		return confirmUserCode;
	}

	public void setConfirmUserCode(String confirmUserCode) {
		this.confirmUserCode = confirmUserCode;
	}

}
