package com.ejianc.business.payer.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.payer.bean.payerChangeDetailEntity;
/**
 * 缴纳员工明细变更表主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_riskmortgage_payer_change")
public class payerChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="standard_id")
    private Long standardId; // 申请标准表Id
    @TableField(value="standard_code")
    private String standardCode; // 申请标准表code
    @TableField(value="standard_name")
    private String standardName; // 申请标准表名称
    @TableField(value="org_id")
    private Long orgId; // 申请组织Id
    @TableField(value="org_name")
    private String orgName; // 申请组织名称
    @TableField(value="org_code")
    private String orgCode; // 申请组织编码
    @TableField(value="belong_year")
    private Date belongYear; // 所属年度
    @TableField(value="risk_deposit_mny")
    private BigDecimal riskDepositMny; // 风险金缴纳金额
    @TableField(value="total_payer_mny")
    private BigDecimal totalPayerMny; // 员工应缴纳金额
    @TableField(value="employee_id")
    private Long employeeId; // 经办人id（申请人）
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称（申请人）
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="effect_date")
    private Date effectDate; // 生效日期
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="before_change_payer_mny")
    private BigDecimal beforeChangePayerMny; // 变更前缴纳金额
    @TableField(value="changing_payer_mny")
    private BigDecimal changingPayerMny; // 变更中缴纳金额
    @TableField(value="direct_payer_id")
    private Long directPayerId; // 直管部缴纳员工明细id（用于数据引用）
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="risk_deposit_type")
    private String riskDepositType; // 风险保证金类型(directDept-直管部、projectDept-项目部)
    @TableField(value="change_items")
    private String changeItems; // 变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；
    @TableField(value="change_employee_id")
    private Long changeEmployeeId; // 变更经办人id
    @TableField(value="change_employee_name")
    private String changeEmployeeName; // 变更经办人名称
    @TableField(value="change_payer_mny")
    private BigDecimal changePayerMny; // 本次变更金额
    @TableField(value="change_scale")
    private BigDecimal changeScale; // 本次变更比例
    @TableField(value="change_reason")
    private String changeReason; // 变更原因描述
    @TableField(value="main_payer_id")
    private Long mainPayerId; // 缴纳员工明细主表id
    @TableField(value="main_payer_code")
    private String mainPayerCode; // 缴纳员工明细主表单据编码
    @TableField("base_mny")
    private BigDecimal baseMny; //初始版本金额
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="payerChangeDetailService", pidName = "changeId")//此处有pid="xxx"，默认值pid="pid"
    private List<payerChangeDetailEntity> detailList = new ArrayList<>(); // 缴纳员工明细变更表子实体
    

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getStandardId() {
        return standardId;
    }

    public void setStandardId(Long standardId) {
        this.standardId = standardId;
    }
    public String getStandardCode() {
        return standardCode;
    }

    public void setStandardCode(String standardCode) {
        this.standardCode = standardCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Date getBelongYear() {
        return belongYear;
    }

    public void setBelongYear(Date belongYear) {
        this.belongYear = belongYear;
    }
    public BigDecimal getRiskDepositMny() {
        return riskDepositMny;
    }

    public void setRiskDepositMny(BigDecimal riskDepositMny) {
        this.riskDepositMny = riskDepositMny;
    }
    public BigDecimal getTotalPayerMny() {
        return totalPayerMny;
    }

    public void setTotalPayerMny(BigDecimal totalPayerMny) {
        this.totalPayerMny = totalPayerMny;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getEffectDate() {
        return effectDate;
    }

    public void setEffectDate(Date effectDate) {
        this.effectDate = effectDate;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public BigDecimal getBeforeChangePayerMny() {
        return beforeChangePayerMny;
    }

    public void setBeforeChangePayerMny(BigDecimal beforeChangePayerMny) {
        this.beforeChangePayerMny = beforeChangePayerMny;
    }
    public BigDecimal getChangingPayerMny() {
        return changingPayerMny;
    }

    public void setChangingPayerMny(BigDecimal changingPayerMny) {
        this.changingPayerMny = changingPayerMny;
    }
    public Long getDirectPayerId() {
        return directPayerId;
    }

    public void setDirectPayerId(Long directPayerId) {
        this.directPayerId = directPayerId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getRiskDepositType() {
        return riskDepositType;
    }

    public void setRiskDepositType(String riskDepositType) {
        this.riskDepositType = riskDepositType;
    }
    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }
    public Long getChangeEmployeeId() {
        return changeEmployeeId;
    }

    public void setChangeEmployeeId(Long changeEmployeeId) {
        this.changeEmployeeId = changeEmployeeId;
    }
    public String getChangeEmployeeName() {
        return changeEmployeeName;
    }

    public void setChangeEmployeeName(String changeEmployeeName) {
        this.changeEmployeeName = changeEmployeeName;
    }
    public BigDecimal getChangePayerMny() {
        return changePayerMny;
    }

    public void setChangePayerMny(BigDecimal changePayerMny) {
        this.changePayerMny = changePayerMny;
    }
    public BigDecimal getChangeScale() {
        return changeScale;
    }

    public void setChangeScale(BigDecimal changeScale) {
        this.changeScale = changeScale;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public Long getMainPayerId() {
        return mainPayerId;
    }

    public void setMainPayerId(Long mainPayerId) {
        this.mainPayerId = mainPayerId;
    }
    public String getMainPayerCode() {
        return mainPayerCode;
    }

    public void setMainPayerCode(String mainPayerCode) {
        this.mainPayerCode = mainPayerCode;
    }

    public BigDecimal getBaseMny() {
        return baseMny;
    }

    public void setBaseMny(BigDecimal baseMny) {
        this.baseMny = baseMny;
    }

    public List<payerChangeDetailEntity> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<payerChangeDetailEntity> detailList) {
        this.detailList = detailList;
    }

    public String getStandardName() {
        return standardName;
    }

    public void setStandardName(String standardName) {
        this.standardName = standardName;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
}
