package com.ejianc.business.standard.service.impl;

import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.standard.vo.StandardDetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.standard.mapper.StandardDetailMapper;
import com.ejianc.business.standard.bean.StandardDetailEntity;
import com.ejianc.business.standard.service.IStandardDetailService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 风险金缴纳标准表子实体
 * 
 * @author generator
 * 
 */
@Service("standardDetailService")
public class StandardDetailServiceImpl extends BaseServiceImpl<StandardDetailMapper, StandardDetailEntity> implements IStandardDetailService{

    @Autowired
    private IContractPoolApi contractPoolApi;

    @Override
    public CommonResponse<List<StandardDetailVO>> queryProjectData(String projectIds, String standardId) {
        List<String> ids = Arrays.asList(projectIds.split(","));
        if (CollectionUtils.isNotEmpty(ids)){
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("projectId", new Parameter(QueryParam.IN, ids));
            queryParam.getParams().put("standardId", new Parameter(QueryParam.NE, standardId));

            List<StandardDetailEntity> detailList = super.queryList(queryParam);
            if (CollectionUtils.isNotEmpty(detailList)){
                String inUseProject = "";
                for (StandardDetailEntity detail : detailList) {
                    inUseProject = inUseProject + detail.getProjectName() + ",";
                }
                if (inUseProject.length() > 1){
                    inUseProject = inUseProject.substring(0, inUseProject.length() - 1);
                }
                return CommonResponse.error("项目：" + inUseProject + "已被其他标准表引用，请选择其他项目！");
            }
            QueryParam contractQuery = new QueryParam();
            contractQuery.getParams().put("projectId", new Parameter(QueryParam.IN, ids));
            contractQuery.getParams().put("sourceType", new Parameter(QueryParam.EQ, "CONTRACT_TYPE"));
            //通过项目id、合同类型（施工合同）去合同池中查询相对应的合同数据
            CommonResponse<List<ContractPoolVO>> resultData = contractPoolApi.queryList(contractQuery);
            List<StandardDetailVO> standardDetailVOList = new ArrayList<>();
            if (resultData.isSuccess()){
                List<ContractPoolVO> contractPoolVOList = resultData.getData();
                //如果合同池有数据
                if (CollectionUtils.isNotEmpty(contractPoolVOList)){
                    for (ContractPoolVO contractPoolVO : contractPoolVOList) {
                        StandardDetailVO standardDetailVO = new StandardDetailVO();
                        standardDetailVO.setSourceId(contractPoolVO.getProjectId());
                        standardDetailVO.setProjectId(contractPoolVO.getProjectId());
                        standardDetailVO.setProjectCode(contractPoolVO.getProjectCode());
                        standardDetailVO.setProjectName(contractPoolVO.getProjectName());
                        standardDetailVO.setContractCode(contractPoolVO.getContractCode());
                        standardDetailVO.setContractId(contractPoolVO.getContractId());
                        standardDetailVO.setContractMny(contractPoolVO.getContractMny());
                        standardDetailVO.setContractName(contractPoolVO.getContractName());
                        standardDetailVOList.add(standardDetailVO);
                    }
                }
                //如果合同池中数据数量和传入项目id数量不对应
                if (ids.size() != standardDetailVOList.size()){
                    if (CollectionUtils.isNotEmpty(standardDetailVOList)){
                        Map<Long, StandardDetailVO> standardDetailVOMap = standardDetailVOList.stream().collect(Collectors.toMap(StandardDetailVO::getProjectId, Function.identity(), (key1, key2) -> key2));
                        for (String projectId : ids) {
                            //给未查到的合同项目赋值
                            if (!standardDetailVOMap.containsKey(Long.valueOf(projectId))){
                                StandardDetailVO standardDetailVO = new StandardDetailVO();
                                standardDetailVO.setProjectId(Long.valueOf(projectId));
                                standardDetailVO.setSourceId(Long.valueOf(projectId));
                                standardDetailVOList.add(standardDetailVO);
                            }
                        }
                    }else {
                        for (String projectId : ids) {
                            StandardDetailVO standardDetailVO = new StandardDetailVO();
                            standardDetailVO.setProjectId(Long.valueOf(projectId));
                            standardDetailVO.setSourceId(Long.valueOf(projectId));
                            standardDetailVOList.add(standardDetailVO);
                        }
                    }
                }
            }else {
                //如果合同池没有相应的项目数据
                for (String projectId : ids) {
                    StandardDetailVO standardDetailVO = new StandardDetailVO();
                    standardDetailVO.setProjectId(Long.valueOf(projectId));
                    standardDetailVO.setSourceId(Long.valueOf(projectId));
                    standardDetailVOList.add(standardDetailVO);
                }
            }
            return CommonResponse.success("选择项目可以使用！", standardDetailVOList);
        }
        return CommonResponse.error("请传入正确的项目id参数！");
    }
}
