package com.ejianc.business.standard.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.core.response.QueryParam;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.standard.mapper.StandardMapper;
import com.ejianc.business.standard.bean.StandardEntity;
import com.ejianc.business.standard.service.IStandardService;

import java.util.HashMap;
import java.util.Map;

/**
 * 风险金缴纳标准表主实体
 * 
 * @author generator
 * 
 */
@Service("standardService")
public class StandardServiceImpl extends BaseServiceImpl<StandardMapper, StandardEntity> implements IStandardService{

    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(risk_deposit_mny) as totalPayMny, sum(base_mny) as totalBasePayMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }
}
