package com.ejianc.business.payer.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.payer.bean.PayerDetailEntity;
import com.ejianc.business.payer.vo.PayerVO;
import com.ejianc.business.standard.enums.ChangeStatusEnum;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.payer.mapper.payerMapper;
import com.ejianc.business.payer.bean.PayerEntity;
import com.ejianc.business.payer.service.IpayerService;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 缴纳员工明细表主实体
 * 
 * @author generator
 * 
 */
@Service("payerService")
public class payerServiceImpl extends BaseServiceImpl<payerMapper, PayerEntity> implements IpayerService{
    private static final String DIRECT_BILL_CODE = "DIRECT_DEPT_PAYER";//直管部 风险金缴纳标准编码
    private static final String PROJECT_BILL_CODE = "PROJECT_DEPT_PAYER";//项目部 风险金缴纳标准编码


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public Map<String, Object> countSumMny(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(risk_deposit_mny) as totalPayMny, sum(base_mny) as totalBasePayMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("totalPayMny", 0);
            resp.put("totalBasePayMny", 0);
        }
        return resp;
    }

    @Override
    public PayerVO insertOrUpdate(PayerVO payerVO) {
        PayerEntity entity = BeanMapper.map(payerVO, PayerEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(("directDept").equals(payerVO.getRiskDepositType()) ? DIRECT_BILL_CODE : PROJECT_BILL_CODE, InvocationInfoProxy.getTenantid(),payerVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(!billCode.isSuccess()) {
                logger.error("保存标准表失败，自动生成标准表单据编码失败: {}", billCode.getMsg());
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setId(IdWorker.getId());
            entity.setBillCode(billCode.getData());
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setBeforeChangePayerMny(payerVO.getTotalPayerMny());
            entity.setChangeVersion(0);
            entity.setBaseMny(payerVO.getTotalPayerMny());
            //设置子表字段
        }
        List<PayerDetailEntity> payerDetailList = entity.getDetailList();
        for (PayerDetailEntity detail : payerDetailList) {
            if (null == detail.getPayerOrgId()){
                detail.setPayerId(entity.getId());
                detail.setPayerCode(entity.getBillCode());
                detail.setPayerName(entity.getBillCode());
                detail.setPayerOrgCode(entity.getOrgCode());
                detail.setPayerOrgId(entity.getOrgId());
                detail.setPayerOrgName(entity.getOrgName());
                detail.setPayerBelongYear(entity.getBelongYear());
            }
            detail.setPayerEmployeeId(entity.getEmployeeId());
            detail.setPayerEmployeeName(entity.getEmployeeName());
        }

        super.saveOrUpdate(entity, false);
        PayerVO vo = BeanMapper.map(super.selectById(entity.getId()), PayerVO.class);
        return vo;
    }
}
