package com.ejianc.business.repay.service;

import com.ejianc.business.repay.vo.RepayVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.repay.bean.RepayEntity;

import java.util.List;

/**
 * 风险金退还表
 *
 * @author baipengyan
 */
public interface IRepayService extends IBaseService<RepayEntity> {

	/**
	 * 是否是最新单据
	 *
	 * @param billId 单据id
	 * @param userId 用户id
	 * @param orgId  组织id
	 *
	 * @return 是否是最新单据
	 */
	boolean isLatestBill(Long billId, Long userId, Long orgId);

	/**
	 * 风险金退还：批量确认
	 *
	 * @param repays 要确认的单据信息
	 */
	void batchConfirm(List<RepayVO> repays);
}
